<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Schema;

class CheckRoiPeriods extends Command
{
    protected $signature = 'roi:check-periods';
    protected $description = 'Check ROI periods for all schemas';

    public function handle()
    {
        $this->info('🔍 Checking ROI Periods for all schemas...');
        $this->newLine();

        $schemas = Schema::all();

        if ($schemas->count() === 0) {
            $this->info('No schemas found.');
            return Command::SUCCESS;
        }

        $this->table(
            ['Schema Name', 'ROI Period (Hours)', 'Return Interest (%)', 'Number of Periods'],
            $schemas->map(function ($schema) {
                return [
                    $schema->name,
                    $schema->roi_period ?? 'NOT SET',
                    $schema->return_interest,
                    $schema->number_of_period
                ];
            })->toArray()
        );

        $this->newLine();
        $this->info('✅ ROI Periods check completed!');
        
        return Command::SUCCESS;
    }
}