<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\RoiSchedule;
use App\Models\Invest;

class UpdateRoiSchedulePeriods extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'roi:update-periods';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update ROI schedule periods based on plan settings';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('Updating ROI schedule periods...');
        
        // Get all ROI schedules with their investments and schemas
        $roiSchedules = RoiSchedule::with(['invest.schema'])->get();
        
        $updatedCount = 0;
        
        foreach ($roiSchedules as $roiSchedule) {
            if ($roiSchedule->invest && $roiSchedule->invest->schema) {
                $correctPeriods = $roiSchedule->invest->schema->number_of_period ?? 30;
                
                if ($roiSchedule->total_cycles != $correctPeriods) {
                    $roiSchedule->update(['total_cycles' => $correctPeriods]);
                    $updatedCount++;
                    
                    $this->line("Updated ROI Schedule ID: {$roiSchedule->id}, Investment ID: {$roiSchedule->invest_id}, Periods: {$correctPeriods}");
                }
            }
        }
        
        $this->info("Updated {$updatedCount} ROI schedule periods.");
        
        return Command::SUCCESS;
    }
}
