<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ManualPaymentGateway;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ManualPaymentGatewayController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $gateways = ManualPaymentGateway::ordered()->get();
        return view('backend.manual-payment-gateways.index', compact('gateways'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backend.manual-payment-gateways.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'code' => 'required|string|max:255|unique:manual_payment_gateways,code',
            'wallet_address' => 'required|string|max:500',
            'qr_code' => 'nullable|string',
            'payment_instructions' => 'nullable|string',
            'network' => 'nullable|string|max:100',
            'minimum_amount' => 'required|numeric|min:0',
            'maximum_amount' => 'required|numeric|min:0',
            'fee_percentage' => 'nullable|numeric|min:0|max:100',
            'fee_fixed' => 'nullable|numeric|min:0',
            'currency' => 'required|string|max:10',
            'currency_symbol' => 'required|string|max:10',
            'status' => 'boolean',
            'sort_order' => 'nullable|integer|min:0'
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        ManualPaymentGateway::create($request->all());

        return redirect()->route('admin.manual-payment-gateways.index')
            ->with('success', 'Manual payment gateway created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(ManualPaymentGateway $manualPaymentGateway)
    {
        return view('backend.manual-payment-gateways.show', compact('manualPaymentGateway'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ManualPaymentGateway $manualPaymentGateway)
    {
        return view('backend.manual-payment-gateways.edit', compact('manualPaymentGateway'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, ManualPaymentGateway $manualPaymentGateway)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'code' => 'required|string|max:255|unique:manual_payment_gateways,code,' . $manualPaymentGateway->id,
            'wallet_address' => 'required|string|max:500',
            'qr_code' => 'nullable|string',
            'payment_instructions' => 'nullable|string',
            'network' => 'nullable|string|max:100',
            'minimum_amount' => 'required|numeric|min:0',
            'maximum_amount' => 'required|numeric|min:0',
            'fee_percentage' => 'nullable|numeric|min:0|max:100',
            'fee_fixed' => 'nullable|numeric|min:0',
            'currency' => 'required|string|max:10',
            'currency_symbol' => 'required|string|max:10',
            'status' => 'boolean',
            'sort_order' => 'nullable|integer|min:0'
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $manualPaymentGateway->update($request->all());

        return redirect()->route('admin.manual-payment-gateways.index')
            ->with('success', 'Manual payment gateway updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ManualPaymentGateway $manualPaymentGateway)
    {
        $manualPaymentGateway->delete();

        return redirect()->route('admin.manual-payment-gateways.index')
            ->with('success', 'Manual payment gateway deleted successfully.');
    }
}
