<?php

namespace App\Traits;

use Str;

trait ImageUpload
{
    protected $defaultAvatar = 'frontend/images/user.png';

    public function imageUploadTrait($query, $old = null): string // Taking input image as parameter
    {

        $allowExt = ['jpeg', 'png', 'jpg', 'gif', 'svg', 'pdf'];
        $ext = strtolower($query->getClientOriginalExtension());

        if ($query->getSize() > 5100000) {
            abort('406', 'max file size:5MB ');
        }

        if (!in_array($ext, $allowExt)) {
            abort('406', 'only allow : jpeg, png, jpg, gif, svg');
        }

        if ($old != null && $old != $this->defaultAvatar) {
            self::delete($old);
        }
        $image_name = Str::random(20);
        $image_full_name = $image_name . '.' . $ext;
        $upload_path = 'storage/app/public/';    //Creating Sub directory in Storage folder to put image
        $image_url = 'storage/' . $image_full_name;
        $success = $query->move($upload_path, $image_full_name);
        
        // Also copy to assets/storage for public access
        if (!file_exists('assets/storage')) {
            @mkdir('assets/storage', 0755, true);
        }
        @copy($upload_path . $image_full_name, 'assets/storage/' . $image_full_name);

        return $image_url; // Return storage path
    }

    protected function delete($path)
    {
        if (file_exists('public/assets/' . $path)) {
            @unlink('public/assets/' . $path);
        }
    }
}
