<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('manual_payment_gateways', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Gateway name (e.g., BEP20, Bitcoin, Ethereum)
            $table->string('code')->unique(); // Gateway code (e.g., bep20, bitcoin, ethereum)
            $table->string('wallet_address'); // Wallet address for deposits
            $table->text('qr_code')->nullable(); // QR code URL or base64
            $table->text('payment_instructions')->nullable(); // Payment instructions
            $table->string('network')->nullable(); // Network type (BEP20, Bitcoin, Ethereum, etc.)
            $table->decimal('minimum_amount', 15, 2)->default(10.00); // Minimum deposit amount
            $table->decimal('maximum_amount', 15, 2)->default(10000.00); // Maximum deposit amount
            $table->decimal('fee_percentage', 5, 2)->default(0.00); // Fee percentage
            $table->decimal('fee_fixed', 15, 2)->default(0.00); // Fixed fee amount
            $table->string('currency', 10)->default('USDT'); // Currency type
            $table->string('currency_symbol', 10)->default('$'); // Currency symbol
            $table->boolean('status')->default(true); // Active/Inactive status
            $table->integer('sort_order')->default(0); // Display order
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('manual_payment_gateways');
    }
};
