<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('schemas', function (Blueprint $table) {
            $table->unsignedInteger('display_order')->default(0)->after('id');
            $table->index('display_order');
        });
    }

    public function down(): void
    {
        Schema::table('schemas', function (Blueprint $table) {
            $table->dropIndex(['display_order']);
            $table->dropColumn('display_order');
        });
    }
};


