<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\DepositMethod;
use App\Models\Gateway;

class DepositMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create BEP20 gateway if not exists
        $gateway = Gateway::firstOrCreate(
            ['gateway_code' => 'bep20'],
            [
                'name' => 'BEP20',
                'gateway_code' => 'bep20',
                'logo' => 'bep20.png',
                'status' => 1,
            ]
        );

        // Create or update BEP20 deposit method
        DepositMethod::updateOrCreate(
            ['gateway_code' => 'bep20'],
            [
                'name' => 'BEP20',
                'gateway_code' => 'bep20',
                'type' => 'manual',
                'status' => 1,
                'minimum_deposit' => 10.00,
                'maximum_deposit' => 10000.00,
                'charge' => 0.00,
                'charge_type' => 'fixed',
                'currency' => 'USDT',
                'gateway_id' => 1,
                'currency_symbol' => '$',
                'rate' => 1.00,
                'payment_details' => json_encode([
                    'wallet_address' => '0x742d35Cc6634C0532925a3b8D4C9db96C4b4d8b6',
                    'qr_code' => 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=0x742d35Cc6634C0532925a3b8D4C9db96C4b4d8b6',
                    'network' => 'BEP20',
                    'instructions' => 'Send USDT to the wallet address above using BEP20 network'
                ]),
            ]
        );

        // Create Bitcoin gateway if not exists
        $btcGateway = Gateway::firstOrCreate(
            ['gateway_code' => 'bitcoin'],
            [
                'name' => 'Bitcoin',
                'gateway_code' => 'bitcoin',
                'logo' => 'bitcoin.png',
                'status' => 1,
            ]
        );

        // Create or update Bitcoin deposit method
        DepositMethod::updateOrCreate(
            ['gateway_code' => 'bitcoin'],
            [
                'name' => 'Bitcoin',
                'gateway_code' => 'bitcoin',
                'type' => 'manual',
                'status' => 1,
                'minimum_deposit' => 0.001,
                'maximum_deposit' => 1.000,
                'charge' => 0.00,
                'charge_type' => 'fixed',
                'currency' => 'BTC',
                'gateway_id' => 2,
                'currency_symbol' => '₿',
                'rate' => 0.000025,
                'payment_details' => json_encode([
                    'wallet_address' => '1A1zP1eP5QGefi2DMPTfTL5SLmv7DivfNa',
                    'qr_code' => 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=1A1zP1eP5QGefi2DMPTfTL5SLmv7DivfNa',
                    'network' => 'Bitcoin',
                    'instructions' => 'Send BTC to the wallet address above'
                ]),
            ]
        );

        // Create Ethereum gateway if not exists
        $ethGateway = Gateway::firstOrCreate(
            ['gateway_code' => 'ethereum'],
            [
                'name' => 'Ethereum',
                'gateway_code' => 'ethereum',
                'logo' => 'ethereum.png',
                'status' => 1,
            ]
        );

        // Create or update Ethereum deposit method
        DepositMethod::updateOrCreate(
            ['gateway_code' => 'ethereum'],
            [
                'name' => 'Ethereum',
                'gateway_code' => 'ethereum',
                'type' => 'manual',
                'status' => 1,
                'minimum_deposit' => 0.01,
                'maximum_deposit' => 10.00,
                'charge' => 0.00,
                'charge_type' => 'fixed',
                'currency' => 'ETH',
                'gateway_id' => 3,
                'currency_symbol' => 'Ξ',
                'rate' => 0.0004,
                'payment_details' => json_encode([
                    'wallet_address' => '0x742d35Cc6634C0532925a3b8D4C9db96C4b4d8b6',
                    'qr_code' => 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=0x742d35Cc6634C0532925a3b8D4C9db96C4b4d8b6',
                    'network' => 'Ethereum',
                    'instructions' => 'Send ETH to the wallet address above'
                ]),
            ]
        );

        $this->command->info('Deposit methods seeded successfully!');
    }
}