<?php

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}



namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}



namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}



namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}













namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}



namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}



namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}



namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}













namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}



namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}



namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}



namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}













namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}



namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}



namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}



namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}

namespace Database\Seeders;

use App\Models\WithdrawMethod;
use Illuminate\Database\Seeder;

class WithdrawMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $methods = [
            // Crypto Methods
            [
                'name' => 'Solana (SOL)',
                'icon' => '💎',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Arbitrum One (ARB)',
                'icon' => '🔵',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'BNB Smart Chain',
                'icon' => '🟡',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'USDT (TRC20/ERC20)',
                'icon' => '💰',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address', 'network']),
                'status' => true,
            ],
            [
                'name' => 'Bitcoin (BTC)',
                'icon' => '₿',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Ethereum (ETH)',
                'icon' => 'Ξ',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            [
                'name' => 'Tron (TRC20)',
                'icon' => '🔴',
                'type' => 'crypto',
                'min_amount' => 10,
                'max_amount' => 10000,
                'charge' => 5,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['wallet_address']),
                'status' => true,
            ],
            
            // Banking Methods
            [
                'name' => 'EasyPaisa',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'JazzCash',
                'icon' => '📱',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 50000,
                'charge' => 6,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title']),
                'status' => true,
            ],
            [
                'name' => 'Bank Transfer',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban', 'bank_name']),
                'status' => true,
            ],
            [
                'name' => 'HBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'UBL Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
            [
                'name' => 'MCB Bank',
                'icon' => '🏦',
                'type' => 'banking',
                'min_amount' => 10,
                'max_amount' => 100000,
                'charge' => 0,
                'rate' => 1,
                'currency' => 'USD',
                'fields' => json_encode(['account_number', 'account_title', 'iban']),
                'status' => true,
            ],
        ];

        foreach ($methods as $method) {
            WithdrawMethod::updateOrCreate(
                ['name' => $method['name']],
                $method
            );
        }
    }
}












