@extends('backend.layouts.app')

@section('title', 'Edit Deposit Method')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Deposit Method: {{ $depositMethod->name }}</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.deposit-methods.update', $depositMethod->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Method Name</label>
                                    <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $depositMethod->name) }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="gateway_code">Gateway Code</label>
                                    <input type="text" class="form-control" id="gateway_code" name="gateway_code" value="{{ old('gateway_code', $depositMethod->gateway_code) }}" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="type">Type</label>
                                    <select class="form-control" id="type" name="type" required>
                                        <option value="manual" {{ old('type', $depositMethod->type) == 'manual' ? 'selected' : '' }}>Manual</option>
                                        <option value="auto" {{ old('type', $depositMethod->type) == 'auto' ? 'selected' : '' }}>Auto</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">Status</label>
                                    <select class="form-control" id="status" name="status" required>
                                        <option value="1" {{ old('status', $depositMethod->status) == 1 ? 'selected' : '' }}>Active</option>
                                        <option value="0" {{ old('status', $depositMethod->status) == 0 ? 'selected' : '' }}>Inactive</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="minimum_deposit">Minimum Deposit</label>
                                    <input type="number" step="0.01" class="form-control" id="minimum_deposit" name="minimum_deposit" value="{{ old('minimum_deposit', $depositMethod->minimum_deposit) }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="maximum_deposit">Maximum Deposit</label>
                                    <input type="number" step="0.01" class="form-control" id="maximum_deposit" name="maximum_deposit" value="{{ old('maximum_deposit', $depositMethod->maximum_deposit) }}" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="charge">Charge</label>
                                    <input type="number" step="0.01" class="form-control" id="charge" name="charge" value="{{ old('charge', $depositMethod->charge) }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="charge_type">Charge Type</label>
                                    <select class="form-control" id="charge_type" name="charge_type" required>
                                        <option value="fixed" {{ old('charge_type', $depositMethod->charge_type) == 'fixed' ? 'selected' : '' }}>Fixed</option>
                                        <option value="percentage" {{ old('charge_type', $depositMethod->charge_type) == 'percentage' ? 'selected' : '' }}>Percentage</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="currency">Currency</label>
                                    <input type="text" class="form-control" id="currency" name="currency" value="{{ old('currency', $depositMethod->currency) }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="currency_symbol">Currency Symbol</label>
                                    <input type="text" class="form-control" id="currency_symbol" name="currency_symbol" value="{{ old('currency_symbol', $depositMethod->currency_symbol) }}" required>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="rate">Rate</label>
                            <input type="number" step="0.01" class="form-control" id="rate" name="rate" value="{{ old('rate', $depositMethod->rate) }}" required>
                        </div>

                        <hr>
                        <h5>Manual Deposit Payment Details</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="wallet_address">Wallet Address *</label>
                                    <input type="text" class="form-control" id="wallet_address" name="wallet_address" value="{{ old('wallet_address', json_decode($depositMethod->payment_details, true)['wallet_address'] ?? '') }}" placeholder="Enter wallet address" required>
                                    <small class="form-text text-muted">This address will be shown to users for deposits</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="qr_code">QR Code URL</label>
                                    <input type="url" class="form-control" id="qr_code" name="qr_code" value="{{ old('qr_code', json_decode($depositMethod->payment_details, true)['qr_code'] ?? '') }}" placeholder="Enter QR code image URL">
                                    <small class="form-text text-muted">Optional: QR code for easy scanning</small>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="payment_instructions">Payment Instructions</label>
                            <textarea class="form-control" id="payment_instructions" name="payment_instructions" rows="3" placeholder="Enter payment instructions for users...">{{ old('payment_instructions', json_decode($depositMethod->payment_details, true)['payment_instructions'] ?? '') }}</textarea>
                            <small class="form-text text-muted">Instructions that will be shown to users</small>
                        </div>

                        <hr>
                        <h6>Bank Details (optional)</h6>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_number">Account Number</label>
                                    @php $pd = json_decode($depositMethod->payment_details, true) ?? []; @endphp
                                    <input type="text" class="form-control" id="account_number" name="account_number" value="{{ old('account_number', $pd['account_number'] ?? '') }}" placeholder="e.g. 60010104197339">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="account_holder_name">Account Holder Name</label>
                                    <input type="text" class="form-control" id="account_holder_name" name="account_holder_name" value="{{ old('account_holder_name', $pd['account_holder_name'] ?? ($pd['account_name'] ?? '')) }}" placeholder="e.g. John Doe" oninput="window.__updatePaymentDetails && window.__updatePaymentDetails();">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bank_name">Bank Name</label>
                                    <input type="text" class="form-control" id="bank_name" name="bank_name" value="{{ old('bank_name', $pd['bank_name'] ?? '') }}" placeholder="e.g. MEEZAN BANK">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="branch_code">Branch Code / IBAN</label>
                                    <input type="text" class="form-control" id="branch_code" name="branch_code" value="{{ old('branch_code', $pd['branch_code'] ?? '') }}" placeholder="e.g. PK78MEZN...">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="payment_details">Raw Payment Details (JSON)</label>
                            <textarea class="form-control" id="payment_details" name="payment_details" rows="10" style="background:#ffffff;color:#000;" spellcheck="false" placeholder='{"payment_type":"bank_transfer","payment_instructions":"","account_number":"","account_holder_name":"","bank_name":"","branch_code":""}'>{{ old('payment_details', $depositMethod->payment_details) }}</textarea>
                            <small class="form-text text-muted">Editable. Changes here update the fields above, and vice versa.</small>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Deposit Method
                            </button>
                            <a href="{{ route('admin.deposit-methods.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back to List
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const walletAddressInput = document.getElementById('wallet_address');
    const qrCodeInput = document.getElementById('qr_code');
    const paymentDetailsTextarea = document.getElementById('payment_details');
    const accountNumberInput = document.getElementById('account_number');
    const accountHolderInput = document.getElementById('account_holder_name');
    const bankNameInput = document.getElementById('bank_name');
    const branchCodeInput = document.getElementById('branch_code');

    // Auto-generate QR code URL when wallet address changes
    walletAddressInput.addEventListener('input', function() {
        if (this.value && !qrCodeInput.value) {
            qrCodeInput.value = `https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=${encodeURIComponent(this.value)}`;
        }
    });

    // Update payment details JSON when individual fields change
    function updatePaymentDetails() {
        const walletAddress = walletAddressInput.value;
        const qrCode = qrCodeInput.value;
        const paymentInstructions = document.getElementById('payment_instructions').value;
        const accountNumber = (accountNumberInput.value || '').trim();
        const accountHolder = (accountHolderInput.value || '').trim();
        const bankName = (bankNameInput.value || '').trim();
        const branchCode = (branchCodeInput.value || '').trim();

        const paymentDetails = {
            payment_type: accountNumber || bankName ? 'bank_transfer' : (walletAddress ? 'crypto' : ''),
            payment_instructions: paymentInstructions,
            wallet_address: walletAddress || undefined,
            qr_code: qrCode || undefined,
            account_number: accountNumber || undefined,
            account_holder_name: accountHolder || undefined,
            bank_name: bankName || undefined,
            branch_code: branchCode || undefined,
        };

        paymentDetailsTextarea.value = JSON.stringify(paymentDetails, null, 2);
        window.__lastPaymentJson = paymentDetailsTextarea.value;
    }

    // Helper: surgically set a single key in JSON textarea (used for account holder hot-fix)
    function setJsonKey(key, value) {
        let obj = {};
        try { obj = JSON.parse(paymentDetailsTextarea.value || '{}'); } catch (e) {}
        if (value === '' || value == null) {
            delete obj[key];
        } else {
            obj[key] = value;
        }
        paymentDetailsTextarea.value = JSON.stringify(obj, null, 2);
    }

    function bindAll(el) {
        ['input','change','keyup','blur'].forEach(evt => el.addEventListener(evt, updatePaymentDetails));
    }
    bindAll(walletAddressInput);
    bindAll(qrCodeInput);
    bindAll(document.getElementById('payment_instructions'));
    bindAll(accountNumberInput);
    bindAll(accountHolderInput);
    // Force-sync holder name directly into JSON as user types
    ['input','change','keyup','blur'].forEach(evt => accountHolderInput.addEventListener(evt, function(){
        setJsonKey('account_holder_name', (accountHolderInput.value || '').trim());
    }));
    bindAll(bankNameInput);
    bindAll(branchCodeInput);
    
    // Parse JSON textarea into fields when changed manually
    paymentDetailsTextarea.addEventListener('input', function() {
        try {
            const obj = JSON.parse(this.value || '{}');
            walletAddressInput.value = obj.wallet_address || '';
            qrCodeInput.value = obj.qr_code || '';
            document.getElementById('payment_instructions').value = obj.payment_instructions || '';
            accountNumberInput.value = obj.account_number || '';
            accountHolderInput.value = obj.account_holder_name || obj.account_name || '';
            bankNameInput.value = obj.bank_name || '';
            branchCodeInput.value = obj.branch_code || '';
        } catch (e) {
            // ignore parse errors while typing
        }
    });
    
    // Initial sync: populate fields from existing JSON, then normalize
    paymentDetailsTextarea.dispatchEvent(new Event('input'));
    updatePaymentDetails();

    // As a safety net, keep JSON in sync while typing in any field
    document.querySelector('form').addEventListener('input', updatePaymentDetails);

    // Final guard: periodic sync in case some browsers miss input events
    window.__updatePaymentDetails = updatePaymentDetails;
    setInterval(function(){
        if (document.activeElement === paymentDetailsTextarea) return;
        updatePaymentDetails();
    }, 500);
});
</script>
@endsection

