<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Deposit Information</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <td><strong>Transaction ID:</strong></td>
                        <td>#{{ $deposit->id }}</td>
                    </tr>
                    <tr>
                        <td><strong>Amount:</strong></td>
                        <td>
                            <span class="fw-bold text-success">
                                {{ setting('currency_symbol', 'global') }}{{ number_format($deposit->amount, 2) }}
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Status:</strong></td>
                        <td>
                            @if($deposit->status === 'success')
                                <span class="badge bg-success">Approved</span>
                            @elseif($deposit->status === 'failed')
                                <span class="badge bg-danger">Rejected</span>
                            @else
                                <span class="badge bg-warning">Pending</span>
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Submitted At:</strong></td>
                        <td>{{ $deposit->created_at->format('M d, Y H:i:s') }}</td>
                    </tr>
                    @if($deposit->approval_cause)
                    <tr>
                        <td><strong>Admin Notes:</strong></td>
                        <td>{{ $deposit->approval_cause }}</td>
                    </tr>
                    @endif
                </table>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">User Information</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <td><strong>Username:</strong></td>
                        <td>{{ $deposit->user->username }}</td>
                    </tr>
                    <tr>
                        <td><strong>Email:</strong></td>
                        <td>{{ $deposit->user->email }}</td>
                    </tr>
                    <tr>
                        <td><strong>Phone:</strong></td>
                        <td>{{ $deposit->user->phone ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <td><strong>Current Balance:</strong></td>
                        <td>
                            <span class="fw-bold text-primary">
                                {{ setting('currency_symbol', 'global') }}{{ number_format($deposit->user->balance, 2) }}
                            </span>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Payment Details</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <td><strong>Payment Method:</strong></td>
                        <td>
                            <span class="badge bg-info">
                                {{ ucfirst($manualData['payment_method'] ?? 'N/A') }}
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Transaction Hash:</strong></td>
                        <td>
                            <code>{{ $manualData['transaction_hash'] ?? 'N/A' }}</code>
                        </td>
                    </tr>
                    @if(isset($manualData['notes']) && $manualData['notes'])
                    <tr>
                        <td><strong>User Notes:</strong></td>
                        <td>{{ $manualData['notes'] }}</td>
                    </tr>
                    @endif
                    <tr>
                        <td><strong>Proof File:</strong></td>
                        <td>
                            @if(isset($manualData['proof_file']))
                            <a href="{{ asset('assets/' . $manualData['proof_file']) }}" 
                               target="_blank" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-eye"></i> View Proof
                            </a>
                            @else
                            <span class="text-muted">No file uploaded</span>
                            @endif
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

@if(isset($manualData['proof_file']))
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Proof Document</h5>
            </div>
            <div class="card-body text-center">
                <img src="{{ asset('assets/' . $manualData['proof_file']) }}" 
                     alt="Payment Proof" 
                     class="img-fluid" 
                     style="max-height: 500px; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
            </div>
        </div>
    </div>
</div>
@endif

