@extends('backend.layouts.app')

@section('title', 'Withdraw Methods')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Withdraw Methods</h3>
                    <a href="{{ route('admin.withdraw.methods.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Add New Method
                    </a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert">
                                <span>&times;</span>
                            </button>
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Type</th>
                                    <th>Icon</th>
                                    <th>Min Amount</th>
                                    <th>Max Amount</th>
                                    <th>Fee</th>
                                    <th>Status</th>
                                    <th>Sort Order</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($methods as $method)
                                <tr>
                                    <td>{{ $method->id }}</td>
                                    <td>{{ $method->name }}</td>
                                    <td>
                                        <span class="badge badge-{{ $method->type === 'crypto' ? 'warning' : ($method->type === 'banking' ? 'info' : 'success') }}">
                                            {{ ucfirst($method->type) }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($method->icon)
                                            @if(strpos($method->icon, '.png') !== false || strpos($method->icon, '.jpg') !== false)
                                                <img src="{{ asset($method->icon) }}" alt="{{ $method->name }}" style="width: 24px; height: 24px;">
                                            @else
                                                <span style="font-size: 1.2rem;">{{ $method->icon }}</span>
                                            @endif
                                        @else
                                            <i class="fas fa-money-bill-wave"></i>
                                        @endif
                                    </td>
                                    <td>${{ number_format($method->min_amount, 2) }}</td>
                                    <td>${{ number_format($method->max_amount, 2) }}</td>
                                    <td>
                                        @if($method->fee_percentage > 0)
                                            {{ $method->fee_percentage }}%
                                        @endif
                                        @if($method->fee_fixed > 0)
                                            + ${{ number_format($method->fee_fixed, 2) }}
                                        @endif
                                        @if($method->fee_percentage == 0 && $method->fee_fixed == 0)
                                            FREE
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $method->is_active ? 'success' : 'danger' }}">
                                            {{ $method->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>{{ $method->sort_order }}</td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.withdraw.methods.edit', $method) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('admin.withdraw.methods.toggle', $method) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-{{ $method->is_active ? 'warning' : 'success' }}">
                                                    <i class="fas fa-{{ $method->is_active ? 'pause' : 'play' }}"></i>
                                                </button>
                                            </form>
                                            <form action="{{ route('admin.withdraw.methods.destroy', $method) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this method?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="10" class="text-center">No withdraw methods found.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

