@extends('backend.layouts.app')

@section('title', 'Withdraw Statistics')

@section('content')
<div class="container-fluid">
    <div class="row">
        <!-- Statistics Cards -->
        <div class="col-lg-3 col-md-6">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">{{ $stats['total_requests'] }}</h4>
                            <p class="card-text">Total Requests</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-list fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">{{ $stats['pending_requests'] }}</h4>
                            <p class="card-text">Pending Requests</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-clock fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">{{ $stats['approved_requests'] }}</h4>
                            <p class="card-text">Approved Requests</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-check fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4 class="card-title">{{ $stats['rejected_requests'] }}</h4>
                            <p class="card-text">Rejected Requests</p>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-times fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <!-- Financial Statistics -->
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Financial Overview</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="text-center p-3 border rounded">
                                <h3 class="text-success">${{ number_format($stats['total_amount'], 2) }}</h3>
                                <p class="text-muted">Total Amount</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="text-center p-3 border rounded">
                                <h3 class="text-info">${{ number_format($stats['total_fees'], 2) }}</h3>
                                <p class="text-muted">Total Fees</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Request Status Distribution</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span>Completed</span>
                                <span class="badge badge-success">{{ $stats['completed_requests'] }}</span>
                            </div>
                            <div class="progress mb-3" style="height: 8px;">
                                <div class="progress-bar bg-success" style="width: {{ $stats['total_requests'] > 0 ? ($stats['completed_requests'] / $stats['total_requests']) * 100 : 0 }}%"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span>Pending</span>
                                <span class="badge badge-warning">{{ $stats['pending_requests'] }}</span>
                            </div>
                            <div class="progress mb-3" style="height: 8px;">
                                <div class="progress-bar bg-warning" style="width: {{ $stats['total_requests'] > 0 ? ($stats['pending_requests'] / $stats['total_requests']) * 100 : 0 }}%"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <!-- Recent Requests -->
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title">Recent Withdraw Requests</h5>
                    <a href="{{ route('admin.withdraw.requests.index') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-eye"></i> View All
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>User</th>
                                    <th>Method</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $recentRequests = \App\Models\WithdrawRequest::with(['user', 'withdrawMethod'])
                                        ->latest()
                                        ->limit(10)
                                        ->get();
                                @endphp
                                @forelse($recentRequests as $request)
                                <tr>
                                    <td>#{{ $request->id }}</td>
                                    <td>
                                        <div>
                                            <strong>{{ $request->user->first_name }} {{ $request->user->last_name }}</strong><br>
                                            <small class="text-muted">{{ $request->user->username }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $request->withdrawMethod->type === 'crypto' ? 'warning' : ($request->withdrawMethod->type === 'banking' ? 'info' : 'success') }}">
                                            {{ $request->withdrawMethod->name }}
                                        </span>
                                    </td>
                                    <td>${{ number_format($request->amount, 2) }}</td>
                                    <td>
                                        <span class="badge badge-{{ $request->status === 'pending' ? 'warning' : ($request->status === 'approved' ? 'success' : ($request->status === 'rejected' ? 'danger' : 'primary')) }}">
                                            {{ ucfirst($request->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $request->created_at->format('M d, Y') }}</td>
                                    <td>
                                        <a href="{{ route('admin.withdraw.requests.show', $request) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">No withdraw requests found.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <!-- Quick Actions -->
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <a href="{{ route('admin.withdraw.methods.index') }}" class="btn btn-primary btn-block">
                                <i class="fas fa-cog"></i> Manage Methods
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="{{ route('admin.withdraw.requests.index', ['status' => 'pending']) }}" class="btn btn-warning btn-block">
                                <i class="fas fa-clock"></i> Pending Requests
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="{{ route('admin.withdraw.requests.index', ['status' => 'approved']) }}" class="btn btn-success btn-block">
                                <i class="fas fa-check"></i> Approved Requests
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="{{ route('admin.withdraw.methods.create') }}" class="btn btn-info btn-block">
                                <i class="fas fa-plus"></i> Add New Method
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

