<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <title>{{ __('Admin Login') }} - {{ setting('site_title', 'global') }}</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset(setting('site_favicon', 'global')) }}">
    
    <!-- CSS -->
    <link href="{{ asset('backend/css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/style.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/responsive.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/color.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/icofont.min.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/line-awesome.min.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/remixicon.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/flag-icon.min.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/owl.carousel.min.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/owl.theme.default.min.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/jquery.fancybox.min.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/select2.min.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/treeview.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/style.css') }}" rel="stylesheet">
    <link href="{{ asset('backend/css/custom.css') }}" rel="stylesheet">
</head>

<body class="admin-login">
    <div class="admin-login-wrapper">
        <div class="admin-login-container">
            <div class="admin-login-box">
                <div class="admin-login-header">
                    <div class="admin-login-logo">
                        <img src="{{ asset(setting('site_logo', 'global')) }}" alt="Logo">
                    </div>
                    <h2>{{ __('Admin Login') }}</h2>
                    <p>{{ __('Sign in to your admin account') }}</p>
                </div>
                
                <div class="admin-login-form">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    
                    <form method="POST" action="{{ route('admin.login') }}">
                        @csrf
                        
                        <div class="form-group">
                            <label for="email">{{ __('Email Address') }}</label>
                            <input type="email" 
                                   class="form-control @error('email') is-invalid @enderror" 
                                   id="email" 
                                   name="email" 
                                   value="{{ old('email') }}" 
                                   required 
                                   autocomplete="email" 
                                   autofocus>
                            @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="password">{{ __('Password') }}</label>
                            <input type="password" 
                                   class="form-control @error('password') is-invalid @enderror" 
                                   id="password" 
                                   name="password" 
                                   required 
                                   autocomplete="current-password">
                            @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <div class="form-check">
                                <input class="form-check-input" 
                                       type="checkbox" 
                                       name="remember" 
                                       id="remember" 
                                       {{ old('remember') ? 'checked' : '' }}>
                                <label class="form-check-label" for="remember">
                                    {{ __('Remember Me') }}
                                </label>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary btn-block">
                                {{ __('Login') }}
                            </button>
                        </div>
                    </form>
                </div>
                
                <div class="admin-login-footer">
                    <p>&copy; {{ date('Y') }} {{ setting('site_title', 'global') }}. {{ __('All rights reserved.') }}</p>
                </div>
            </div>
        </div>
    </div>
    
    <!-- JavaScript -->
    <script src="{{ asset('backend/js/jquery.min.js') }}"></script>
    <script src="{{ asset('backend/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('backend/js/script.js') }}"></script>
</body>
</html>