@extends('backend.deposit.index')
@section('title')
    {{ __(ucwords($type).' Method') }}
@endsection
@section('deposit_content')
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-xl-8">
                <div class="site-card">
                    <div class="site-card-body">
                        <form action="{{ route('admin.deposit.method.update',$method->id) }}" class="row" method="post"
                              enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="type" value="{{ $type }}">
                            <div class="col-xl-12">
                                <div class="row">
                                    <div class="col-xl-3">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for="">{{ __('Upload Logo:') }}</label>
                                            <div class="wrap-custom-file">
                                                <input
                                                    type="file"
                                                    name="logo"
                                                    id="schema-icon"
                                                    accept=".gif, .jpg, .png"
                                                />
                                                <label for="schema-icon" class="file-ok"
                                                       style="background-image: url({{ asset($method->logo ?? $method->gateway->logo) }})">
                                                    <img
                                                        class="upload-icon"
                                                        src="{{ asset('global/materials/upload.svg') }}"
                                                        alt=""
                                                    />
                                                    <span>{{ __('Update Logo') }}</span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            @if($type == 'auto')
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Automatic Gateway:') }}</label>
                                        <select name="gateway_id"
                                                class="form-select"
                                                id="gateway-select">
                                            @foreach($gateways as $gateway)
                                                <option data-currencies="{{ $gateway->supported_currencies }}"
                                                        data-gatewayCode="{{ $gateway->gateway_code }}"
                                                        value="{{$gateway->id}}" @selected($method->gateway_id == $gateway->id)> {{$gateway->name}}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label"
                                               for="">{{ __('Gateway Supported Currency:') }}</label>
                                        <select name="currency" class="form-select" id="currency">
                                            @foreach(json_decode($supported_currencies) as $currency)
                                                <option
                                                    value="{{ $currency }}" @selected($currency == $method->currency )>{{ $currency }} </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            @endif

                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for="">{{ __('Name:') }}</label>
                                    <input
                                        type="text"
                                        class="box-input"
                                        name="name"
                                        value="{{ $method->name }}"
                                    />
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for="">{{ __('Code Name') }}</label>
                                    <input
                                        type="text"
                                        class="box-input"
                                        disabled
                                        value="{{ $method->gateway_code }}"
                                    />
                                </div>
                            </div>
                            @if($type == 'manual')
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Currency:') }}</label>
                                        <input
                                            type="text"
                                            class="box-input"
                                            name="currency"
                                            value="{{$method->currency}}"
                                            id="currency"
                                        />
                                    </div>
                                </div>
                            @endif
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for="">{{ __('Currency Symbol:') }}</label>
                                    <input
                                        type="text"
                                        class="box-input"
                                        value="{{ $method->currency_symbol}}"
                                        name="currency_symbol"
                                    />
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups row">
                                    <div class="col-xl-12">
                                        <label class="box-input-label" for="">{{ __('Conversion Rate:') }}</label>
                                        <div class="input-group joint-input">
                                            <span
                                                class="input-group-text">{{'1 '.' '.setting('site_currency', 'global'). ' ='}} </span>
                                            <input type="text" name="rate" class="form-control"
                                                   value="{{$method->rate}}"/>


                                            <span class="input-group-text"
                                                  id="currency-selected">{{  is_custom_rate($method->gateway?->gateway_code) ?? $method->currency }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups position-relative">
                                    <label class="box-input-label" for="">{{ __('Charges:') }}</label>
                                    <div class="position-relative">
                                        <input type="text" class="box-input"
                                               oninput="this.value = validateDouble(this.value)" name="charge"
                                               value="{{ $method->charge }}"/>
                                        <div class="prcntcurr">
                                            <select name="charge_type" class="form-select">
                                                <option value="percentage"
                                                        @if($method->charge_type == 'percentage') selected @endif>{{ __('%') }}</option>
                                                <option value="fixed"
                                                        @if($method->charge_type == 'fixed') selected @endif>{{ $currencySymbol }}</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for="">{{ __('Minimum Deposit:') }}</label>
                                    <div class="input-group joint-input">
                                        <input type="text" name="minimum_deposit" class="form-control"
                                               value="{{ $method->minimum_deposit }}"/>
                                        <span class="input-group-text">{{ setting('site_currency', 'global') }}</span>
                                    </div>

                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for="">{{ __('Maximum Deposit:') }}</label>
                                    <div class="input-group joint-input">
                                        <input type="text" name="maximum_deposit" class="form-control"
                                               value="{{ $method->maximum_deposit }}"/>
                                        <span class="input-group-text">{{setting('site_currency', 'global')}}</span>
                                    </div>
                                </div>
                            </div>

                            @if($type == 'manual')
                                <div class="col-xl-3">
                                    <a href="javascript:void(0)" id="generate"
                                       class="site-btn-xs primary-btn mb-3">{{ __('Add Field option') }}</a>
                                </div>

                                <div class="addOptions">
                                    @foreach(json_decode($method->field_options,true) as $key => $value)
                                        <div class="mb-4">
                                            <div class="option-remove-row row">
                                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <div class="site-input-groups">
                                                        <input name="field_options[{{$key}}][name]" class="box-input"
                                                               type="text" value="{{$value['name']}}" required
                                                               placeholder="Field Name">
                                                    </div>
                                                </div>

                                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <div class="site-input-groups">
                                                        <select name="field_options[{{$key}}][type]"
                                                                class="form-select form-select-lg mb-3">
                                                            <option value="text"
                                                                    @if($value['type'] == 'text') selected @endif>Input
                                                                Text
                                                            </option>
                                                            <option value="textarea"
                                                                    @if($value['type'] == 'textarea') selected @endif>
                                                                Textarea
                                                            </option>
                                                            <option value="file"
                                                                    @if($value['type'] == 'file') selected @endif>File
                                                                upload
                                                            </option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <div class="site-input-groups mb-0">
                                                        <select name="field_options[{{ $key }}][validation]"
                                                                class="form-select form-select-lg mb-1">
                                                            <option value="required"
                                                                    @if($value['validation'] == 'required') selected @endif>
                                                                Required
                                                            </option>
                                                            <option value="nullable"
                                                                    @if($value['validation'] == 'nullable') selected @endif>
                                                                Optional
                                                            </option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <button class="delete-option-row delete_desc" type="button">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>

                                <div class="col-xl-12">
                                    <div class="site-input-groups fw-normal">
                                        <label for="" class="box-input-label">{{ __('Payment Details:') }}</label>
                                        <small class="form-text text-muted">{{ __('Configure payment details based on the method type') }}</small>
                                    </div>
                                </div>

                                <!-- Payment Type Selection -->
                                <div class="col-xl-12">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Payment Type:') }} <span class="text-danger">*</span></label>
                                        <select class="form-select" name="payment_type" id="payment_type" required>
                                            <option value="">Select Payment Type</option>
                                            <option value="easypaisa" {{ (json_decode($method->payment_details, true)['payment_type'] ?? '') == 'easypaisa' ? 'selected' : '' }}>EasyPaisa</option>
                                            <option value="jazzcash" {{ (json_decode($method->payment_details, true)['payment_type'] ?? '') == 'jazzcash' ? 'selected' : '' }}>JazzCash</option>
                                            <option value="bank_transfer" {{ (json_decode($method->payment_details, true)['payment_type'] ?? '') == 'bank_transfer' ? 'selected' : '' }}>Bank Transfer</option>
                                            <option value="crypto" {{ (json_decode($method->payment_details, true)['payment_type'] ?? '') == 'crypto' ? 'selected' : '' }}>Cryptocurrency</option>
                                        </select>
                                        <small class="form-text text-muted">{{ __('Select the type of payment method') }}</small>
                                    </div>
                                </div>

                                <!-- EasyPaisa Fields -->
                                <div id="easypaisa_fields" class="payment-type-fields" style="display: none;">
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for="">{{ __('EasyPaisa Account Number:') }} <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="easypaisa_account" value="{{ old('easypaisa_account', json_decode($method->payment_details, true)['easypaisa_account'] ?? '') }}" placeholder="Enter EasyPaisa account number">
                                            <small class="form-text text-muted">{{ __('EasyPaisa account number for deposits') }}</small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for="">{{ __('Account Holder Name:') }} <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="account_holder_name" value="{{ old('account_holder_name', json_decode($method->payment_details, true)['account_holder_name'] ?? '') }}" placeholder="Enter account holder name">
                                            <small class="form-text text-muted">{{ __('Name of the account holder') }}</small>
                                        </div>
                                    </div>
                                </div>

                                <!-- JazzCash Fields -->
                                <div id="jazzcash_fields" class="payment-type-fields" style="display: none;">
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for="">{{ __('JazzCash Account Number:') }} <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="jazzcash_account" value="{{ old('jazzcash_account', json_decode($method->payment_details, true)['jazzcash_account'] ?? '') }}" placeholder="Enter JazzCash account number">
                                            <small class="form-text text-muted">{{ __('JazzCash account number for deposits') }}</small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for="">{{ __('Account Holder Name:') }} <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="account_holder_name" value="{{ old('account_holder_name', json_decode($method->payment_details, true)['account_holder_name'] ?? '') }}" placeholder="Enter account holder name">
                                            <small class="form-text text-muted">{{ __('Name of the account holder') }}</small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Bank Transfer Fields -->
                                <div id="bank_transfer_fields" class="payment-type-fields" style="display: none;">
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for="">{{ __('Account Number:') }} <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="account_number" value="{{ old('account_number', json_decode($method->payment_details, true)['account_number'] ?? '') }}" placeholder="Enter bank account number">
                                            <small class="form-text text-muted">{{ __('Bank account number for deposits') }}</small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for="">{{ __('Account Holder Name:') }} <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="account_holder_name" value="{{ old('account_holder_name', json_decode($method->payment_details, true)['account_holder_name'] ?? '') }}" placeholder="Enter account holder name">
                                            <small class="form-text text-muted">{{ __('Name of the account holder') }}</small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for="">{{ __('Bank Name:') }} <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="bank_name" value="{{ old('bank_name', json_decode($method->payment_details, true)['bank_name'] ?? '') }}" placeholder="Enter bank name">
                                            <small class="form-text text-muted">{{ __('Name of the bank') }}</small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for="">{{ __('Branch Code:') }}</label>
                                            <input type="text" class="form-control" name="branch_code" value="{{ old('branch_code', json_decode($method->payment_details, true)['branch_code'] ?? '') }}" placeholder="Enter branch code">
                                            <small class="form-text text-muted">{{ __('Bank branch code (optional)') }}</small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Crypto Fields -->
                                <div id="crypto_fields" class="payment-type-fields" style="display: none;">
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for="">{{ __('Wallet Address:') }} <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="wallet_address" value="{{ old('wallet_address', json_decode($method->payment_details, true)['wallet_address'] ?? '') }}" placeholder="Enter wallet address">
                                            <small class="form-text text-muted">{{ __('Cryptocurrency wallet address') }}</small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for="">{{ __('Cryptocurrency Type:') }} <span class="text-danger">*</span></label>
                                            <select class="form-select" name="crypto_type">
                                                <option value="">Select Cryptocurrency</option>
                                                <option value="bitcoin" {{ (json_decode($method->payment_details, true)['crypto_type'] ?? '') == 'bitcoin' ? 'selected' : '' }}>Bitcoin (BTC)</option>
                                                <option value="ethereum" {{ (json_decode($method->payment_details, true)['crypto_type'] ?? '') == 'ethereum' ? 'selected' : '' }}>Ethereum (ETH)</option>
                                                <option value="usdt" {{ (json_decode($method->payment_details, true)['crypto_type'] ?? '') == 'usdt' ? 'selected' : '' }}>Tether (USDT)</option>
                                                <option value="usdc" {{ (json_decode($method->payment_details, true)['crypto_type'] ?? '') == 'usdc' ? 'selected' : '' }}>USD Coin (USDC)</option>
                                            </select>
                                            <small class="form-text text-muted">{{ __('Type of cryptocurrency') }}</small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for="">{{ __('Network:') }}</label>
                                            <select class="form-select" name="network">
                                                <option value="">Select Network</option>
                                                <option value="mainnet" {{ (json_decode($method->payment_details, true)['network'] ?? '') == 'mainnet' ? 'selected' : '' }}>Mainnet</option>
                                                <option value="bep20" {{ (json_decode($method->payment_details, true)['network'] ?? '') == 'bep20' ? 'selected' : '' }}>BEP20 (BSC)</option>
                                                <option value="erc20" {{ (json_decode($method->payment_details, true)['network'] ?? '') == 'erc20' ? 'selected' : '' }}>ERC20 (Ethereum)</option>
                                                <option value="trc20" {{ (json_decode($method->payment_details, true)['network'] ?? '') == 'trc20' ? 'selected' : '' }}>TRC20 (TRON)</option>
                                            </select>
                                            <small class="form-text text-muted">{{ __('Blockchain network') }}</small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for="">{{ __('QR Code URL:') }}</label>
                                            <input type="url" class="form-control" name="qr_code" value="{{ old('qr_code', json_decode($method->payment_details, true)['qr_code'] ?? '') }}" placeholder="Enter QR code image URL">
                                            <small class="form-text text-muted">{{ __('Optional: QR code for easy scanning') }}</small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Common Fields -->
                                <div class="col-xl-12">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Payment Instructions:') }}</label>
                                        <textarea class="form-control" name="payment_instructions" rows="3" placeholder="Enter payment instructions for users...">{{ old('payment_instructions', json_decode($method->payment_details, true)['payment_instructions'] ?? '') }}</textarea>
                                        <small class="form-text text-muted">{{ __('Instructions that will be shown to users') }}</small>
                                    </div>
                                </div>
                                
                                <div class="col-xl-12">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for="">{{ __('Raw Payment Details (JSON):') }}</label>
                                        <textarea class="form-control" name="payment_details" rows="4" placeholder='{"payment_type": "easypaisa", "easypaisa_account": "1234567890", "account_holder_name": "John Doe", "payment_instructions": "instructions"}' readonly>{{ old('payment_details', $method->payment_details) }}</textarea>
                                        <small class="form-text text-muted">{{ __('This JSON is automatically generated from the fields above') }}</small>
                                    </div>
                                </div>
                            @endif

                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for="">{{ __('Status:') }}</label>
                                    <div class="switch-field same-type">
                                        <input
                                            type="radio"
                                            id="radio-five"
                                            name="status"
                                            value="1"
                                            @if($method->status) checked @endif
                                        />
                                        <label for="radio-five">{{ __('Active') }}</label>
                                        <input
                                            type="radio"
                                            id="radio-six"
                                            name="status"
                                            value="0"
                                            @if(!$method->status) checked @endif
                                        />
                                        <label for="radio-six">{{ __('Deactivate') }}</label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-12">
                                <button type="submit" class="site-btn primary-btn w-100">
                                    {{ __('Save Changes') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        'use strict';

        var currency = @json(is_custom_rate($method->gateway?->gateway_code));

        $("#currency").on('change', function () {
            if (currency === null) {
                $('#currency-selected').text(this.value);
            }
        });

        if (null != @json($method->field_options)) {
            var i = Object.keys(JSON.parse(@json($method->field_options))).length;
            $("#generate").on('click', function () {
                ++i;
                var form = `<div class="mb-4">
              <div class="option-remove-row row">
                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups">
                    <input name="field_options[` + i + `][name]" class="box-input" type="text" value="" required placeholder="Field Name">
                  </div>
                </div>

                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups">
                    <select name="field_options[` + i + `][type]" class="form-select form-select-lg mb-3">
                        <option value="text">Input Text</option>
                        <option value="textarea">Textarea</option>
                        <option value="file">File upload</option>
                    </select>
                  </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups mb-0">
                    <select name="field_options[` + i + `][validation]" class="form-select form-select-lg mb-1">
                        <option value="required">Required</option>
                        <option value="nullable">Optional</option>
                    </select>
                  </div>
                </div>

                <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                  <button class="delete-option-row delete_desc" type="button">
                    <i class="fas fa-times"></i>
                  </button>
                </div>
                </div>
              </div>`;
                $('.addOptions').append(form)
            });

            $(document).on('click', '.delete_desc', function () {
                $(this).closest('.option-remove-row').parent().remove();
            });
        }

        $('#gateway-select').on('change', function () {
            var id = $(this).val();
            var url = '{{ route('admin.gateway.supported.currency',':id') }}';
            url = url.replace(':id', id);
            $.get(url, function (data) {
                $('#currency').html(data.view);
                $('#currency-selected').text(data.pay_currency);
                currency = data.pay_currency
            })
        })

        if (currency !== null) {
            $('#currency-selected').text(currency);
        }

        // Payment type change handler
        $('#payment_type').on('change', function() {
            const paymentType = $(this).val();
            
            // Hide all payment type fields
            $('.payment-type-fields').hide();
            
            // Show relevant fields based on selection
            if (paymentType) {
                $(`#${paymentType}_fields`).show();
            }
            
            updatePaymentDetails();
        });

        // Auto-generate JSON for payment details
        function updatePaymentDetails() {
            const paymentType = $('#payment_type').val();
            const paymentInstructions = $('textarea[name="payment_instructions"]').val();
            
            let paymentDetails = {
                payment_type: paymentType,
                payment_instructions: paymentInstructions
            };
            
            // Add fields based on payment type
            if (paymentType === 'easypaisa') {
                paymentDetails.easypaisa_account = $('input[name="easypaisa_account"]').val();
                paymentDetails.account_holder_name = $('input[name="account_holder_name"]').val();
            } else if (paymentType === 'jazzcash') {
                paymentDetails.jazzcash_account = $('input[name="jazzcash_account"]').val();
                paymentDetails.account_holder_name = $('input[name="account_holder_name"]').val();
            } else if (paymentType === 'bank_transfer') {
                paymentDetails.account_number = $('input[name="account_number"]').val();
                paymentDetails.account_holder_name = $('input[name="account_holder_name"]').val();
                paymentDetails.bank_name = $('input[name="bank_name"]').val();
                paymentDetails.branch_code = $('input[name="branch_code"]').val();
            } else if (paymentType === 'crypto') {
                paymentDetails.wallet_address = $('input[name="wallet_address"]').val();
                paymentDetails.crypto_type = $('select[name="crypto_type"]').val();
                paymentDetails.network = $('select[name="network"]').val();
                paymentDetails.qr_code = $('input[name="qr_code"]').val();
            }
            
            $('textarea[name="payment_details"]').val(JSON.stringify(paymentDetails, null, 2));
        }

        // Auto-generate QR code when wallet address changes
        $('input[name="wallet_address"]').on('input', function() {
            const walletAddress = $(this).val();
            const qrCodeInput = $('input[name="qr_code"]');
            
            if (walletAddress && !qrCodeInput.val()) {
                qrCodeInput.val(`https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=${encodeURIComponent(walletAddress)}`);
            }
            
            updatePaymentDetails();
        });

        // Event listeners for all payment detail fields
        $('input[name="easypaisa_account"], input[name="jazzcash_account"], input[name="account_number"], input[name="account_holder_name"], input[name="bank_name"], input[name="branch_code"], input[name="wallet_address"], input[name="qr_code"], select[name="crypto_type"], select[name="network"], textarea[name="payment_instructions"]').on('input change', updatePaymentDetails);
        
        // Initial setup
        const initialPaymentType = $('#payment_type').val();
        if (initialPaymentType) {
            $(`#${initialPaymentType}_fields`).show();
        }
        updatePaymentDetails();

    </script>
@endsection
