@extends('backend.layouts.master')

@section('title', 'Manual Payment Gateways')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Manual Payment Gateways</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.manual-payment-gateways.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Add New Gateway
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Code</th>
                                    <th>Network</th>
                                    <th>Wallet Address</th>
                                    <th>Min/Max Amount</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($gateways as $gateway)
                                    <tr>
                                        <td>{{ $gateway->id }}</td>
                                        <td>{{ $gateway->name }}</td>
                                        <td><span class="badge badge-info">{{ $gateway->code }}</span></td>
                                        <td>{{ $gateway->network ?? 'N/A' }}</td>
                                        <td>
                                            <small class="text-muted">{{ Str::limit($gateway->wallet_address, 20) }}</small>
                                        </td>
                                        <td>
                                            <small>{{ $gateway->currency_symbol }}{{ $gateway->minimum_amount }} - {{ $gateway->currency_symbol }}{{ $gateway->maximum_amount }}</small>
                                        </td>
                                        <td>
                                            @if($gateway->status)
                                                <span class="badge badge-success">Active</span>
                                            @else
                                                <span class="badge badge-danger">Inactive</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('admin.manual-payment-gateways.show', $gateway) }}" class="btn btn-info btn-sm">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('admin.manual-payment-gateways.edit', $gateway) }}" class="btn btn-warning btn-sm">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('admin.manual-payment-gateways.destroy', $gateway) }}" method="POST" style="display: inline-block;" onsubmit="return confirm('Are you sure you want to delete this gateway?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">No manual payment gateways found.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection














