@extends('backend.layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">ROI Management System</h3>
                    <div class="card-tools">
                        <span class="badge badge-info">Users collect ROI themselves</span>
                    </div>
                </div>
                <div class="card-body">
                    <!-- ROI Statistics -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning"><i class="fas fa-clock"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Pending ROI</span>
                                    <span class="info-box-number">{{ $roiStats['pending_schedules'] }}</span>
                                    <small>${{ number_format($roiStats['pending_amount'], 2) }}</small>
                                </div>
                                            </div>
                                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-success"><i class="fas fa-check-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Ready to Collect</span>
                                    <span class="info-box-number">{{ $roiStats['ready_schedules'] }}</span>
                                    <small>${{ number_format($roiStats['ready_amount'], 2) }}</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-primary"><i class="fas fa-wallet"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Collected ROI</span>
                                    <span class="info-box-number">{{ $roiStats['sent_schedules'] }}</span>
                                    <small>${{ number_format($roiStats['sent_amount'], 2) }}</small>
                                </div>
                                            </div>
                                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info"><i class="fas fa-chart-line"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Schedules</span>
                                    <span class="info-box-number">{{ $roiStats['total_schedules'] }}</span>
                                    <small>All ROI cycles</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Information Card -->
                    <div class="alert alert-info">
                        <h4><i class="icon fas fa-info"></i> ROI Collection System</h4>
                        <p>
                            <strong>Automatic System:</strong> Users can now collect their ROI themselves from the user panel.
                            The system automatically processes ROI based on the plan settings configured in the admin panel.
                        </p>
                        <ul>
                            <li>ROI is calculated based on plan percentage and investment amount</li>
                            <li>Users see a countdown timer for pending ROI</li>
                            <li>When ready, users can collect ROI with one click</li>
                            <li>Next ROI cycle starts automatically after collection</li>
                        </ul>
                    </div>
                    
                    <!-- Plans & Users Overview -->
                    <div class="card">
                        <div class="card-header">
                            <h5>Investment Plans Overview</h5>
                        </div>
                        <div class="card-body">
                            @if($investments->count() > 0)
                            <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>Plan Name</th>
                                            <th>ROI %</th>
                                            <th>Active Users</th>
                                            <th>Total Investment</th>
                                                <th>Pending ROI</th>
                                                <th>Ready ROI</th>
                                                <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                            @foreach($investments as $schemaId => $planInvestments)
                                                @php
                                                    $schema = $planInvestments->first()->schema;
                                                    $totalInvestment = $planInvestments->sum('invest_amount');
                                                    $pendingSchedules = \App\Models\RoiSchedule::whereIn('invest_id', $planInvestments->pluck('id'))
                                                        ->where('status', 'pending')->get();
                                                    $readySchedules = \App\Models\RoiSchedule::whereIn('invest_id', $planInvestments->pluck('id'))
                                                        ->where('status', 'ready')->get();
                                                    $pendingAmount = $pendingSchedules->sum('roi_amount');
                                                    $readyAmount = $readySchedules->sum('roi_amount');
                                            @endphp
                                            <tr>
                                                    <td>
                                                        <strong>{{ $schema->name }}</strong>
                                                        <br><small class="text-muted">{{ $schema->description ?? 'No description' }}</small>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-primary">{{ $schema->return_interest }}%</span>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-info">{{ $planInvestments->count() }} users</span>
                                                    </td>
                                                    <td>
                                                        <strong>${{ number_format($totalInvestment, 2) }}</strong>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-warning">{{ $pendingSchedules->count() }} schedules</span>
                                                        <br><small>${{ number_format($pendingAmount, 2) }}</small>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-success">{{ $readySchedules->count() }} schedules</span>
                                                        <br><small>${{ number_format($readyAmount, 2) }}</small>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-sm btn-info" onclick="viewPlanUsers({{ $schemaId }})">
                                                            <i class="fas fa-users"></i> View Users
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            @else
                                <div class="text-center py-4">
                                    <i class="fas fa-chart-line fa-3x text-muted mb-3"></i>
                                    <h5>No Active Investments</h5>
                                    <p class="text-muted">No users have active investments at the moment.</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Users Modal -->
<div class="modal fade" id="usersModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Plan Users</h5>
                <button type="button" class="close" onclick="closeModal()">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div id="usersListContainer">
                    <div class="text-center">
                        <i class="fas fa-spinner fa-spin"></i> Loading users...
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
function viewPlanUsers(schemaId) {
    $('#usersModal').modal('show');
    $('#usersListContainer').html('<div class="text-center"><i class="fas fa-spinner fa-spin"></i> Loading users...</div>');
    
    fetch(`{{ route('admin.roi.plan-users') }}?schema_id=${schemaId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                let html = '<div class="table-responsive"><table class="table table-bordered">';
                html += '<thead><tr><th>User</th><th>Investment</th><th>ROI Amount</th><th>Status</th><th>Progress</th><th>Cycle</th></tr></thead><tbody>';
                
                data.users.forEach(user => {
                    let statusBadge = '';
                    let progressBar = '';
                    
                    if (user.roi_status === 'pending') {
                        statusBadge = '<span class="badge badge-warning">Pending</span>';
                        progressBar = `<div class="progress">
                            <div class="progress-bar" style="width: ${user.progress_percentage}%"></div>
                        </div>
                        <small>${formatTime(user.time_remaining)} remaining</small>`;
                    } else if (user.roi_status === 'ready') {
                        statusBadge = '<span class="badge badge-success">Ready</span>';
                        progressBar = '<span class="text-success"><i class="fas fa-check-circle"></i> Ready to collect</span>';
                    } else {
                        statusBadge = '<span class="badge badge-secondary">No ROI</span>';
                        progressBar = '<span class="text-muted">No active ROI</span>';
                    }
                    
                    html += `<tr>
                        <td>
                            <strong>${user.name}</strong><br>
                            <small class="text-muted">@${user.username}</small>
                        </td>
                        <td>$${parseFloat(user.invest_amount).toFixed(2)}</td>
                        <td>$${parseFloat(user.roi_amount).toFixed(2)}</td>
                        <td>${statusBadge}</td>
                        <td>${progressBar}</td>
                        <td>${user.roi_cycle}/${user.total_cycles}</td>
                    </tr>`;
                });
                
                html += '</tbody></table></div>';
                $('#usersListContainer').html(html);
            } else {
                $('#usersListContainer').html(`<div class="alert alert-danger">Error: ${data.error}</div>`);
            }
        })
        .catch(error => {
            $('#usersListContainer').html(`<div class="alert alert-danger">Error loading users: ${error.message}</div>`);
        });
}

function closeModal() {
    $('#usersModal').modal('hide');
}

function formatTime(seconds) {
    const hours = Math.floor(seconds / 3600);
    const minutes = Math.floor((seconds % 3600) / 60);
    const secs = seconds % 60;
    return `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}`;
}
</script>
@endpush