@extends('backend.layouts.app')

@section('title')
    Wallet Management
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card wallet-mgmt">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-wallet"></i> Wallet Management
                        </h3>
                        <div class="card-tools">
                            <form method="GET" action="{{ route('admin.wallet.index') }}" class="d-flex">
                                <input type="text" name="query" class="form-control" placeholder="Search users..." value="{{ request('query') }}">
                                <button type="submit" class="btn btn-primary ml-2">
                                    <i class="fas fa-search"></i> Search
                                </button>
                            </form>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Username</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Main Wallet</th>
                                        <th>Profit Wallet</th>
                                        <th>Total Balance</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($users as $user)
                                        <tr>
                                            <td data-label="ID">{{ $user->id }}</td>
                                            <td data-label="Username">
                                                <strong>{{ $user->username }}</strong>
                                            </td>
                                            <td data-label="Name">{{ $user->first_name }} {{ $user->last_name }}</td>
                                            <td data-label="Email">{{ $user->email }}</td>
                                            <td data-label="Main Wallet">
                                                <span class="badge badge-success">${{ number_format($user->balance, 2) }}</span>
                                            </td>
                                            <td data-label="Profit Wallet">
                                                <span class="badge badge-info">${{ number_format($user->profit_balance, 2) }}</span>
                                            </td>
                                            <td data-label="Total Balance">
                                                <span class="badge badge-primary">${{ number_format($user->balance + $user->profit_balance, 2) }}</span>
                                            </td>
                                            <td data-label="Actions">
                                                <div class="btn-group" role="group">
                                                    <a href="{{ route('admin.wallet.show', $user->id) }}" class="btn btn-info btn-sm">
                                                        <i class="fas fa-eye"></i> View
                                                    </a>
                                                    <button type="button" class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#updateBalanceModal{{ $user->id }}">
                                                        <i class="fas fa-edit"></i> Manage
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>

                                        <!-- Update Balance Modal -->
                                        <div class="modal fade" id="updateBalanceModal{{ $user->id }}" tabindex="-1" role="dialog">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Manage Wallet - {{ $user->username }}</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <div class="card">
                                                                    <div class="card-header">
                                                                        <h6>Current Balances</h6>
                                                                    </div>
                                                                    <div class="card-body">
                                                                        <p><strong>Main Wallet:</strong> ${{ number_format($user->balance, 2) }}</p>
                                                                        <p><strong>Profit Wallet:</strong> ${{ number_format($user->profit_balance, 2) }}</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <div class="card">
                                                                    <div class="card-header">
                                                                        <h6>Update Balance</h6>
                                                                    </div>
                                                                    <div class="card-body">
                                                                        <form method="POST" action="{{ route('admin.wallet.update-balance') }}">
                                                                            @csrf
                                                                            <input type="hidden" name="user_id" value="{{ $user->id }}">
                                                                            
                                                                            <div class="form-group">
                                                                                <label>Wallet Type</label>
                                                                                <select name="wallet_type" class="form-control" required>
                                                                                    <option value="main">Main Wallet</option>
                                                                                    <option value="profit">Profit Wallet</option>
                                                                                </select>
                                                                            </div>
                                                                            
                                                                            <div class="form-group">
                                                                                <label>Action</label>
                                                                                <select name="action" class="form-control" required>
                                                                                    <option value="increase">Increase Balance</option>
                                                                                    <option value="decrease">Decrease Balance</option>
                                                                                </select>
                                                                            </div>
                                                                            
                                                                            <div class="form-group">
                                                                                <label>Amount</label>
                                                                                <input type="number" name="amount" class="form-control" step="0.01" min="0.01" required>
                                                                            </div>
                                                                            
                                                                            <div class="form-group">
                                                                                <label>Reason</label>
                                                                                <textarea name="reason" class="form-control" rows="2" required placeholder="Enter reason for this action..."></textarea>
                                                                            </div>
                                                                            
                                                                            <button type="submit" class="btn btn-primary">
                                                                                <i class="fas fa-save"></i> Update Balance
                                                                            </button>
                                                                        </form>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <hr>
                                                        
                                                        <div class="card">
                                                            <div class="card-header">
                                                                <h6>Transfer Between Wallets</h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <form method="POST" action="{{ route('admin.wallet.transfer-wallet') }}">
                                                                    @csrf
                                                                    <input type="hidden" name="user_id" value="{{ $user->id }}">
                                                                    
                                                                    <div class="row">
                                                                        <div class="col-md-4">
                                                                            <div class="form-group">
                                                                                <label>From Wallet</label>
                                                                                <select name="from_wallet" class="form-control" required>
                                                                                    <option value="main">Main Wallet</option>
                                                                                    <option value="profit">Profit Wallet</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <div class="form-group">
                                                                                <label>To Wallet</label>
                                                                                <select name="to_wallet" class="form-control" required>
                                                                                    <option value="profit">Profit Wallet</option>
                                                                                    <option value="main">Main Wallet</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <div class="form-group">
                                                                                <label>Amount</label>
                                                                                <input type="number" name="amount" class="form-control" step="0.01" min="0.01" required>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                    <div class="form-group">
                                                                        <label>Reason</label>
                                                                        <textarea name="reason" class="form-control" rows="2" required placeholder="Enter reason for transfer..."></textarea>
                                                                    </div>
                                                                    
                                                                    <button type="submit" class="btn btn-success">
                                                                        <i class="fas fa-exchange-alt"></i> Transfer
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @empty
                                        <tr>
                                            <td colspan="8" class="text-center">No users found</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="d-flex justify-content-center">
                            {{ $users->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
<style>
/* Scoped styles for Wallet Management */
.wallet-mgmt .card-header { display: flex; align-items: center; gap: 12px; flex-wrap: wrap; }
.wallet-mgmt .card-title { margin: 0; font-weight: 600; }
.wallet-mgmt .card-tools { margin-left: auto; }
.wallet-mgmt .card-tools .d-flex { gap: 8px; }
.wallet-mgmt .badge { font-size: 12px; padding: 6px 10px; }
.wallet-mgmt .btn-group .btn { min-width: 84px; }

/* Responsive table: stack rows on small screens */
@media (max-width: 768px) {
    .wallet-mgmt .card-tools { width: 100%; }
    .wallet-mgmt .card-tools input[type="text"] { flex: 1; }
    .wallet-mgmt table thead { display: none; }
    .wallet-mgmt table tbody tr { display: block; margin-bottom: 12px; border: 1px solid #e5e7eb; border-radius: 8px; overflow: hidden; }
    .wallet-mgmt table tbody td { display: flex; justify-content: space-between; align-items: center; padding: 10px 14px; }
    .wallet-mgmt table tbody td::before { content: attr(data-label); font-weight: 600; color: #6b7280; margin-right: 12px; }
    .wallet-mgmt .btn-group { display: flex; gap: 8px; }
}
</style>
@endpush

@push('scripts')
<script>
// Auto-refresh disabled to prevent unexpected reloads while managing customers
</script>
@endpush
















