<!-- Modern Professional Hero Section -->
<section class="modern-hero-section">
    <!-- Animated Background -->
    <div class="hero-bg-animation">
        <div class="floating-shapes">
            <div class="shape shape-1"></div>
            <div class="shape shape-2"></div>
            <div class="shape shape-3"></div>
            <div class="shape shape-4"></div>
            <div class="shape shape-5"></div>
        </div>
        <div class="gradient-overlay"></div>
    </div>
    
    <div class="container">
        <div class="row align-items-center min-vh-100">
            <div class="col-xl-6 col-lg-6 col-md-12">
                <div class="hero-content-modern" data-aos="fade-right" data-aos-duration="1000">
                    <!-- Badge -->
                    <div class="hero-badge">
                        <span class="badge-text">🚀 #1 Trading Platform</span>
                        <div class="badge-glow"></div>
                    </div>
                    
                    <!-- Main Title -->
                    <h1 class="hero-title-modern">
                        <span class="title-gradient">{{ $data['hero_title'] }}</span>
                        <div class="title-underline"></div>
                    </h1>
                    
                    <!-- Subtitle -->
                    <p class="hero-subtitle-modern" data-aos="fade-up" data-aos-duration="1500">
                        {{ $data['hero_content'] }}
                    </p>
                    
                    <!-- Statistics Cards -->
                    <div class="hero-stats" data-aos="fade-up" data-aos-duration="1800">
                        <div class="stat-card">
                            <div class="stat-number">10K+</div>
                            <div class="stat-label">Active Traders</div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-number">$50M+</div>
                            <div class="stat-label">Volume Traded</div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-number">99.9%</div>
                            <div class="stat-label">Uptime</div>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="hero-buttons" data-aos="fade-up" data-aos-duration="2000">
                        <a href="{{ $data['hero_button1_url'] }}" class="btn-modern btn-primary" 
                           target="{{ $data['hero_button1_target'] }}">
                            <span class="btn-text">
                                <i class="anticon {{ $data['hero_button1_icon'] }}"></i>
                                {{ $data['hero_button1_level'] }}
                            </span>
                            <div class="btn-shine"></div>
                        </a>
                        <a href="{{ $data['hero_button2_url'] }}" class="btn-modern btn-outline" 
                           target="{{ $data['hero_button2_target'] }}">
                            <span class="btn-text">
                                <i class="anticon {{ $data['hero_button2_icon'] }}"></i>
                                {{ $data['hero_button2_lavel'] }}
                            </span>
                            <div class="btn-shine"></div>
                        </a>
                    </div>
                    
                    <!-- Trust Indicators -->
                    <div class="trust-indicators" data-aos="fade-up" data-aos-duration="2200">
                        <div class="trust-item">
                            <i class="anticon anticon-safety"></i>
                            <span>SSL Secured</span>
                        </div>
                        <div class="trust-item">
                            <i class="anticon anticon-bank"></i>
                            <span>Licensed & Regulated</span>
                        </div>
                        <div class="trust-item">
                            <i class="anticon anticon-team"></i>
                            <span>24/7 Support</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-6 col-lg-6 col-md-12">
                <div class="hero-visual-modern" data-aos="fade-left" data-aos-duration="1200">
                    <!-- 3D Trading Dashboard Mockup -->
                    <div class="dashboard-mockup">
                        <div class="mockup-container">
                            <!-- Main Dashboard Card -->
                            <div class="dashboard-card main-card">
                                <div class="card-header">
                                    <div class="header-dots">
                                        <span class="dot red"></span>
                                        <span class="dot yellow"></span>
                                        <span class="dot green"></span>
                                    </div>
                                    <div class="header-title">Trading Dashboard</div>
                                </div>
                                <div class="card-content">
                                    <div class="chart-area">
                                        <div class="chart-line"></div>
                                        <div class="chart-bars">
                                            <div class="bar" style="height: 30%"></div>
                                            <div class="bar" style="height: 70%"></div>
                                            <div class="bar" style="height: 45%"></div>
                                            <div class="bar" style="height: 80%"></div>
                                            <div class="bar" style="height: 60%"></div>
                                        </div>
                                    </div>
                                    <div class="balance-display">
                                        <div class="balance-label">Portfolio Value</div>
                                        <div class="balance-amount">$24,847.92</div>
                                        <div class="balance-change positive">+12.5% ↗</div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Floating Cards -->
                            <div class="floating-card card-1">
                                <div class="crypto-item">
                                    <div class="crypto-icon btc"></div>
                                    <div class="crypto-info">
                                        <div class="crypto-name">BTC</div>
                                        <div class="crypto-price">$42,847</div>
                                    </div>
                                    <div class="crypto-change positive">+5.2%</div>
                                </div>
                            </div>
                            
                            <div class="floating-card card-2">
                                <div class="notification-item">
                                    <div class="notif-icon"></div>
                                    <div class="notif-text">Trade Executed</div>
                                    <div class="notif-time">2m ago</div>
                                </div>
                            </div>
                            
                            <div class="floating-card card-3">
                                <div class="profit-indicator">
                                    <div class="profit-icon">💰</div>
                                    <div class="profit-text">+$1,247</div>
                                    <div class="profit-label">Today's Profit</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Decorative Elements -->
                        <div class="hero-decoration">
                            <div class="deco-circle circle-1"></div>
                            <div class="deco-circle circle-2"></div>
                            <div class="deco-circle circle-3"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Scroll Indicator -->
    <div class="scroll-indicator" data-aos="fade-up" data-aos-duration="2500">
        <div class="scroll-text">Scroll to explore</div>
        <div class="scroll-arrow">
            <i class="anticon anticon-down"></i>
        </div>
    </div>
</section>

