@php
$landingContent = \App\Models\LandingContent::where('type','howitworks')->where('locale',app()->getLocale())->get();
@endphp

<!-- Professional How It Works Section -->
<section class="professional-how-it-works-section">
    <div class="how-it-works-background">
        <div class="how-it-works-gradient-overlay"></div>
        <div class="how-it-works-particles"></div>

    </div>
    
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-8 col-xl-8 col-lg-10">
                <div class="section-header" data-aos="fade-up" data-aos-duration="1000">
                    <div class="section-badge">
                        <span class="badge-text">🚀 Simple Process</span>
                    </div>
                    <h1 class="section-title">
                        <span class="title-line">{{ $data['title_big'] }}</span>
                        <span class="title-subtitle">{{ $data['title_small'] }}</span>
                    </h1>
                    <p class="section-description">
                        Get started with our platform in just a few simple steps. Our streamlined process makes investing accessible to everyone, from beginners to experts.
                    </p>
                </div>
            </div>
        </div>
        
        <div class="how-it-works-timeline">
            @foreach($landingContent as $index => $content)
            <div class="timeline-item" data-aos="fade-up" data-aos-delay="{{ $index * 200 }}">
                <div class="timeline-marker">
                    <div class="marker-number">{{ $index + 1 }}</div>
                    <div class="marker-icon">
                        <img src="{{ asset($content->icon) }}" alt="{{ $content->title }}" class="icon-image">
                    </div>
                    <div class="marker-glow"></div>
                </div>
                
                <div class="timeline-content">
                    <div class="content-card">
                        <div class="card-header">
                            <h3 class="step-title">{{ $content->title }}</h3>
                            <div class="step-number">Step {{ $index + 1 }}</div>
                        </div>
                        <div class="card-body">
                            <p class="step-description">{{ $content->description }}</p>
                        </div>
                        <div class="card-footer">
                            <div class="step-features">
                                <div class="feature-tag">
                                    <span class="tag-icon">✓</span>
                                    <span class="tag-text">Quick Setup</span>
                                </div>
                                <div class="feature-tag">
                                    <span class="tag-icon">🔒</span>
                                    <span class="tag-text">Secure</span>
                                </div>
                                <div class="feature-tag">
                                    <span class="tag-icon">⚡</span>
                                    <span class="tag-text">Fast</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                @if($index < $landingContent->count() - 1)
                <div class="timeline-connector">
                    <div class="connector-line"></div>
                    <div class="connector-arrow">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                </div>
                @endif
            </div>
            @endforeach
        </div>
        
        <div class="how-it-works-cta">
            <div class="cta-content" data-aos="fade-up" data-aos-delay="600">
                <div class="cta-icon">
                    <svg width="48" height="48" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M13 2L3 14H12L11 22L21 10H12L13 2Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                    </svg>
                </div>
                <h3 class="cta-title">Ready to Get Started?</h3>
                <p class="cta-description">Join thousands of investors who are already earning with our platform.</p>
                <div class="cta-buttons">
                    <a href="{{ route('register') }}" class="btn-primary">
                        <span class="btn-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M16 21V19C16 17.9391 15.5786 16.9217 14.8284 16.1716C14.0783 15.4214 13.0609 15 12 15H5C3.93913 15 2.92172 15.4214 2.17157 16.1716C1.42143 16.9217 1 17.9391 1 19V21" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <circle cx="8.5" cy="7" r="4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M20 8V14M23 11H17" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </span>
                        <span class="btn-text">Start Investing</span>
                    </a>
                    <a href="{{ route('login') }}" class="btn-secondary">
                        <span class="btn-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M15 3H19C19.5304 3 20.0391 3.21071 20.4142 3.58579C20.7893 3.96086 21 4.46957 21 5V19C21 19.5304 20.7893 20.0391 20.4142 20.4142C20.0391 20.7893 19.5304 21 19 21H15" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <polyline points="10,17 15,12 10,7" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <line x1="15" y1="12" x2="3" y2="12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </span>
                        <span class="btn-text">Login</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* Professional How It Works Section Styles */
.professional-how-it-works-section {
    position: relative;
    padding: 120px 0;
    background: linear-gradient(135deg, #0f0f23 0%, #1a1a2e 50%, #16213e 100%);
    overflow: hidden;
}

.how-it-works-background {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 1;
}

.how-it-works-gradient-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: radial-gradient(circle at 30% 20%, rgba(99, 102, 241, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 70% 80%, rgba(236, 72, 153, 0.1) 0%, transparent 50%);
}

.how-it-works-particles {
    position: absolute;
    width: 100%;
    height: 100%;
    background-image: 
        radial-gradient(2px 2px at 20px 30px, rgba(255,255,255,0.1), transparent),
        radial-gradient(2px 2px at 40px 70px, rgba(99,102,241,0.2), transparent);
    background-repeat: repeat;
    background-size: 100px 100px;
    animation: float 25s infinite linear;
}



.section-header {
    text-align: center;
    margin-bottom: 80px;
    position: relative;
    z-index: 2;
}

.section-badge {
    display: inline-block;
    margin-bottom: 20px;
}

.badge-text {
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 1px solid rgba(99, 102, 241, 0.3);
    padding: 8px 20px;
    border-radius: 50px;
    font-size: 14px;
    font-weight: 600;
    color: #ffffff;
    backdrop-filter: blur(10px);
}

.section-title {
    font-size: 3.5rem;
    font-weight: 900;
    line-height: 1.1;
    margin-bottom: 20px;
    background: linear-gradient(135deg, #ffffff 0%, #a0a0a0 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.title-line {
    display: block;
}

.title-subtitle {
    display: block;
    font-size: 1.5rem;
    font-weight: 600;
    color: rgba(255, 255, 255, 0.8);
    margin-top: 10px;
}

.section-description {
    font-size: 1.2rem;
    line-height: 1.6;
    color: rgba(255, 255, 255, 0.7);
    max-width: 600px;
    margin: 0 auto;
}

.how-it-works-timeline {
    position: relative;
    z-index: 2;
    max-width: 1000px;
    margin: 0 auto;
}

.timeline-item {
    position: relative;
    margin-bottom: 60px;
    display: flex;
    align-items: center;
    gap: 40px;
}

.timeline-item:nth-child(even) {
    flex-direction: row-reverse;
}

.timeline-marker {
    position: relative;
    flex-shrink: 0;
    width: 120px;
    height: 120px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.marker-number {
    position: absolute;
    top: -10px;
    right: -10px;
    width: 30px;
    height: 30px;
    background: linear-gradient(135deg, #6366f1, #8b5cf6);
    color: #ffffff;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 800;
    font-size: 0.9rem;
    z-index: 3;
    box-shadow: 0 4px 15px rgba(99, 102, 241, 0.3);
}

.marker-icon {
    width: 80px;
    height: 80px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    border: 2px solid rgba(99, 102, 241, 0.3);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    z-index: 2;
}

.icon-image {
    width: 40px;
    height: 40px;
    object-fit: contain;
    filter: drop-shadow(0 0 10px rgba(99, 102, 241, 0.3));
}

.marker-glow {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 100px;
    height: 100px;
    background: radial-gradient(circle, rgba(99, 102, 241, 0.2) 0%, transparent 70%);
    border-radius: 50%;
    animation: pulse 2s infinite;
}

.timeline-content {
    flex: 1;
}

.content-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 20px;
    padding: 30px;
    transition: all 0.3s ease;
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
}

.content-card:hover {
    transform: translateY(-5px);
    border-color: rgba(99, 102, 241, 0.3);
    box-shadow: 0 25px 50px rgba(99, 102, 241, 0.1);
}

.card-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.step-title {
    font-size: 1.5rem;
    font-weight: 800;
    color: #ffffff;
    margin: 0;
}

.step-number {
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 1px solid rgba(99, 102, 241, 0.3);
    padding: 6px 12px;
    border-radius: 15px;
    font-size: 0.8rem;
    font-weight: 600;
    color: #6366f1;
}

.card-body {
    margin-bottom: 20px;
}

.step-description {
    color: rgba(255, 255, 255, 0.8);
    line-height: 1.6;
    font-size: 1rem;
    margin: 0;
}

.card-footer {
    border-top: 1px solid rgba(255, 255, 255, 0.1);
    padding-top: 20px;
}

.step-features {
    display: flex;
    gap: 15px;
    flex-wrap: wrap;
}

.feature-tag {
    display: flex;
    align-items: center;
    gap: 6px;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    padding: 6px 12px;
    border-radius: 15px;
    font-size: 0.8rem;
    color: rgba(255, 255, 255, 0.7);
}

.tag-icon {
    font-size: 0.9rem;
}

.timeline-connector {
    position: absolute;
    left: 50%;
    top: 100%;
    transform: translateX(-50%);
    z-index: 1;
}

.connector-line {
    width: 2px;
    height: 40px;
    background: linear-gradient(180deg, rgba(99, 102, 241, 0.5), rgba(236, 72, 153, 0.5));
    margin: 0 auto;
}

.connector-arrow {
    width: 30px;
    height: 30px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(99, 102, 241, 0.3);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 10px auto 0;
    color: #6366f1;
}

.how-it-works-cta {
    margin-top: 80px;
    position: relative;
    z-index: 2;
}

.cta-content {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 25px;
    padding: 50px 40px;
    text-align: center;
    box-shadow: 0 25px 50px rgba(0, 0, 0, 0.3);
}

.cta-icon {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 2px solid rgba(99, 102, 241, 0.3);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 30px;
    color: #6366f1;
}

.cta-title {
    font-size: 2rem;
    font-weight: 800;
    color: #ffffff;
    margin-bottom: 15px;
}

.cta-description {
    color: rgba(255, 255, 255, 0.7);
    font-size: 1.1rem;
    margin-bottom: 30px;
    max-width: 500px;
    margin-left: auto;
    margin-right: auto;
}

.cta-buttons {
    display: flex;
    gap: 20px;
    justify-content: center;
    flex-wrap: wrap;
}

.btn-primary, .btn-secondary {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 16px 32px;
    border-radius: 50px;
    font-weight: 700;
    text-decoration: none;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.btn-primary {
    background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
    color: #ffffff;
    border: none;
    box-shadow: 0 10px 30px rgba(99, 102, 241, 0.3);
}

.btn-primary:hover {
    transform: translateY(-3px);
    box-shadow: 0 15px 40px rgba(99, 102, 241, 0.4);
    color: #ffffff;
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.1);
    color: #ffffff;
    border: 1px solid rgba(255, 255, 255, 0.2);
    backdrop-filter: blur(10px);
}

.btn-secondary:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-3px);
    color: #ffffff;
}

@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-20px); }
}

@keyframes pulse {
    0%, 100% { opacity: 0.5; transform: translate(-50%, -50%) scale(1); }
    50% { opacity: 0.8; transform: translate(-50%, -50%) scale(1.1); }
}

/* Responsive Design */
@media (max-width: 768px) {
    .professional-how-it-works-section {
        padding: 80px 0;
    }
    
    .section-title {
        font-size: 2.5rem;
    }
    
    .timeline-item {
        flex-direction: column !important;
        text-align: center;
        gap: 20px;
    }
    
    .timeline-marker {
        width: 100px;
        height: 100px;
    }
    
    .marker-icon {
        width: 70px;
        height: 70px;
    }
    
    .icon-image {
        width: 35px;
        height: 35px;
    }
    
    .content-card {
        padding: 25px 20px;
    }
    
    .cta-content {
        padding: 40px 25px;
    }
    
    .cta-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .btn-primary, .btn-secondary {
        width: 100%;
        max-width: 300px;
        justify-content: center;
    }
}

@media (max-width: 480px) {
    .section-title {
        font-size: 2rem;
    }
    
    .section-description {
        font-size: 1rem;
    }
    
    .timeline-marker {
        width: 80px;
        height: 80px;
    }
    
    .marker-icon {
        width: 60px;
        height: 60px;
    }
    
    .icon-image {
        width: 30px;
        height: 30px;
    }
    
    .content-card {
        padding: 20px 15px;
    }
    
    .step-title {
        font-size: 1.3rem;
    }
    
    .cta-title {
        font-size: 1.5rem;
    }
    
    .cta-content {
        padding: 30px 20px;
    }
}
</style>
