@php
$landingContent =\App\Models\LandingContent::where('type','whychooseus')->where('locale',app()->getLocale())->get();
@endphp

<!-- Professional Why Choose Us Section -->
<section class="professional-why-choose-section">
    <div class="why-choose-background">
        <div class="why-choose-gradient-overlay"></div>
        <div class="why-choose-particles"></div>

    </div>
    
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-8 col-xl-8 col-lg-10">
                <div class="section-header" data-aos="fade-up" data-aos-duration="1000">
                    <div class="section-badge">
                        <span class="badge-text">⭐ Why Choose Us</span>
                    </div>
                    <h1 class="section-title">
                        <span class="title-line">{{ $data['title_big'] }}</span>
                        <span class="title-subtitle">{{ $data['title_small'] }}</span>
                    </h1>
                    <p class="section-description">
                        Discover the unique advantages that make us the preferred choice for thousands of investors worldwide.
                    </p>
                </div>
            </div>
        </div>
        
        <div class="features-grid">
            @foreach($landingContent as $index => $content)
            <div class="feature-card" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="{{ $index * 200 }}">
                <div class="card-glow"></div>
                <div class="card-content">
                    <div class="feature-icon">
                        <div class="icon-wrapper">
                            @if(content_exists($content->icon))
                                <img src="{{ asset($content->icon) }}" alt="{{ $content->title }}" class="icon-image">
                            @else
                                <span class="icon-text">{{ $content->icon }}</span>
                            @endif
                        </div>
                        <div class="icon-ring"></div>
                        <div class="icon-shine"></div>
                    </div>
                    
                    <div class="feature-content">
                        <h3 class="feature-title">{{ $content->title }}</h3>
                        <p class="feature-description">{{ $content->description }}</p>
                    </div>
                    
                    <div class="feature-particles">
                        <div class="particle"></div>
                        <div class="particle"></div>
                        <div class="particle"></div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        

    </div>
</section>

<style>
/* Professional Why Choose Us Section Styles */
.professional-why-choose-section {
    position: relative;
    padding: 120px 0;
    background: linear-gradient(135deg, #0f0f23 0%, #1a1a2e 50%, #16213e 100%);
    overflow: hidden;
}

.why-choose-background {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 1;
}

.why-choose-gradient-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: radial-gradient(circle at 30% 20%, rgba(99, 102, 241, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 70% 80%, rgba(236, 72, 153, 0.1) 0%, transparent 50%);
}

.why-choose-particles {
    position: absolute;
    width: 100%;
    height: 100%;
    background-image: 
        radial-gradient(2px 2px at 20px 30px, rgba(255,255,255,0.1), transparent),
        radial-gradient(2px 2px at 40px 70px, rgba(99,102,241,0.2), transparent);
    background-repeat: repeat;
    background-size: 100px 100px;
    animation: float 30s infinite linear;
}



.section-header {
    text-align: center;
    margin-bottom: 80px;
    position: relative;
    z-index: 2;
}

.section-badge {
    display: inline-block;
    margin-bottom: 20px;
}

.badge-text {
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 1px solid rgba(99, 102, 241, 0.3);
    padding: 8px 20px;
    border-radius: 50px;
    font-size: 14px;
    font-weight: 600;
    color: #ffffff;
    backdrop-filter: blur(10px);
}

.section-title {
    font-size: 3.5rem;
    font-weight: 900;
    line-height: 1.1;
    margin-bottom: 20px;
    background: linear-gradient(135deg, #ffffff 0%, #a0a0a0 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.title-line {
    display: block;
}

.title-subtitle {
    display: block;
    font-size: 1.5rem;
    font-weight: 600;
    color: rgba(255, 255, 255, 0.8);
    margin-top: 10px;
}

.section-description {
    font-size: 1.2rem;
    line-height: 1.6;
    color: rgba(255, 255, 255, 0.7);
    max-width: 600px;
    margin: 0 auto;
}

.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 30px;
    margin-bottom: 80px;
    position: relative;
    z-index: 2;
}

.feature-card {
    position: relative;
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 25px;
    padding: 40px 30px;
    transition: all 0.4s ease;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
}

.feature-card:hover {
    transform: translateY(-10px);
    border-color: rgba(99, 102, 241, 0.3);
    box-shadow: 0 30px 60px rgba(99, 102, 241, 0.1);
}

.card-glow {
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(99, 102, 241, 0.1) 0%, transparent 70%);
    opacity: 0;
    transition: opacity 0.4s ease;
    pointer-events: none;
}

.feature-card:hover .card-glow {
    opacity: 1;
}

.card-content {
    position: relative;
    z-index: 2;
}

.feature-icon {
    position: relative;
    width: 80px;
    height: 80px;
    margin: 0 auto 30px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.icon-wrapper {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 2px solid rgba(99, 102, 241, 0.3);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    z-index: 2;
    transition: all 0.4s ease;
}

.feature-card:hover .icon-wrapper {
    transform: scale(1.1);
    border-color: rgba(99, 102, 241, 0.5);
}

.icon-image {
    width: 40px;
    height: 40px;
    object-fit: contain;
}

.icon-text {
    font-size: 2rem;
    color: #6366f1;
    font-weight: 700;
}

.icon-ring {
    position: absolute;
    top: -10px;
    left: -10px;
    right: -10px;
    bottom: -10px;
    border: 2px solid rgba(99, 102, 241, 0.2);
    border-radius: 30px;
    animation: rotate 10s infinite linear;
}

.icon-shine {
    position: absolute;
    top: -5px;
    left: -5px;
    right: -5px;
    bottom: -5px;
    background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.1), transparent);
    border-radius: 25px;
    opacity: 0;
    transition: opacity 0.4s ease;
}

.feature-card:hover .icon-shine {
    opacity: 1;
    animation: shine 2s infinite;
}

.feature-content {
    text-align: center;
}

.feature-title {
    font-size: 1.5rem;
    font-weight: 800;
    color: #ffffff;
    margin-bottom: 15px;
    line-height: 1.3;
}

.feature-description {
    font-size: 1rem;
    line-height: 1.6;
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
}

.feature-particles {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    pointer-events: none;
    overflow: hidden;
}

.particle {
    position: absolute;
    width: 4px;
    height: 4px;
    background: rgba(99, 102, 241, 0.6);
    border-radius: 50%;
    animation: particle-float 6s infinite ease-in-out;
}

.particle:nth-child(1) {
    top: 20%;
    left: 20%;
    animation-delay: 0s;
}

.particle:nth-child(2) {
    top: 60%;
    right: 20%;
    animation-delay: 2s;
}

.particle:nth-child(3) {
    bottom: 20%;
    left: 60%;
    animation-delay: 4s;
}



@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-20px); }
}

@keyframes rotate {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

@keyframes shine {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

@keyframes particle-float {
    0%, 100% { transform: translateY(0px) rotate(0deg); opacity: 0.6; }
    50% { transform: translateY(-20px) rotate(180deg); opacity: 1; }
}

/* Responsive Design */
@media (max-width: 768px) {
    .professional-why-choose-section {
        padding: 80px 0;
    }
    
    .section-title {
        font-size: 2.5rem;
    }
    
    .features-grid {
        grid-template-columns: 1fr;
        gap: 25px;
        margin-bottom: 60px;
    }
    
    .feature-card {
        padding: 30px 20px;
    }
    
    .feature-icon {
        width: 70px;
        height: 70px;
        margin-bottom: 25px;
    }
    
    .icon-wrapper {
        width: 70px;
        height: 70px;
    }
    
    .feature-title {
        font-size: 1.3rem;
    }
    

}

@media (max-width: 480px) {
    .section-title {
        font-size: 2rem;
    }
    
    .section-description {
        font-size: 1rem;
    }
    
    .feature-card {
        padding: 25px 15px;
    }
    
    .feature-icon {
        width: 60px;
        height: 60px;
        margin-bottom: 20px;
    }
    
    .icon-wrapper {
        width: 60px;
        height: 60px;
    }
    
    .icon-text {
        font-size: 1.5rem;
    }
    
    .feature-title {
        font-size: 1.2rem;
    }
    

}
</style>
