<!DOCTYPE html>
<html lang="en">
@include('frontend::include.__head')

<body class="rock-dashboard-bg light-theme" style="background: #f8f9fa !important; color: #333 !important;" data-theme="light">
    @include('notify::components.notify')

    <!--[if lte IE 9]>
  <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
  <![endif]-->



        <!-- New Professional Navigation Toggle -->
        <button class="rock-nav-toggle" id="rockNavToggle">
            <span class="nav-line"></span>
            <span class="nav-line"></span>
            <span class="nav-line"></span>
        </button>

        <!-- Professional Navigation Overlay -->
        <div class="rock-nav-overlay" id="rockNavOverlay"></div>
        
        <!-- Professional Sidebar -->
        <div class="rock-professional-sidebar" id="rockProfessionalSidebar">
            <div class="sidebar-header">
                <div class="logo-section">
                    <div class="logo-icon">
                        <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="20" cy="20" r="18" fill="url(#logoGradient)" stroke="rgba(255,255,255,0.2)" stroke-width="2"/>
                            <path d="M12 20L18 26L28 14" stroke="white" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
                            <defs>
                                <linearGradient id="logoGradient" x1="0%" y1="0%" x2="100%" y2="100%">
                                    <stop offset="0%" style="stop-color:#6366f1;stop-opacity:1" />
                                    <stop offset="100%" style="stop-color:#8b5cf6;stop-opacity:1" />
                                </linearGradient>
                            </defs>
                        </svg>
                    </div>
                    <div class="logo-text">
                        <h3>Block Wave Trade</h3>
        </div>
    </div>
                <button class="close-sidebar" id="closeSidebar">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M18 6L6 18M6 6L18 18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </button>
            </div>
            
            <div class="sidebar-content">
                <nav class="rock-nav-menu">
                    <ul class="nav-list">
                        <li class="nav-item">
                            <a href="{{ route('user.dashboard') }}" class="nav-link @if(Route::is('user.dashboard')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M3 9L12 2L21 9V20C21 20.5304 20.7893 21.0391 20.4142 21.4142C20.0391 21.7893 19.5304 22 19 22H5C4.46957 22 3.96086 21.7893 3.58579 21.4142C3.21071 21.0391 3 20.5304 3 20V9Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M9 22V12H15V22" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">Dashboard</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a href="{{ route('user.schema') }}" class="nav-link @if(Route::is('user.schema.*')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">Investment Plans</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a href="{{ route('user.invest-logs') }}" class="nav-link @if(Route::is('user.invest-logs')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 11H15M9 15H15M17 21H7C5.89543 21 5 20.1046 5 19V5C5 3.89543 5.89543 3 7 3H12.5858C12.851 3 13.1054 3.10536 13.2929 3.29289L19.7071 9.70711C19.8946 9.89464 20 10.149 20 10.4142V19C20 20.1046 19.1046 21 18 21H17Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">My Investments</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a href="{{ route('user.deposit.amount') }}" class="nav-link @if(Route::is('user.deposit.*')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12 1V23M17 5H9.5C8.57174 5 7.6815 5.36875 7.02513 6.02513C6.36875 6.6815 6 7.57174 6 8.5C6 9.42826 6.36875 10.3185 7.02513 10.9749C7.6815 11.6312 8.57174 12 9.5 12H14.5C15.4283 12 16.3185 12.3687 16.9749 13.0251C17.6312 13.6815 18 14.5717 18 15.5C18 16.4283 17.6312 17.3185 16.9749 17.9749C16.3185 18.6312 15.4283 19 14.5 19H6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">Deposit</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a href="{{ route('user.deposit.log') }}" class="nav-link @if(Route::is('user.deposit.log')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 12H15M9 16H15M17 21H7C5.89543 21 5 20.1046 5 19V5C5 3.89543 5.89543 3 7 3H12.5858C12.851 3 13.1054 3.10536 13.2929 3.29289L19.7071 9.70711C19.8946 9.89464 20 10.149 20 10.4142V19C20 20.1046 19.1046 21 18 21H17Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">Deposit History</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a href="{{ route('user.send-money.view') }}" class="nav-link @if(Route::is('user.send-money.*')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">Send Money</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a href="{{ route('user.send-money.log') }}" class="nav-link @if(Route::is('user.send-money.log')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 12H15M9 16H15M17 21H7C5.89543 21 5 20.1046 5 19V5C5 3.89543 5.89543 3 7 3H12.5858C12.851 3 13.1054 3.10536 13.2929 3.29289L19.7071 9.70711C19.8946 9.89464 20 10.149 20 10.4142V19C20 20.1046 19.1046 21 18 21H17Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">Send Money History</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a href="{{ route('user.withdraw.simple.index') }}" class="nav-link @if(Route::is('user.withdraw.simple.*')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12 1V23M6 5H13.5C14.4283 5 15.3185 5.36875 15.9749 6.02513C16.6312 6.6815 17 7.57174 17 8.5C17 9.42826 16.6312 10.3185 15.9749 10.9749C15.3185 11.6312 14.4283 12 13.5 12H8.5C7.57174 12 6.6815 12.3687 6.02513 13.0251C5.36875 13.6815 5 14.5717 5 15.5C5 16.4283 5.36875 17.3185 6.02513 17.9749C6.6815 18.6312 7.57174 19 8.5 19H18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">Withdraw</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a href="{{ route('user.withdraw.simple.history') }}" class="nav-link @if(Route::is('user.withdraw.simple.history')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 12H15M9 16H15M17 21H7C5.89543 21 5 20.1046 5 19V5C5 3.89543 5.89543 3 7 3H12.5858C12.851 3 13.1054 3.10536 13.2929 3.29289L19.7071 9.70711C19.8946 9.89464 20 10.149 20 10.4142V19C20 20.1046 19.1046 21 18 21H17Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">Withdraw History</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a href="{{ route('user.referral') }}" class="nav-link @if(Route::is('user.referral.*')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M16 21V19C16 17.9391 15.5786 16.9217 14.8284 16.1716C14.0783 15.4214 13.0609 15 12 15H5C3.93913 15 2.92172 15.4214 2.17157 16.1716C1.42143 16.9217 1 17.9391 1 19V21" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <circle cx="8.5" cy="7" r="4" stroke="currentColor" stroke-width="2"/>
                                        <path d="M20 8V14M23 11H17" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">Referral</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a href="{{ route('user.ranking-badge') }}" class="nav-link @if(Route::is('user.ranking-badge')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12 2L15.09 8.26L22 9L17 14L18.18 21L12 17.77L5.82 21L7 14L2 9L8.91 8.26L12 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">Ranking Badge</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a href="{{ route('user.achievement') }}" class="nav-link @if(Route::is('user.achievement.*')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6 9H4.5C3.11929 9 2 10.1193 2 11.5V19.5C2 20.8807 3.11929 22 4.5 22H19.5C20.8807 22 22 20.8807 22 19.5V11.5C22 10.1193 20.8807 9 19.5 9H18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M6 9V6C6 3.79086 7.79086 2 10 2H14C16.2091 2 18 3.79086 18 6V9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M9 12L11 14L15 10" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">Achievement</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a href="{{ route('user.ticket.index') }}" class="nav-link @if(Route::is('user.ticket.*')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21 11.5C21.0034 12.8199 20.6951 14.1219 20.1 15.3C19.3944 16.7118 18.3098 17.8992 16.9674 18.7293C15.6251 19.5594 14.0782 19.9994 12.5 20C11.1801 20.0035 9.87812 19.6951 8.7 19.1L3 21L4.9 15.3C4.30493 14.1219 3.99656 12.8199 4 11.5C4.00061 9.92179 4.44061 8.37488 5.27072 7.03258C6.10083 5.69028 7.28825 4.60564 8.7 3.90003C9.87812 3.30496 11.1801 2.99659 12.5 3.00003H13C15.0843 3.11502 17.053 3.99479 18.5291 5.47089C20.0052 6.94699 20.885 8.91568 21 11V11.5Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">Support</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a href="{{ route('user.setting.show') }}" class="nav-link @if(Route::is('user.setting.*')) active @endif">
                                <div class="nav-icon">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <circle cx="12" cy="12" r="3" stroke="currentColor" stroke-width="2"/>
                                        <path d="M19.4 15C19.2669 15.3016 19.2272 15.6362 19.286 15.9606C19.3448 16.285 19.4995 16.5843 19.73 16.82L19.79 16.88C19.976 17.0657 20.1235 17.2863 20.2241 17.5291C20.3248 17.7719 20.3766 18.0322 20.3766 18.295C20.3766 18.5578 20.3248 18.8181 20.2241 19.0609C20.1235 19.3037 19.976 19.5243 19.79 19.71C19.6043 19.896 19.3837 20.0435 19.1409 20.1441C18.8981 20.2448 18.6378 20.2966 18.375 20.2966C18.1122 20.2966 17.8519 20.2448 17.6091 20.1441C17.3663 20.0435 17.1457 19.896 16.96 19.71L16.9 19.65C16.6643 19.4195 16.365 19.2648 16.0406 19.206C15.7162 19.1472 15.3816 19.1869 15.08 19.32C14.7842 19.4468 14.532 19.6572 14.3543 19.9255C14.1766 20.1938 14.0813 20.5082 14.08 20.83V21C14.08 21.5304 13.8693 22.0391 13.4942 22.4142C13.1191 22.7893 12.6104 23 12.08 23C11.5496 23 11.0409 22.7893 10.6658 22.4142C10.2907 22.0391 10.08 21.5304 10.08 21V20.91C10.0723 20.579 9.96512 20.2569 9.77251 19.9859C9.5799 19.7148 9.31074 19.5053 9 19.38C8.69838 19.2469 8.36381 19.2072 8.03941 19.266C7.71502 19.3248 7.41568 19.4795 7.18 19.71L7.12 19.77C6.93425 19.956 6.71368 20.1035 6.47088 20.2041C6.22808 20.3048 5.96783 20.3566 5.705 20.3566C5.44217 20.3566 5.18192 20.3048 4.93912 20.2041C4.69632 20.1035 4.47575 19.956 4.29 19.77C4.10405 19.5843 3.95653 19.3637 3.85588 19.1209C3.75523 18.8781 3.70343 18.6178 3.70343 18.355C3.70343 18.0922 3.75523 17.8319 3.85588 17.5891C3.95653 17.3463 4.10405 17.1257 4.29 16.94L4.35 16.88C4.58054 16.6443 4.73519 16.345 4.794 16.0206C4.85282 15.6962 4.81312 15.3616 4.68 15.06C4.55324 14.7642 4.34276 14.512 4.07447 14.3343C3.80618 14.1566 3.49179 14.0613 3.17 14.06H3C2.46957 14.06 1.96086 13.8493 1.58579 13.4742C1.21071 13.0991 1 12.5904 1 12.06C1 11.5296 1.21071 11.0209 1.58579 10.6458C1.96086 10.2707 2.46957 10.06 3 10.06H3.09C3.42099 10.0523 3.742 9.94512 4.01309 9.75251C4.28417 9.5599 4.49372 9.29074 4.62 8.98C4.75312 8.67838 4.79282 8.34381 4.734 8.01941C4.67519 7.69502 4.52054 7.39568 4.29 7.16L4.23 7.1C4.04405 6.91425 3.89653 6.69368 3.79588 6.45088C3.69523 6.20808 3.64343 5.94783 3.64343 5.685C3.64343 5.42217 3.69523 5.16192 3.79588 4.91912C3.89653 4.67632 4.04405 4.45575 4.23 4.27C4.41575 4.08405 4.63632 3.93653 4.87912 3.83588C5.12192 3.73523 5.38217 3.68343 5.645 3.68343C5.90783 3.68343 6.16808 3.73523 6.41088 3.83588C6.65368 3.93653 6.87425 4.08405 7.06 4.27L7.12 4.33C7.35568 4.56054 7.65502 4.71519 7.97941 4.774C8.30381 4.83282 8.63838 4.79312 8.94 4.66H9C9.29577 4.53324 9.54802 4.32276 9.72569 4.05447C9.90337 3.78618 9.99872 3.47179 10 3.15V3C10 2.46957 10.2107 1.96086 10.5858 1.58579C10.9609 1.21071 11.4696 1 12 1C12.5304 1 13.0391 1.21071 13.4142 1.58579C13.7893 1.96086 14 2.46957 14 3V3.09C14.0013 3.41179 14.0966 3.72618 14.2743 3.99447C14.452 4.26276 14.7042 4.47324 15 4.6C15.3016 4.73312 15.6362 4.77282 15.9606 4.714C16.285 4.65519 16.5843 4.50054 16.82 4.27L16.88 4.21C17.0657 4.02405 17.2863 3.87653 17.5291 3.77588C17.7719 3.67523 18.0322 3.62343 18.295 3.62343C18.5578 3.62343 18.8181 3.67523 19.0609 3.77588C19.3037 3.87653 19.5243 4.02405 19.71 4.21C19.896 4.39575 20.0435 4.61632 20.1441 4.85912C20.2448 5.10192 20.2966 5.36217 20.2966 5.625C20.2966 5.88783 20.2448 6.14808 20.1441 6.39088C20.0435 6.63368 19.896 6.85425 19.71 7.04L19.65 7.1C19.4195 7.33568 19.2648 7.63502 19.206 7.95941C19.1472 8.28381 19.1869 8.61838 19.32 8.92V9C19.4468 9.29577 19.6572 9.54802 19.9255 9.72569C20.1938 9.90337 20.5082 9.99872 20.83 10H21C21.5304 10 22.0391 10.2107 22.4142 10.5858C22.7893 10.9609 23 11.4696 23 12C23 12.5304 22.7893 13.0391 22.4142 13.4142C22.0391 13.7893 21.5304 14 21 14H20.91C20.5882 14.0013 20.2738 14.0966 20.0055 14.2743C19.7372 14.452 19.5268 14.7042 19.4 15Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="nav-text">Settings</span>
                                <div class="nav-indicator"></div>
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
            
            <div class="sidebar-footer">
                <div class="user-info">
                    <div class="user-avatar">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M20 21V19C20 17.9391 19.5786 16.9217 18.8284 16.1716C18.0783 15.4214 17.0609 15 16 15H8C6.93913 15 5.92172 15.4214 5.17157 16.1716C4.42143 16.9217 4 17.9391 4 19V21" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <circle cx="12" cy="7" r="4" stroke="currentColor" stroke-width="2"/>
                        </svg>
                    </div>
                    <div class="user-details">
                        <h4>{{ Auth::user()->first_name }} {{ Auth::user()->last_name }}</h4>
                        <p>{{ Auth::user()->email }}</p>
                    </div>
                </div>
                <a href="{{ route('logout') }}" class="logout-btn">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M9 21H5C4.46957 21 3.96086 20.7893 3.58579 20.4142C3.21071 20.0391 3 19.5304 3 19V5C3 4.46957 3.21071 3.96086 3.58579 3.58579C3.96086 3.21071 4.46957 3 5 3H9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <polyline points="16,17 21,12 16,7" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <line x1="21" y1="12" x2="9" y2="12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <span>Logout</span>
                </a>
            </div>
        </div>

    <!-- Page-wrapper Start-->
    <div class="page-wrapper">

        @include('frontend::include.__user_header')

        <!-- Page Body Start-->
        <div class="rock-page-body-wrapper">
            @include('frontend::include.__user_side_nav')
            <div class="rock-page-body">
                @yield('content')
            </div>
        </div>
        <!-- Page Body Ends-->
    </div>
    <!-- Page-wrapper end-->

    <!-- Announcement Popup -->
   
    <!-- /Announcement Popup End -->
    
    <!-- Show in 575px in Mobile Screen Start -->
    <!--<div class="rock-mobile-screen-show">
        <div class="rock-bottom-appbar">
            <ul>
                <li @if(Route::is('user.dashboard')) class="active" @endif>
                    <a href="{{ route('user.dashboard') }}">
                        <span class="icon"><svg width="30" height="30" viewBox="0 0 30 30" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <g filter="url(#filter0_i_2565_13566)">
                                    <g filter="url(#filter1_i_2565_13566)">
                                        <path
                                            d="M26.25 22.4586V12.6879C26.25 11.1742 25.5754 9.74062 24.4127 8.78315L18.1627 3.63668C16.3221 2.1211 13.6779 2.12111 11.8373 3.63668L5.58733 8.78315C4.42456 9.74062 3.75 11.1742 3.75 12.6879V22.4586C3.75 25.2429 5.98858 27.5 8.75 27.5H21.25C24.0114 27.5 26.25 25.2429 26.25 22.4586Z"
                                            fill="url(#paint0_linear_2565_13566)" />
                                    </g>
                                    <path
                                        d="M25.75 12.6879V22.4586C25.75 24.9706 23.7314 27 21.25 27H8.75C6.2686 27 4.25 24.9706 4.25 22.4586V12.6879C4.25 11.3228 4.85839 10.0311 5.90516 9.16914L12.1552 4.02267C13.8111 2.65911 16.1889 2.65911 17.8448 4.02266L24.0948 9.16914C25.1416 10.0311 25.75 11.3228 25.75 12.6879Z"
                                        stroke="white" stroke-opacity="0.08" />
                                    <g filter="url(#filter2_i_2565_13566)">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M9.0625 15C9.0625 14.4822 9.48223 14.0625 10 14.0625H20C20.5178 14.0625 20.9375 14.4822 20.9375 15C20.9375 15.5178 20.5178 15.9375 20 15.9375H10C9.48223 15.9375 9.0625 15.5178 9.0625 15Z"
                                            fill="white" />
                                    </g>
                                    <path
                                        d="M9.5625 15C9.5625 14.7584 9.75838 14.5625 10 14.5625H20C20.2416 14.5625 20.4375 14.7584 20.4375 15C20.4375 15.2416 20.2416 15.4375 20 15.4375H10C9.75838 15.4375 9.5625 15.2416 9.5625 15Z"
                                        stroke="white" stroke-opacity="0.08" />
                                    <g filter="url(#filter3_i_2565_13566)">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M9.0625 20C9.0625 19.4822 9.48223 19.0625 10 19.0625H20C20.5178 19.0625 20.9375 19.4822 20.9375 20C20.9375 20.5178 20.5178 20.9375 20 20.9375H10C9.48223 20.9375 9.0625 20.5178 9.0625 20Z"
                                            fill="white" />
                                    </g>
                                    <path
                                        d="M9.5625 20C9.5625 19.7584 9.75838 19.5625 10 19.5625H20C20.2416 19.5625 20.4375 19.7584 20.4375 20C20.4375 20.2416 20.2416 20.4375 20 20.4375H10C9.75838 20.4375 9.5625 20.2416 9.5625 20Z"
                                        stroke="white" stroke-opacity="0.08" />
                                </g>
                                <defs>
                                    <filter id="filter0_i_2565_13566" x="-0.25" y="2.5" width="26.5" height="29"
                                        filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                        <feFlood flood-opacity="0" result="BackgroundImageFix" />
                                        <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix"
                                            result="shape" />
                                        <feColorMatrix in="SourceAlpha" type="matrix"
                                            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
                                        <feOffset dx="-4" dy="4" />
                                        <feGaussianBlur stdDeviation="5" />
                                        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
                                        <feColorMatrix type="matrix"
                                            values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0" />
                                        <feBlend mode="normal" in2="shape" result="effect1_innerShadow_2565_13566" />
                                    </filter>
                                    <filter id="filter1_i_2565_13566" x="-0.25" y="2.5" width="26.5" height="29"
                                        filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                        <feFlood flood-opacity="0" result="BackgroundImageFix" />
                                        <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix"
                                            result="shape" />
                                        <feColorMatrix in="SourceAlpha" type="matrix"
                                            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
                                        <feOffset dx="-4" dy="4" />
                                        <feGaussianBlur stdDeviation="5" />
                                        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
                                        <feColorMatrix type="matrix"
                                            values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0" />
                                        <feBlend mode="normal" in2="shape" result="effect1_innerShadow_2565_13566" />
                                    </filter>
                                    <filter id="filter2_i_2565_13566" x="5.0625" y="14.0625" width="15.875"
                                        height="5.875" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                        <feFlood flood-opacity="0" result="BackgroundImageFix" />
                                        <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix"
                                            result="shape" />
                                        <feColorMatrix in="SourceAlpha" type="matrix"
                                            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
                                        <feOffset dx="-4" dy="4" />
                                        <feGaussianBlur stdDeviation="5" />
                                        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
                                        <feColorMatrix type="matrix"
                                            values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0" />
                                        <feBlend mode="normal" in2="shape" result="effect1_innerShadow_2565_13566" />
                                    </filter>
                                    <filter id="filter3_i_2565_13566" x="5.0625" y="19.0625" width="15.875"
                                        height="5.875" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                        <feFlood flood-opacity="0" result="BackgroundImageFix" />
                                        <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix"
                                            result="shape" />
                                        <feColorMatrix in="SourceAlpha" type="matrix"
                                            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
                                        <feOffset dx="-4" dy="4" />
                                        <feGaussianBlur stdDeviation="5" />
                                        <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1" />
                                        <feColorMatrix type="matrix"
                                            values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0" />
                                        <feBlend mode="normal" in2="shape" result="effect1_innerShadow_2565_13566" />
                                    </filter>
                                    <linearGradient id="paint0_linear_2565_13566" x1="3.75" y1="2.5" x2="28.6119"
                                        y2="24.8757" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#FDD819" />
                                        <stop offset="1" stop-color="#F81717" />
                                    </linearGradient>
                                </defs>
                            </svg>
                        </span>
                       <span class="text">{{ __('Home') }}</span>
                    </a>
                </li>
                <li @if(Route::is('user.deposit.*')) class="active" @endif>
                    <a href="{{ route('user.deposit.amount') }}">
                        <span class="icon"><svg width="31" height="30" viewBox="0 0 31 30" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path opacity="0.4"
                                    d="M28 15C28 21.9036 22.4036 27.5 15.5 27.5C8.59644 27.5 3 21.9036 3 15C3 8.09644 8.59644 2.5 15.5 2.5C22.4036 2.5 28 8.09644 28 15Z"
                                    fill="white" />
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M15.5 7.1875C16.0178 7.1875 16.4375 7.60723 16.4375 8.125V9.1919C17.8803 9.59998 18.9375 10.9265 18.9375 12.5C18.9375 13.0178 18.5178 13.4375 18 13.4375C17.4822 13.4375 17.0625 13.0178 17.0625 12.5C17.0625 11.6371 16.3629 10.9375 15.5 10.9375C14.6371 10.9375 13.9375 11.6371 13.9375 12.5C13.9375 13.3629 14.6371 14.0625 15.5 14.0625C17.3985 14.0625 18.9375 15.6015 18.9375 17.5C18.9375 19.0735 17.8803 20.4 16.4375 20.8081V21.875C16.4375 22.3928 16.0178 22.8125 15.5 22.8125C14.9822 22.8125 14.5625 22.3928 14.5625 21.875V20.8081C13.1197 20.4 12.0625 19.0735 12.0625 17.5C12.0625 16.9822 12.4822 16.5625 13 16.5625C13.5178 16.5625 13.9375 16.9822 13.9375 17.5C13.9375 18.3629 14.6371 19.0625 15.5 19.0625C16.3629 19.0625 17.0625 18.3629 17.0625 17.5C17.0625 16.6371 16.3629 15.9375 15.5 15.9375C13.6015 15.9375 12.0625 14.3985 12.0625 12.5C12.0625 10.9265 13.1197 9.59998 14.5625 9.1919V8.125C14.5625 7.60723 14.9822 7.1875 15.5 7.1875Z"
                                    fill="white" />
                            </svg>
                        </span>
                        <span class="text">{{ __('Deposit') }}</span>
                    </a>
                </li>
                <li @if(Route::is('user.schema.*')) class="active" @endif>
                    <a href="{{ route('user.schema') }}">
                        <span class="icon"><svg width="31" height="30" viewBox="0 0 31 30" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path opacity="0.4"
                                    d="M14.4662 27.0297L4.25423 22.3879C3.27723 21.9438 3.27724 20.5561 4.25423 20.112L14.4662 15.4702C15.1235 15.1714 15.8779 15.1714 16.5352 15.4702L26.7472 20.112C27.7242 20.5561 27.7242 21.9438 26.7472 22.3879L16.5352 27.0297C15.8779 27.3285 15.1235 27.3285 14.4662 27.0297Z"
                                    fill="white" />
                                <path
                                    d="M14.4662 20.7797L4.25423 16.1379C3.27723 15.6938 3.27724 14.3061 4.25423 13.862L14.4662 9.22018C15.1235 8.9214 15.8779 8.9214 16.5352 9.22018L26.7472 13.862C27.7242 14.3061 27.7242 15.6938 26.7472 16.1379L16.5352 20.7797C15.8779 21.0785 15.1235 21.0785 14.4662 20.7797Z"
                                    fill="white" />
                                <path opacity="0.4"
                                    d="M14.4662 14.5297L4.25423 9.88791C3.27723 9.44382 3.27724 8.05608 4.25423 7.61199L14.4662 2.97018C15.1235 2.6714 15.8779 2.6714 16.5352 2.97018L26.7472 7.61199C27.7242 8.05608 27.7242 9.44382 26.7472 9.88791L16.5352 14.5297C15.8779 14.8285 15.1235 14.8285 14.4662 14.5297Z"
                                    fill="white" />
                            </svg>
                        </span>
                        <span class="text">{{ __('Plans') }}</span>
                    </a>
                </li>
                <li @if(Route::is('user.referral.*')) class="active" @endif>
                    <a href="{{ route('user.referral') }}">
                        <span class="icon">
                            <svg width="30" height="30" viewBox="0 0 30 30" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path opacity="0.4"
                                    d="M25 13.75C25 7.5368 19.9632 2.5 13.75 2.5C7.5368 2.5 2.5 7.5368 2.5 13.75C2.5 19.9632 7.5368 25 13.75 25C19.9632 25 25 19.9632 25 13.75Z"
                                    fill="white" />
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M13.5867 17.1875C12.2474 17.1912 10.916 17.557 9.13354 18.3556C8.66103 18.5673 8.10637 18.3558 7.89467 17.8833C7.68298 17.4108 7.89441 16.8561 8.36692 16.6444C10.2668 15.7933 11.8727 15.3173 13.5815 15.3125C15.2828 15.3078 16.9939 15.7707 19.1045 16.632C19.5838 16.8276 19.8139 17.3748 19.6182 17.8542C19.4226 18.3336 18.8754 18.5636 18.396 18.368C16.3813 17.5458 14.9335 17.1838 13.5867 17.1875Z"
                                    fill="white" />
                                <circle cx="3.75" cy="3.75" r="3.75" transform="matrix(1 0 0 -1 10 13.75)"
                                    fill="white" />
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M23.4375 20C23.4375 19.4822 23.0178 19.0625 22.5 19.0625C21.9822 19.0625 21.5625 19.4822 21.5625 20V21.5625H20C19.4822 21.5625 19.0625 21.9822 19.0625 22.5C19.0625 23.0178 19.4822 23.4375 20 23.4375H21.5625V25C21.5625 25.5178 21.9822 25.9375 22.5 25.9375C23.0178 25.9375 23.4375 25.5178 23.4375 25V23.4375H25C25.5178 23.4375 25.9375 23.0178 25.9375 22.5C25.9375 21.9822 25.5178 21.5625 25 21.5625H23.4375V20Z"
                                    fill="white" />
                            </svg>
                        </span>
                        <span class="text">{{ __('Referral') }}</span>
                    </a>
                </li>
                <li @if(Route::is('user.settings.*')) class="active" @endif>
                    <a href="{{ route('user.setting.show') }}">
                        <span class="icon">
                            <svg width="30" height="30" viewBox="0 0 30 30" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path opacity="0.4"
                                    d="M16.1932 3.75H13.8068C12.4889 3.75 11.4204 4.75736 11.4204 6C11.4204 7.42202 9.89896 8.32609 8.65 7.64621L8.52314 7.57716C7.38176 6.95584 5.92228 7.32455 5.2633 8.40071L4.07011 10.3493C3.41113 11.4254 3.8022 12.8015 4.94359 13.4228C6.19314 14.103 6.19314 15.897 4.94358 16.5772C3.8022 17.1985 3.41113 18.5746 4.07011 19.6507L5.2633 21.5993C5.92228 22.6754 7.38176 23.0442 8.52314 22.4228L8.65 22.3538C9.89896 21.6739 11.4204 22.578 11.4204 24C11.4204 25.2426 12.4889 26.25 13.8068 26.25H16.1932C17.5111 26.25 18.5796 25.2426 18.5796 24C18.5796 22.578 20.1011 21.6739 21.35 22.3538L21.4769 22.4228C22.6182 23.0441 24.0777 22.6754 24.7367 21.5993L25.9299 19.6507C26.5889 18.5746 26.1978 17.1985 25.0564 16.5772C23.8069 15.897 23.8069 14.103 25.0564 13.4228C26.1978 12.8015 26.5889 11.4254 25.9299 10.3493L24.7367 8.40073C24.0777 7.32457 22.6182 6.95585 21.4769 7.57717L21.35 7.64622C20.101 8.3261 18.5796 7.42202 18.5796 6C18.5796 4.75736 17.5111 3.75 16.1932 3.75Z"
                                    fill="white" />
                                <circle cx="15" cy="15" r="3.75" fill="white" />
                            </svg>
                        </span>
                        <span class="text">{{ __('Settings') }}</span>
                    </a>
                </li>
            </ul>
        </div>
    </div> 
    <!-- Show in 575px in Mobile Screen End -->

    @include('frontend::include.__script')
</body>

</html>
