@extends('frontend::layouts.user')

@section('title')
    {{ __('Achievement') }}
@endsection

@section('content')

@php
    $hasPurchased = \DB::table('invests')
        ->where('user_id', auth()->id())
        ->where('status', 'ongoing')
        ->exists();
@endphp

@if (!$hasPurchased)
    <style>
    .locked-overlay {
        position: fixed;
        top: 0; left: 0; right: 0; bottom: 0;
        background: linear-gradient(135deg, #1a1a1a, #2c2c2c);
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        padding: 30px;
        font-family: 'Poppins', sans-serif;
        z-index: 9999;
    }

    .locked-overlay h3 {
        font-size: 3rem;
        margin-bottom: 20px;
        color: #FFD700; /* VIP Gold */
        text-shadow: 0 0 10px rgba(255, 215, 0, 0.5);
        letter-spacing: 1px;
    }

    .locked-overlay p {
        font-size: 1.2rem;
        margin-bottom: 30px;
        color: #ccc;
        max-width: 500px;
    }

    .locked-overlay .btn-warning {
        background: linear-gradient(145deg, #FFD700, #FFA500);
        border: none;
        padding: 14px 36px;
        font-size: 1.1rem;
        border-radius: 8px;
        color: #000;
        font-weight: bold;
        text-decoration: none;
        box-shadow: 0 4px 15px rgba(255, 215, 0, 0.4);
        transition: all 0.3s ease;
    }

    .locked-overlay .btn-warning:hover {
        background: linear-gradient(145deg, #FFC300, #FF8C00);
        box-shadow: 0 6px 20px rgba(255, 215, 0, 0.6);
        color: #000;
        transform: translateY(-2px);
    }
</style>

    <div class="locked-overlay">
        <h3>ðŸ”’ Achievements Locked</h3>
        <p>Please purchase a plan to unlock your achievements dashboard.</p>
        <a href="{{ route('user.schema') }}" class="btn btn-warning">Purchase Plan</a>
    </div>

@else
    <div class="container-fluid default-page">
    <div class="row gy-30">
        <div class="col-xl-12">
            @php
                // Auth check
                $user = auth()->user();
                if (!$user) {
                    return redirect()->route('login');
                }
                
                // Get current user's rank information
                $currentRank = $user->rank;
                $rankingName = $currentRank ? $currentRank->ranking_name : 'STRUGGLER';
                $nextRank = \App\Models\Ranking::where('id', '>', $user->ranking_id)->orderBy('id')->first();
                $nextRankName = $nextRank ? $nextRank->ranking_name : 'MAX RANK ACHIEVED';
                $minimumInvest = $currentRank ? $currentRank->minimum_invest : 900;
                
                // Get total number of referral users for the current user
                $totalReferralCount = count($referralUsers);
                
                // Calculate the required amount per referral user
                $perUserRequiredAmount = $totalReferralCount > 0 ? $minimumInvest / $totalReferralCount : $minimumInvest;
                
                // Calculate total earnings
                $totalEarnings = $user->totalReferralProfit();
                
                // Check if all requirements are met to rank up
                $allRequirementsMet = true;
                $totalPendingAmount = 0;
                
                foreach($referralUsers as $referralUser) {
                    $referredUsers = \App\Models\User::where('ref_id', $referralUser->id)->get();
                    $referralUserInvestment = \App\Models\Invest::where('user_id', $referralUser->id)
                        ->where('status', 'ongoing')
                        ->sum('invest_amount');
                    $referredUsersInvestment = \App\Models\Invest::whereIn('user_id', $referredUsers->pluck('id'))
                        ->where('status', 'ongoing')
                        ->sum('invest_amount');
                    $currentSale = $referralUserInvestment + $referredUsersInvestment;
                    $pendingAmount = max(0, $perUserRequiredAmount - $currentSale);
                    $totalPendingAmount += $pendingAmount;
                    
                    if ($pendingAmount > 0) {
                        $allRequirementsMet = false;
                    }
                }
                
                // Check if user just ranked up (from session)
                $justRankedUp = session('just_ranked_up', false);
                // Clear the session flag
                session()->forget('just_ranked_up');
                
                // Calculate progress percentage
                $progressPercentage = ($totalReferralCount > 0 && $minimumInvest > 0)
                    ? min(100, (($minimumInvest - $totalPendingAmount) / $minimumInvest) * 100)
                    : 0;
            @endphp

            <div class="rock-dashboard-card" style="background-color: #000000; border-radius: 10px; padding: 20px; margin-bottom: 30px;">
                <!-- Header Section -->
                <div class="text-center mb-4">
                    <h1 class="text-white" style="font-size: 28px; font-weight: 700; letter-spacing: 1px; @media (min-width: 768px) { font-size: 42px; }">
                        {{ $rankingName }} @if($nextRank) to {{ $nextRankName }} @endif
                    </h1>
                    <p class="text-white" style="font-size: 14px; letter-spacing: 1px; @media (min-width: 768px) { font-size: 16px; }">
                        @if($nextRank)
                            Complete this task to achieve {{ $nextRankName }}
                                                        <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Ranks & Rewards</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            background: #1e1e1e;
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 30px;
            color: white;
        }

        .table-container {
            overflow-x: auto;
            max-width: 100%;
            border-radius: 16px;
        }

        .rank-table {
            min-width: 600px;
            width: 100%;
            border-collapse: collapse;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(8px);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.3);
            border-radius: 14px;
            overflow: hidden;
        }

        .rank-table thead {
            background: rgba(255, 255, 255, 0.08);
        }

        .rank-table th,
        .rank-table td {
            padding: 12px 14px;
            text-align: center;
            color: #fff;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            white-space: nowrap;
        }

        .rank-table th {
            font-weight: 600;
            font-size: 15px;
            text-transform: uppercase;
        }

        .rank-table td {
            font-weight: 300;
            font-size: 14px;
        }

        .rank-table tr:last-child td {
            border-bottom: none;
        }

        @media screen and (max-width: 768px) {
            body {
                padding: 15px;
            }
            .rank-table th, .rank-table td {
                padding: 10px;
                font-size: 13px;
            }
        }
    </style>
</head>
<body>

    <div class="table-container">
        <table class="rank-table">
            <thead>
                <tr>
                    <th>Rank</th>
                    <th>Team Volume (x4)</th>
                    <th>Total Volume</th>
                    <th>Reward</th>
                    <th>Salary</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>🥇 Leader</td>
                    <td>$900 × 4</td>
                    <td>$3,600</td>
                    <td>$200</td>
                    <td>$20</td>
                </tr>
                <tr>
                    <td>🥈 Senior Team Leader</td>
                    <td>$3,600 × 4</td>
                    <td>$14,400</td>
                    <td>$400</td>
                    <td>$40</td>
                </tr>
                <tr>
                    <td>🥉 Sales Manager</td>
                    <td>$14,400 × 4</td>
                    <td>$57,600</td>
                    <td>$1,600</td>
                    <td>$80</td>
                </tr>
                <tr>
                    <td>🏅 Senior Sales Manager</td>
                    <td>$57,600 × 4</td>
                    <td>$230,400</td>
                    <td>$6,400</td>
                    <td>$160</td>
                </tr>
                <tr>
                    <td>🎖 Director</td>
                    <td>$230,400 × 4</td>
                    <td>$921,600</td>
                    <td>$25,600</td>
                    <td>$320</td>
                </tr>
                <tr>
                    <td>🌍 Global Ambassador</td>
                    <td>$921,600 × 4</td>
                    <td>$3,686,400</td>
                    <td>$102,400</td>
                    <td>$1,000</td>
                </tr>
            </tbody>
        </table>
    </div>

</body>
</html>

                        @else
                            You've reached the highest rank!
                        @endif
                    </p>
                    
                    @if($allRequirementsMet && $nextRank)
                        <div class="alert alert-success mt-3">
                            <i class="fas fa-check-circle"></i> Congratulations! You've met all requirements for the next rank.
                        </div>
                    @endif
                </div>
                
                @if($allRequirementsMet && $nextRank && $totalReferralCount > 0)
                    <div class="alert alert-info mt-3">
                        <form action="{{ route('user.achievement.process-rank-up') }}" method="POST">
                            @csrf
                            <input type="hidden" name="current_rank_id" value="{{ $currentRank ? $currentRank->id : 0 }}">
                            <input type="hidden" name="next_rank_id" value="{{ $nextRank->id }}">
                            <button type="submit" class="btn btn-success">
                                Claim Your Rank Up Bonus and Advance to {{ $nextRankName }}
                            </button>
                        </form>
                    </div>
                @endif
                
                <!-- Progress Bar -->
                @if($nextRank)
                <div class="progress-container mb-4">
                    <div class="d-flex justify-content-between mb-2">
                        <span class="text-white">{{ $rankingName }}</span>
                        <span class="text-white">{{ $nextRankName }}</span>
                    </div>
                    <div class="progress" style="height: 10px; background-color: #2c3e50;">
                        <div class="progress-bar bg-success" role="progressbar" 
                             style="width: {{ $progressPercentage }}%;" 
                             aria-valuenow="{{ $progressPercentage }}" 
                             aria-valuemin="0" 
                             aria-valuemax="100"></div>
                    </div>
                    <div class="text-end mt-2">
                        <span class="text-white">{{ number_format($minimumInvest - $totalPendingAmount, 0) }} / {{ $minimumInvest }} {{ $currency }}</span>
                    </div>
                </div>
                @endif
                
                <!-- Stats Section - Responsive -->
                <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4 gap-3">
                    <h3 class="text-white mb-2 mb-md-0" style="font-size: 20px; font-weight: 600; @media (min-width: 768px) { font-size: 24px; }">Achievement</h3>
                    <div class="d-flex flex-wrap gap-2">
                        <span class="badge rounded-pill" style="background-color: #1a2634; color: #fff; border: 1px solid #2c3e50; padding: 6px 12px; font-size: 12px; @media (min-width: 768px) { padding: 8px 15px; font-size: 14px; }">
                            Total Referrals: {{ $totalReferralCount }}
                        </span>
                        <span class="badge rounded-pill" style="background-color: #1a2634; color: #fff; border: 1px solid #2c3e50; padding: 6px 12px; font-size: 12px; @media (min-width: 768px) { padding: 8px 15px; font-size: 14px; }">
                            Total Earnings: {{ number_format($totalEarnings, 0) }} {{ $currency }}
                        </span>
                        <span class="badge rounded-pill" style="background-color: #1a2634; color: #fff; border: 1px solid #2c3e50; padding: 6px 12px; font-size: 12px; @media (min-width: 768px) { padding: 8px 15px; font-size: 14px; }">
                            Required Total: {{ number_format($minimumInvest, 0) }} {{ $currency }}
                        </span>
                    </div>
                </div>
                
                <!-- Table Header - Visible only on md and larger screens -->
                <div class="d-none d-md-grid" style="display: none; grid-template-columns: 20% 15% 15% 15% 15%; background-color: #2c3e50; color: white; padding: 12px; border-radius: 8px 8px 0 0; @media (min-width: 768px) { display: grid; }">
                    <div style="font-weight: 600;">{{ __('Username') }}</div>
                    <div style="font-weight: 600;">{{ __('Reffer') }}</div>
                    <div style="font-weight: 600;">{{ __('Current Sale') }}</div>
                    <div style="font-weight: 600;">{{ __('Pending') }}</div>
                    <div style="font-weight: 600;">{{ __('Required Sale') }}</div>
                </div>
                
                <!-- Table/Card Content -->
                @forelse($referralUsers as $referralUser)
                    @php
                        // Get all users referred by this referral user
                        $referredUsers = \App\Models\User::where('ref_id', $referralUser->id)->get();
                        $referCount = $referredUsers->count();
                        
                        // Calculate total investment of referral user from invests table
                        $referralUserInvestment = \App\Models\Invest::where('user_id', $referralUser->id)
                            ->where('status', 'ongoing')
                            ->sum('invest_amount');
                        
                        // Calculate total investment of all referred users
                        $referredUsersInvestment = \App\Models\Invest::whereIn('user_id', $referredUsers->pluck('id'))
                            ->where('status', 'ongoing')
                            ->sum('invest_amount');
                        
                        // Current sale is the sum of referral user's investment and all their referred users' investments
                        $currentSale = $referralUserInvestment + $referredUsersInvestment;
                        
                        // Required sale is the minimum investment divided by number of referral users
                        $requiredSale = $perUserRequiredAmount;
                        
                        // If user just ranked up, calculate the excess amount (if any)
                        $displayCurrentSale = $currentSale;
                        if ($justRankedUp) {
                            // If current sale is greater than required, only show the excess
                            if ($currentSale > $requiredSale) {
                                $displayCurrentSale = $currentSale - $requiredSale;
                            } else {
                                // Otherwise, show 0
                                $displayCurrentSale = 0;
                            }
                        }
                        
                        // Pending is the remaining amount needed to reach required sale
                        $pendingAmount = max(0, $requiredSale - $currentSale);
                        
                        // Set colors based on values
                        $currentSaleColor = $displayCurrentSale > 0 ? '#00cc00' : '#ffffff';
                        $pendingColor = $pendingAmount > 0 ? '#ff3333' : '#00cc00';
                    @endphp
                    
                    <!-- Mobile Card View -->
                    <div class="d-block d-md-none mb-3" style="background-color: #1e1e1e; border-radius: 8px; overflow: hidden; margin-bottom: 15px;">
                        <div style="padding: 15px;">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <span class="fw-bold" style="font-size: 16px; color: #f0f0f0;">{{ $referralUser->username }}</span>
                                <span class="fw-bold" style="font-size: 14px; color: #f0f0f0;">Referrals: {{ $referCount }}</span>
                            </div>
                            
                            <div class="row g-2 mt-2">
                                <div class="col-6">
                                    <div style="background-color: #1a2634; padding: 10px; border-radius: 6px;">
                                        <div style="font-size: 12px; color: #888;">Current Sale</div>
                                        <div class="fw-bold" style="color: {{ $currentSaleColor }}; font-size: 14px;">
                                            {{ number_format($displayCurrentSale, 0) }} {{ $currency }}
                                            @if($justRankedUp && $currentSale > $requiredSale)
                                                <span class="badge bg-info" style="font-size: 10px;">Excess</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div style="background-color: #1a2634; padding: 10px; border-radius: 6px;">
                                        <div style="font-size: 12px; color: #888;">Pending</div>
                                        <div class="fw-bold" style="color: {{ $pendingColor }}; font-size: 14px;">{{ number_format($pendingAmount, 0) }} {{ $currency }}</div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div style="background-color: #1a2634; padding: 10px; border-radius: 6px;">
                                        <div style="font-size: 12px; color: #888;">Required Sale</div>
                                        <div class="fw-bold" style="color: #f0f0f0; font-size: 14px;">{{ number_format($requiredSale, 0) }} {{ $currency }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Desktop Table View -->
                    <div class="d-none d-md-grid" style="display: none; grid-template-columns: 20% 15% 15% 15% 15%; background-color: #1e1e1e; padding: 15px 12px; border-bottom: 1px solid #333; @media (min-width: 768px) { display: grid; }">
                        <div class="fw-bold" style="font-size: 16px; color: #f0f0f0;">{{ $referralUser->username }}</div>
                        <div class="fw-bold" style="font-size: 16px; color: #f0f0f0;">{{ $referCount }}</div>
                        <div class="fw-bold" style="font-size: 16px; color: {{ $currentSaleColor }};">
                            {{ number_format($displayCurrentSale, 0) }} {{ $currency }}
                            @if($justRankedUp && $currentSale > $requiredSale)
                                <span class="badge bg-info" style="font-size: 10px;">Excess</span>
                            @endif
                        </div>
                        <div class="fw-bold" style="font-size: 16px; color: {{ $pendingColor }};">{{ number_format($pendingAmount, 0) }} {{ $currency }}</div>
                        <div class="fw-bold" style="font-size: 16px; color: #f0f0f0;">{{ number_format($requiredSale, 0) }} {{ $currency }}</div>
                    </div>
                @empty
                    <div class="alert alert-table mt-20 text-center" role="alert" style="background-color: #1e1e1e; color: #e0e0e0; padding: 20px; border-radius: 8px;">
                        {{ __('No Referral Users Found') }}
                    </div>
                @endforelse
            </div>
        </div>
    </div>
</div>

<style>
    body {
        background-color: #121212;
        color: #e0e0e0;
    }

    @media (max-width: 767px) {
        .rock-dashboard-card {
            padding: 15px !important;
        }
        
        h1 {
            font-size: 28px !important;
        }
        
        h3 {
            font-size: 20px !important;
        }
        
        .badge {
            font-size: 12px !important;
            padding: 6px 12px !important;
        }
    }
    
    /* Ensure grid works on supported browsers */
    @supports (display: grid) {
        .d-md-grid {
            display: none;
        }
        
        @media (min-width: 768px) {
            .d-md-grid {
                display: grid !important;
            }
        }
    }
    
    /* Fallback for browsers that don't support grid */
    @supports not (display: grid) {
        .d-md-grid {
            display: none;
        }
        
        @media (min-width: 768px) {
            .d-md-grid {
                display: flex !important;
            }
            
            .d-md-grid > div {
                flex: 1;
            }
        }
    }
    
    .progress-container {
        background-color: #1e1e1e;
        padding: 15px;
        border-radius: 8px;
    }
    
    .alert-success {
        background-color: #1e3a1e;
        color: #4caf50;
        border: 1px solid #4caf50;
        padding: 10px;
        border-radius: 5px;
    }
</style>

@endif

@endsection