@extends('frontend::layouts.user')
@section('content')
<div class="container-fluid default-page">
    @php
        use App\Models\User;
        $users = User::where('id', '!=', auth()->id())->get();
        $authUser = auth()->user();
        $transferChargeType = setting('user_transfer_charge_type', 'percentage');
        $transferCharge = setting('user_transfer_charge', 0);
    @endphp

    <div class="row gy-30" style="margin-bottom: 30px;">
        <div class="col-xxl-12">
            <div class="rock-wallet-exchange-area">
                <div class="rock-dashboard-card">
                    <div class="rock-dashboard-title-inner">
                        <h3 class="rock-dashboard-tile">{{ __('User to User Transfer') }}</h3>
                    </div>
                    <div class="rock-add-mony-wrapper">
                        <form action="{{ route('user.transfer') }}" method="POST">
                            @csrf
                            <div class="row gy-30">
                                <div class="col-xxl-6 col-xl-6 col-lg-6">
                                    <div class="rock-single-input">
                                        <label class="input-label">{{ __('From Wallet') }}</label>
                                        <div class="input-select">
                                            <select name="from_wallet">
                                                <option value="1">{{ __('Main Wallet').' ('. $user->balance.' '.$currency .')' }}</option>
                                                <option selected value="2">{{ __('Profit Wallet').' ('. $user->profit_balance.' '.$currency .')' }}</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="rock-single-input">
    <label class="input-label" for="receiver_search">{{ __('Recipient Email') }}</label>
    <div class="input-field">
        <input type="email" class="box-input" name="receiver_identifier" id="receiver_search" placeholder="{{ __('Type email') }}" required autocomplete="off">
    </div>
</div>


                                    <div class="rock-single-input">
                                        <label class="input-label" for="amount">{{ __('Amount') }}</label>
                                        <div class="input-field">
                                            <input type="text" class="box-input" name="amount" id="amount" oninput="this.value = validateDouble(this.value)" placeholder="{{ __('Enter amount') }}" required>
                                            <span class="input-icon">
                                                <!-- SVG remains same -->
                                            </span>
                                        </div>
                                        <p class="input-description">{{ __('Transfer Fee: ') }} {{ $transferCharge }} {{ $transferChargeType === 'percentage' ? '%' : $currency }}</p>
                                    </div>
                                </div>

                                <div class="col-xxl-6 col-xl-6 col-lg-6">
                                    <div class="rock-add-mony-details">
                                        <h4 class="title">{{ __('Review Details') }}</h4>
                                        <div class="rock-add-mony-list">
                                            <ul>
                                                <li><span class="title">{{ __('Recipient') }}</span><span class="info recipient-preview">-</span></li>
                                                <li><span class="title">{{ __('Amount') }}</span><span class="info"><span class="amount-preview">0</span> <span class="currency">{{ $currency }}</span></span></li>
                                                <li><span class="title">{{ __('Fee') }}</span><span class="info fee-preview">0 {{ $currency }}</span></li>
                                                <li><span class="title">{{ __('Total') }}</span><span class="info total-preview">0 {{ $currency }}</span></li>
                                                <li><span class="title">{{ __('Recipient Gets') }}</span><span class="info gets-preview">0 {{ $currency }}</span></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="rock-input-btn-wrap justify-content-end">
                                    <button type="submit" class="site-btn gradient-btn radius-10">
                                        {{ __('Transfer Now') }}
                                    </button>
                                </div>
                            </div>
                        </form>

                        @if(session('success'))
                            <div class="alert alert-success mt-3">{{ session('success') }}</div>
                        @elseif(session('error'))
                            <div class="alert alert-danger mt-3">{{ session('error') }}</div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const currency = @json($currency);
        const chargeType = @json(setting('user_transfer_charge_type', 'percentage'));
        const charge = parseFloat(@json(setting('user_transfer_charge', 0)));

        const amountInput = document.getElementById('amount');
        const receiverInput = document.getElementById('receiver_search');

        function calculateFee(amount) {
            return (chargeType === 'percentage') ? (amount * charge / 100).toFixed(2) : charge.toFixed(2);
        }

        function updatePreview() {
            const amount = parseFloat(amountInput.value) || 0;
            const fee = parseFloat(calculateFee(amount));
            const total = (amount + fee).toFixed(2);
            const gets = amount.toFixed(2);

            document.querySelector('.recipient-preview').textContent = receiverInput.value || '-';
            document.querySelector('.amount-preview').textContent = gets;
            document.querySelector('.fee-preview').textContent = fee + ' ' + currency;
            document.querySelector('.total-preview').textContent = total + ' ' + currency;
            document.querySelector('.gets-preview').textContent = gets + ' ' + currency;
        }

        amountInput.addEventListener('input', updatePreview);
        receiverInput.addEventListener('input', updatePreview);
    });
</script>



<div class="row gy-30" style="margin-top:12px">
    <div class="col-xxl-12">
        <div class="rock-wallet-exchange-area">
            <div class="rock-dashboard-card">
                <div class="rock-dashboard-title-inner">
                    <h3 class="rock-dashboard-tile">{{ __('Wallet Exchange') }}</h3>
                </div>
                <div class="rock-add-mony-wrapper">
                    <form action="{{ route('user.wallet-exchange-now') }}" method="POST">
                        @csrf
                        <div class="row gy-30">
                            <div class="col-xxl-6 col-xl-6 col-lg-6">
                                <div class="rock-single-input">
                                    <label class="input-label">{{ __('From Wallet') }}</label>
                                    <div class="input-select">
                                        <select name="from_wallet">
                                            <option value="1">{{ __('Main Wallet').' ('. $user->balance.' '.$currency .')' }}</option>
                                            <option selected value="2">{{ __('Profit Wallet').' ('. $user->profit_balance.' '.$currency .')' }}</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="rock-single-input">
                                    <label class="input-label">{{ __('Enter Amount') }}</label>
                                    <div class="input-field">
                                        <input type="text" class="box-input" name="amount" oninput="this.value = validateDouble(this.value)" id="amount" placeholder="{{ __('Enter Amount') }}">
                                        <span class="input-icon">
                                            {{-- SVG ICON HERE --}}
                                        </span>
                                    </div>
                                    <p class="input-description charge"></p>
                                </div>

                                <div class="rock-single-input">
                                    <label class="input-label">{{ __('To Wallet') }}</label>
                                    <div class="input-select">
                                        <select name="to_wallet">
                                            <option selected value="1">{{ __('Main Wallet').' ('. $user->balance.' '.$currency .')' }}</option>
                                            <option value="2">{{ __('Profit Wallet').' ('. $user->profit_balance.' '.$currency .')' }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xxl-6 col-xl-6 col-lg-6">
                                <div class="rock-add-mony-details">
                                    <h4 class="title">{{ __('Review Details') }}</h4>
                                    <div class="rock-add-mony-list">
                                        <ul>
                                            <li>
                                                <span class="title">{{ __('Amount') }}</span>
                                                <span class="info"><span class="amount"></span> <span class="currency"></span></span>
                                            </li>
                                            <li>
                                                <span class="title">{{ __('Charge') }}</span>
                                                <span class="info charge2"></span>
                                            </li>
                                            <li>
                                                <span class="title">{{ __('Total') }}</span>
                                                <span class="title total"></span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                            <div class="rock-input-btn-wrap justify-content-end">
                                <button type="submit" class="site-btn gradient-btn radius-10">
                                    {{ __('Proceed to exchange') }}
                                    {{-- SVG ICON HERE --}}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
<script>
    "use strict";

    var currency = @json($currency);
    var charge_type = @json(setting('wallet_exchange_charge_type', 'fee'));
    var charge = @json(setting('wallet_exchange_charge', 'fee'));

    function calPercentage(amount, percent) {
        return (Number(amount) * Number(percent)) / 100;
    }

    function validateDouble(value) {
        return value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');
    }

    $(document).ready(function () {
        $('#amount').on('keyup', function () {
            var amount = $(this).val();
            $('.amount').text(Number(amount));
            $('.currency').text(currency);

            var finalCharge = charge_type === 'percentage' ? calPercentage(amount, charge) : Number(charge);
            $('.charge2').text(finalCharge + ' ' + currency);
            $('.total').text((Number(amount) + Number(finalCharge)) + ' ' + currency);
            $('.charge').text('Charge ' + charge + (charge_type === 'percentage' ? ' %' : ' ' + currency));
        });
    });
</script>
@endsection