@extends('frontend::layouts.user')
@section('title')
    {{ __('Verify Withdrawal OTP') }}
@endsection
@section('content')
    <div class="container-fluid default-page">
        <div class="row gy-30">
            <div class="col-xxl-12">
                <div class="rock-withdraw-area">
                    <div class="rock-dashboard-card">
                        <div class="rock-dashboard-title-inner">
                            <div class="content">
                                <h3 class="rock-dashboard-tile">{{ __('Verify Withdrawal OTP') }}</h3>
                            </div>
                        </div>
                        <div class="rock-add-mony-wrapper">
                            <div class="text-center mb-4">
                                <p>{{ __('We have sent a verification code to your email address. Please enter the code below to verify your withdrawal request.') }}</p>
                            </div>
                            <form action="{{ route('user.withdraw.verify-otp') }}" method="POST">
                                @csrf
                                <div class="row gy-30">
                                    <div class="col-xxl-6 col-xl-6 col-lg-6">
                                        <div class="rock-single-input">
                                            <label class="input-label" for="otp">{{ __('Enter OTP Code') }}</label>
                                            <div class="input-field">
                                                <input type="text" class="box-input" name="otp" id="otp" placeholder="Enter 6-digit OTP" required>
                                            </div>
                                            <p class="input-description">{{ __('The OTP will expire in 10 minutes') }}</p>
                                        </div>
                                    </div>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6">
                                        <div class="rock-add-mony-details">
                                            <h4 class="title">{{ __('Withdraw Details') }}</h4>
                                            <div class="rock-add-mony-list">
                                                <ul>
                                                    <li>
                                                        <span class="title">{{ __('Withdraw Amount') }}</span>
                                                        <span class="info">{{ $withdrawData['amount'] }} {{ $currency }}</span>
                                                    </li>
                                                    <li>
                                                        <span class="title">{{ __('Withdraw Method') }}</span>
                                                        <span class="info">{{ $withdrawAccount->method_name }}</span>
                                                    </li>
                                                    <li>
                                                        <span class="title">{{ __('Fee') }}</span>
                                                        <span class="info">{{ $withdrawData['charge'] }} {{ $currency }}</span>
                                                    </li>
                                                    <li>
                                                        <span class="title">{{ __('Total Amount') }}</span>
                                                        <span class="info">{{ $withdrawData['total_amount'] }} {{ $currency }}</span>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="rock-input-btn-wrap justify-content-between">
                                        <a href="{{ route('user.withdraw.resend-otp') }}" class="site-btn outline-btn radius-10">
                                            {{ __('Resend OTP') }}
                                        </a>
                                        <button type="submit" class="site-btn gradient-btn radius-10">
                                            {{ __('Verify & Withdraw') }}
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path opacity="0.4"
                                                    d="M19 13C19 17.4183 15.4183 21 11 21C6.58172 21 3 17.4183 3 13C3 8.58172 6.58172 5 11 5C15.4183 5 19 8.58172 19 13Z"
                                                    fill="white" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M16 3.75C15.5858 3.75 15.25 3.41421 15.25 3C15.25 2.58579 15.5858 2.25 16 2.25H21C21.4142 2.25 21.75 2.58579 21.75 3V8C21.75 8.41421 21.4142 8.75 21 8.75C20.5858 8.75 20.25 8.41421 20.25 8V4.81066L10.5303 14.5303C10.2374 14.8232 9.76256 14.8232 9.46967 14.5303C9.17678 14.2374 9.17678 13.7626 9.46967 13.4697L19.1893 3.75H16Z"
                                                    fill="white" />
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection