@extends('frontend::layouts.app')
@section('title')
{{ $data['title'] ?? 'Investment Plans' }}
@endsection
@section('meta_keywords')
{{ $data['meta_keywords'] ?? 'investment, plans, schemes' }}
@endsection
@section('meta_description')
{{ $data['meta_description'] ?? 'Choose from our investment plans' }}
@endsection
@section('content')

<!-- InvestFlow Schema Page -->
<div class="schema-page">
    <div class="container">
        <div class="page-header">
            <h1 class="page-title">{{ $data['title'] ?? 'Investment Plans' }}</h1>
            <p class="page-subtitle">{{ $data['meta_description'] ?? 'Choose from our investment plans' }}</p>
        </div>

        <div class="schemas-grid">
            @foreach($schemas as $schema)
            <div class="schema-card glass-effect">
                <div class="schema-header">
                    <div class="schema-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="schema-title">
                        <h3>{{ $schema->name }}</h3>
                        <p>{{ $schema->description }}</p>
                    </div>
                </div>
                
                <div class="schema-details">
                    <div class="detail-item">
                        <span class="label">Investment Type:</span>
                        <span class="value">{{ ucfirst($schema->type) }}</span>
                    </div>
                    @if($schema->type == 'range')
                    <div class="detail-item">
                        <span class="label">Minimum Amount:</span>
                        <span class="value">{{ $currencySymbol }}{{ number_format($schema->min_amount, 2) }}</span>
                    </div>
                    <div class="detail-item">
                        <span class="label">Maximum Amount:</span>
                        <span class="value">{{ $currencySymbol }}{{ number_format($schema->max_amount, 2) }}</span>
                    </div>
                    @else
                    <div class="detail-item">
                        <span class="label">Fixed Amount:</span>
                        <span class="value">{{ $currencySymbol }}{{ number_format($schema->fixed_amount, 2) }}</span>
                    </div>
                    @endif
                    <div class="detail-item">
                        <span class="label">Return Interest:</span>
                        <span class="value">{{ $schema->return_interest }}{{ $schema->interest_type == 'percentage' ? '%' : ' ' . $currency }}</span>
                    </div>
                    <div class="detail-item">
                        <span class="label">Return Period:</span>
                        <span class="value">{{ $schema->schedule->name ?? 'Daily' }}</span>
                    </div>
                    <div class="detail-item">
                        <span class="label">Number of Periods:</span>
                        <span class="value">{{ $schema->return_type == 'period' ? $schema->number_of_period : 'Unlimited' }}</span>
                    </div>
                    <div class="detail-item">
                        <span class="label">Capital Back:</span>
                        <span class="value">{{ $schema->capital_back ? 'Yes' : 'No' }}</span>
                    </div>
                    @if($schema->off_days)
                    <div class="detail-item">
                        <span class="label">Off Days:</span>
                        <span class="value">{{ implode(', ', json_decode($schema->off_days, true)) }}</span>
                    </div>
                    @endif
                    @if($schema->is_trending)
                    <div class="detail-item trending">
                        <span class="label">Status:</span>
                        <span class="value trending-badge">🔥 Trending</span>
                    </div>
                    @endif
                </div>

                <div class="schema-actions">
                    <a href="{{ route('user.schema.preview', $schema->id) }}" class="btn-preview">
                        <i class="fas fa-eye"></i>
                        <span>Preview</span>
                    </a>
                    <a href="{{ route('user.schema.select', $schema->id) }}" class="btn-invest">
                        <i class="fas fa-plus"></i>
                        <span>Invest Now</span>
                    </a>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>

<!-- Schema Page Styles -->
<style>
.schema-page {
    min-height: 100vh;
    background: linear-gradient(135deg, var(--background-primary) 0%, var(--background-secondary) 100%);
    padding: 2rem 0;
}

.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 2rem;
}

.page-header {
    text-align: center;
    margin-bottom: 3rem;
}

.page-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 1rem;
}

.page-subtitle {
    font-size: 1.1rem;
    color: var(--text-secondary);
    max-width: 600px;
    margin: 0 auto;
}

.schemas-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 2rem;
}

.schema-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 2rem;
    border: 1px solid rgba(255, 255, 255, 0.1);
    transition: var(--transition);
}

.schema-card:hover {
    transform: translateY(-5px);
    background: rgba(255, 255, 255, 0.08);
}

.schema-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.schema-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
}

.schema-title h3 {
    font-size: 1.3rem;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 0.5rem;
}

.schema-title p {
    color: var(--text-secondary);
    font-size: 0.9rem;
    line-height: 1.5;
}

.schema-details {
    margin-bottom: 2rem;
}

.detail-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.detail-item:last-child {
    border-bottom: none;
}

.detail-item .label {
    color: var(--text-secondary);
    font-size: 0.9rem;
}

.detail-item .value {
    color: var(--text-primary);
    font-weight: 600;
    font-size: 0.9rem;
}

.detail-item.trending .value {
    color: var(--text-primary);
}

.trending-badge {
    background: linear-gradient(135deg, #ff6b6b, #ee5a24);
    color: white !important;
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.schema-actions {
    display: flex;
    gap: 1rem;
}

.btn-preview, .btn-invest {
    flex: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    padding: 0.75rem 1rem;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    transition: var(--transition);
    border: none;
    cursor: pointer;
}

.btn-preview {
    background: var(--surface-light);
    color: var(--text-primary);
    border: 1px solid var(--border);
}

.btn-preview:hover {
    background: var(--surface-lighter);
    color: var(--text-primary);
    text-decoration: none;
}

.btn-invest {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: white;
}

.btn-invest:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
    color: white;
    text-decoration: none;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .container {
        padding: 0 1rem;
    }
    
    .page-title {
        font-size: 2rem;
    }
    
    .schemas-grid {
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }
    
    .schema-card {
        padding: 1.5rem;
    }
    
    .schema-actions {
        flex-direction: column;
    }
}

@media (max-width: 480px) {
    .page-title {
        font-size: 1.5rem;
    }
    
    .schema-header {
        flex-direction: column;
        text-align: center;
    }
    
    .detail-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.25rem;
    }
}
</style>

@endsection

