@extends('frontend::layouts.user')

@section('content')
<div class="page-container">
    <div class="page-header">
        <button class="back-btn" onclick="window.history.back()">
            <i class="fas fa-arrow-left"></i>
        </button>
        <h2>Referral Tree</h2>
    </div>
    
    <div class="referral-container">
        <div class="referral-stats glass-effect">
            <div class="stat-item">
                <span class="stat-label">Total Referrals</span>
                <span class="stat-value">{{ $getReferral->referralCount ?? 0 }}</span>
            </div>
            <div class="stat-item">
                <span class="stat-label">Earnings</span>
                <span class="stat-value">${{ number_format($totalReferralProfit ?? 0, 2) }}</span>
            </div>
        </div>
        
        <div class="referral-link glass-effect">
            <span>Your Referral Link</span>
            <div class="link-container">
                <input type="text" value="{{ $getReferral->direct_link ?? '#' }}" id="referralLink" readonly>
                <button class="copy-btn" onclick="copyReferralLink()">
                    <i class="fas fa-copy"></i>
                </button>
            </div>
            <p class="link-note">Share this link to earn commissions from your referrals</p>
        </div>
        
        @if(isset($referralUsers) && $referralUsers->count() > 0)
        <div class="referral-users glass-effect">
            <h3>Your Referral Users</h3>
            <div class="users-list">
                @foreach($referralUsers->take(10) as $referralUser)
                <div class="user-item">
                    <div class="user-avatar">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="user-details">
                        <span class="user-name">{{ $referralUser->first_name }} {{ $referralUser->last_name }}</span>
                        <span class="user-email">{{ $referralUser->email }}</span>
                        <span class="user-join-date">Joined: {{ $referralUser->created_at->format('M d, Y') }}</span>
                    </div>
               <div class="user-stats">
                   <span class="user-balance">${{ number_format($referralUser->total_invest ?? 0, 2) }}</span>
                   <span class="user-status {{ $referralUser->status ? 'active' : 'inactive' }}">
                       {{ $referralUser->status ? 'Active' : 'Inactive' }}
                   </span>
               </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif
        
        @if(isset($referrals) && $referrals->count() > 0)
        <div class="referral-tree">
            <h3>Your Referral Network</h3>
            @foreach($referrals as $target => $referral)
                @php
                    $target = json_decode($target, true);
                @endphp
                <div class="tree-level">
                    <h4>
                        @if(setting('site_referral','global') == 'level')
                            Level {{ $target['the_order'] ?? 1 }}
                        @else
                            {{ $target['name'] ?? 'Referrals' }}
                        @endif
                    </h4>
                    <div class="tree-nodes">
                        @foreach($referral->take(10) as $ref)
                        <div class="tree-node glass-effect">
                            <div class="node-info">
                                <div class="node-avatar">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div class="node-details">
                                    <span class="node-name">{{ $ref->description ?? 'Referral User' }}</span>
                                    <span class="node-date">{{ \Carbon\Carbon::parse($ref->join_date ?? $ref->created_at)->format('M d, Y') }}</span>
                                </div>
                            </div>
                            <div class="node-earnings">${{ number_format($ref->amount, 2) }}</div>
                        </div>
                        @endforeach
                    </div>
                </div>
            @endforeach
        </div>
        @endif
    </div>
</div>

<style>
.page-container {
    padding: 20px;
    max-width: 500px;
    margin: 0 auto;
}

.page-header {
    display: flex;
    align-items: center;
    margin-bottom: 30px;
}

.back-btn {
    background: none;
    border: none;
    color: #fff;
    font-size: 18px;
    margin-right: 15px;
    cursor: pointer;
    padding: 8px;
    border-radius: 8px;
    transition: background 0.3s ease;
}

.back-btn:hover {
    background: rgba(255, 255, 255, 0.1);
}

.page-header h2 {
    color: #fff;
    margin: 0;
    font-weight: 600;
}

.referral-container {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.referral-stats {
    display: flex;
    justify-content: space-between;
    padding: 20px;
    border-radius: 15px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.stat-item {
    text-align: center;
    flex: 1;
}

.stat-label {
    display: block;
    color: rgba(255, 255, 255, 0.7);
    font-size: 14px;
    margin-bottom: 8px;
}

.stat-value {
    display: block;
    color: #00d4ff;
    font-size: 24px;
    font-weight: 700;
}

.referral-link {
    padding: 20px;
    border-radius: 15px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.referral-link span {
    display: block;
    color: #fff;
    font-weight: 600;
    margin-bottom: 15px;
}

.link-container {
    display: flex;
    align-items: center;
    gap: 10px;
}

.link-container input {
    flex: 1;
    padding: 12px 15px;
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 8px;
    color: #fff;
    font-size: 14px;
    font-family: 'Courier New', monospace;
}

.link-note {
    color: rgba(255, 255, 255, 0.7);
    font-size: 12px;
    margin-top: 10px;
    text-align: center;
}

.copy-btn {
    padding: 12px;
    background: linear-gradient(135deg, #00d4ff, #0099cc);
    border: none;
    border-radius: 8px;
    color: #fff;
    cursor: pointer;
    transition: all 0.3s ease;
}

.copy-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0, 212, 255, 0.4);
}

.referral-users {
    padding: 20px;
    border-radius: 15px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.referral-users h3 {
    color: #fff;
    margin-bottom: 15px;
    font-weight: 600;
}

.users-list {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.user-item {
    display: flex;
    align-items: center;
    padding: 15px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 12px;
    transition: all 0.3s ease;
}

.user-item:hover {
    background: rgba(255, 255, 255, 0.1);
    transform: translateY(-2px);
}

.user-avatar {
    width: 45px;
    height: 45px;
    border-radius: 12px;
    background: linear-gradient(135deg, #00ff88, #00cc6a);
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 15px;
    color: #000;
    font-size: 18px;
}

.user-details {
    flex: 1;
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.user-name {
    color: #fff;
    font-weight: 600;
    font-size: 14px;
}

.user-email {
    color: rgba(255, 255, 255, 0.7);
    font-size: 12px;
}

.user-join-date {
    color: rgba(255, 255, 255, 0.5);
    font-size: 11px;
}

.user-stats {
    display: flex;
    flex-direction: column;
    align-items: flex-end;
    gap: 4px;
}

.user-balance {
    color: #00ff88;
    font-weight: 600;
    font-size: 14px;
}

.user-status {
    padding: 4px 8px;
    border-radius: 8px;
    font-size: 11px;
    font-weight: 600;
}

.user-status.active {
    background: rgba(0, 255, 136, 0.2);
    color: #00ff88;
}

.user-status.inactive {
    background: rgba(255, 255, 255, 0.1);
    color: rgba(255, 255, 255, 0.6);
}

.referral-history {
    padding: 20px;
    border-radius: 15px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.referral-history h3 {
    color: #fff;
    margin-bottom: 15px;
    font-weight: 600;
}

.history-list {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.history-item {
    display: flex;
    align-items: center;
    padding: 12px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 10px;
    transition: all 0.3s ease;
}

.history-item:hover {
    background: rgba(255, 255, 255, 0.1);
}

.history-icon {
    width: 35px;
    height: 35px;
    border-radius: 8px;
    background: linear-gradient(135deg, #4ecdc4, #44a08d);
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 12px;
    color: #fff;
}

.history-details {
    flex: 1;
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.history-title {
    color: #fff;
    font-weight: 500;
    font-size: 14px;
}

.history-date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 12px;
}

.history-amount {
    color: #4ecdc4;
    font-weight: 600;
    font-size: 14px;
}

.referral-tree h3 {
    color: #fff;
    margin-bottom: 15px;
    font-weight: 600;
}

.tree-level {
    margin-bottom: 20px;
}

.tree-level h4 {
    color: #00ff88;
    margin-bottom: 10px;
    font-weight: 600;
    font-size: 16px;
}

.tree-nodes {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.tree-node {
    display: flex;
    align-items: center;
    padding: 15px;
    border-radius: 12px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    transition: all 0.3s ease;
}

.tree-node:hover {
    background: rgba(255, 255, 255, 0.15);
    transform: translateY(-2px);
}

.node-info {
    display: flex;
    align-items: center;
    flex: 1;
}

.node-avatar {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    background: linear-gradient(135deg, #00ff88, #00cc6a);
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 12px;
    color: #000;
}

.node-details {
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.node-name {
    color: #fff;
    font-weight: 500;
    font-size: 14px;
}

.node-date {
    color: rgba(255, 255, 255, 0.6);
    font-size: 12px;
}

.node-earnings {
    color: #00ff88;
    font-weight: 600;
    font-size: 14px;
}


@media (max-width: 768px) {
    .page-container {
        padding: 15px;
    }
    
    .referral-stats {
        padding: 15px;
    }
    
    .stat-value {
        font-size: 20px;
    }
    
    .referral-link {
        padding: 15px;
    }
    
    .link-container input {
        font-size: 12px;
        padding: 10px 12px;
    }
}
</style>

<script>
function copyReferralLink() {
    const link = document.getElementById('referralLink');
    link.select();
    link.setSelectionRange(0, 99999); // For mobile devices
    
    try {
        document.execCommand('copy');
        showCopySuccess('Link copied!');
    } catch (err) {
        console.error('Failed to copy: ', err);
        showCopySuccess('Failed to copy link');
    }
}

function showCopySuccess(message) {
    // Create a temporary success message
    const successMsg = document.createElement('div');
    successMsg.textContent = message;
    successMsg.style.cssText = `
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        background: rgba(0, 212, 255, 0.9);
        color: white;
        padding: 12px 20px;
        border-radius: 8px;
        font-weight: 600;
        z-index: 1000;
        backdrop-filter: blur(10px);
    `;
    
    document.body.appendChild(successMsg);
    
    setTimeout(() => {
        document.body.removeChild(successMsg);
    }, 2000);
}
</script>
@endsection

