@extends('frontend.shahdeveloper.layouts.user')

@section('title')
    {{ __('Ticket Logs') }}
@endsection

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('user.ticket.index') }}">{{ __('Support') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('Ticket Logs') }}</li>
                    </ol>
                </div>
                <h4 class="page-title">{{ __('Ticket Logs') }}</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="header-title">{{ __('All Tickets with Replies') }}</h4>
                        <div class="btn-group">
                            <a href="{{ route('user.ticket.index') }}" class="btn btn-outline-primary">
                                <i class="fas fa-list"></i> {{ __('All Tickets') }}
                            </a>
                            <a href="{{ route('user.ticket.new') }}" class="btn btn-primary">
                                <i class="fas fa-plus"></i> {{ __('New Ticket') }}
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    @if($tickets->count() > 0)
                        <div class="ticket-logs-container">
                            @foreach($tickets as $ticket)
                                <div class="ticket-log-item">
                                    <div class="ticket-log-header">
                                        <div class="ticket-info">
                                            <h5 class="ticket-title">{{ $ticket->title }}</h5>
                                            <div class="ticket-meta">
                                                <span class="badge badge-info">#{{ $ticket->uuid }}</span>
                                                <span class="text-muted">{{ $ticket->created_at }}</span>
                                                @if($ticket->status == 'open')
                                                    <span class="badge badge-success">{{ __('Open') }}</span>
                                                @elseif($ticket->status == 'closed')
                                                    <span class="badge badge-warning">{{ __('Closed') }}</span>
                                                @else
                                                    <span class="badge badge-secondary">{{ ucfirst($ticket->status) }}</span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="ticket-actions">
                                            <a href="{{ route('user.ticket.show', $ticket->uuid) }}" 
                                               class="btn btn-sm btn-outline-primary">
                                                <i class="fas fa-eye"></i> {{ __('View') }}
                                            </a>
                                        </div>
                                    </div>
                                    
                                    <!-- Original Message -->
                                    <div class="ticket-message user-message">
                                        <div class="message-header">
                                            <div class="message-author">
                                                <i class="fas fa-user-circle text-success"></i>
                                                <span class="author-name">{{ __('You') }}</span>
                                            </div>
                                            <div class="message-time">{{ $ticket->created_at }}</div>
                                        </div>
                                        <div class="message-content">
                                            <p>{{ strip_tags($ticket->message) }}</p>
                                            @if($ticket->attach)
                                                <div class="message-attachment">
                                                    <i class="fas fa-paperclip"></i>
                                                    <a href="{{ asset('storage/tickets/' . $ticket->attach) }}" target="_blank">
                                                        {{ $ticket->attach }}
                                                    </a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>

                                    <!-- Admin Replies -->
                                    @if($ticket->messages && $ticket->messages->count() > 0)
                                        @foreach($ticket->messages as $reply)
                                            <div class="ticket-message admin-message">
                                                <div class="message-header">
                                                    <div class="message-author">
                                                        <i class="fas fa-shield-alt text-warning"></i>
                                                        <span class="author-name">{{ __('Admin') }}</span>
                                                    </div>
                                                    <div class="message-time">{{ $reply->created_at }}</div>
                                                </div>
                                                <div class="message-content">
                                                    <p>{{ strip_tags($reply->message) }}</p>
                                                    @if($reply->attach)
                                                        <div class="message-attachment">
                                                            <i class="fas fa-paperclip"></i>
                                                            <a href="{{ asset('storage/tickets/' . $reply->attach) }}" target="_blank">
                                                                {{ $reply->attach }}
                                                            </a>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="no-replies">
                                            <i class="fas fa-comment-slash text-muted"></i>
                                            <span>{{ __('No admin replies yet') }}</span>
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div class="empty-state">
                                <i class="fas fa-ticket-alt fa-3x text-muted mb-3"></i>
                                <h4>{{ __('No Tickets Found') }}</h4>
                                <p class="text-muted">{{ __('You haven\'t created any support tickets yet.') }}</p>
                                <a href="{{ route('user.ticket.new') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> {{ __('Create New Ticket') }}
                                </a>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('style')
<style>
.ticket-logs-container {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.ticket-log-item {
    background: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    padding: 20px;
    transition: all 0.3s ease;
}

.ticket-log-item:hover {
    background: #e9ecef;
    border-color: #007bff;
}

.ticket-log-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 20px;
    padding-bottom: 15px;
    border-bottom: 1px solid #dee2e6;
}

.ticket-info {
    flex: 1;
}

.ticket-title {
    color: #495057;
    margin: 0 0 10px 0;
    font-weight: 600;
    font-size: 18px;
}

.ticket-meta {
    display: flex;
    align-items: center;
    gap: 15px;
    flex-wrap: wrap;
}

.ticket-message {
    margin-bottom: 15px;
    padding: 15px;
    border-radius: 6px;
    border: 1px solid #e9ecef;
}

.user-message {
    background: #d4edda;
    border-left: 4px solid #28a745;
}

.admin-message {
    background: #fff3cd;
    border-left: 4px solid #ffc107;
}

.message-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
}

.message-author {
    display: flex;
    align-items: center;
    gap: 8px;
}

.author-name {
    color: #495057;
    font-weight: 600;
    font-size: 14px;
}

.message-time {
    color: #6c757d;
    font-size: 12px;
}

.message-content p {
    color: #495057;
    margin: 0;
    line-height: 1.6;
    font-size: 14px;
}

.message-attachment {
    margin-top: 10px;
    padding: 8px;
    background: rgba(0, 0, 0, 0.05);
    border-radius: 4px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.message-attachment i {
    color: #007bff;
    width: 14px;
    height: 14px;
}

.message-attachment a {
    color: #007bff;
    text-decoration: none;
    font-size: 12px;
}

.message-attachment a:hover {
    text-decoration: underline;
}

.no-replies {
    text-align: center;
    padding: 20px;
    color: #6c757d;
    background: #f8f9fa;
    border-radius: 6px;
    border: 1px dashed #dee2e6;
}

.empty-state {
    text-align: center;
    padding: 40px 20px;
}

.empty-state h4 {
    color: #495057;
    margin-bottom: 10px;
    font-weight: 600;
}

.empty-state p {
    color: #6c757d;
    margin-bottom: 20px;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .ticket-log-header {
        flex-direction: column;
        gap: 15px;
    }
    
    .ticket-meta {
        justify-content: center;
    }
    
    .ticket-message {
        padding: 12px;
    }
    
    .message-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 5px;
    }
}
</style>
@endpush
