@php use App\Enums\TxnStatus; @endphp
@extends('frontend.shahdeveloper.layouts.user')

@section('content')
<div class="page-container">
    <div class="page-header">
        <button class="back-btn" onclick="window.history.back()">
            <i class="fas fa-arrow-left"></i>
        </button>
        <h2>Transaction History</h2>
    </div>
    
    <div class="history-container">
        <div class="filter-tabs">
            <button class="filter-tab active" data-filter="all">All</button>
            <button class="filter-tab" data-filter="deposit">Deposits</button>
            <button class="filter-tab" data-filter="withdraw">Withdrawals</button>
            <button class="filter-tab" data-filter="transfer">Transfers</button>
        </div>
        
        <div class="transaction-history" id="transactionList">
            @forelse($transactions as $transaction)
            <div class="transaction-item glass-effect" data-type="{{ $transaction->type->value }}">
                <div class="transaction-icon {{ $transaction->type->value }}">
                    @switch($transaction->type->value)
                        @case('deposit')
                        @case('manual_deposit')
                            <i class="fas fa-arrow-down"></i>
                            @break
                        @case('withdraw')
                            <i class="fas fa-arrow-up"></i>
                            @break
                        @case('investment')
                            <i class="fas fa-chart-line"></i>
                            @break
                        @case('transfer')
                            <i class="fas fa-paper-plane"></i>
                            @break
                        @case('receive_money')
                            <i class="fas fa-arrow-down"></i>
                            @break
                        @default
                            <i class="fas fa-exchange-alt"></i>
                    @endswitch
                </div>
                <div class="transaction-details">
                    @php
                        $details = null;
                        if ($transaction->details) {
                            if (is_array($transaction->details)) {
                                $details = $transaction->details;
                            } elseif (is_string($transaction->details)) {
                                $decoded = json_decode($transaction->details, true);
                                $details = is_array($decoded) ? $decoded : null;
                            }
                        }
                    @endphp
                    <span class="transaction-title">
                        @if($transaction->type->value === 'transfer' && $details && isset($details['recipient']))
                            Sent to <strong>{{ $details['recipient'] }}</strong>
                        @elseif($transaction->type->value === 'receive_money' && $details && isset($details['sender']))
                            Received from <strong>{{ $details['sender'] }}</strong>
                        @else
                            {{ $transaction->description }}
                        @endif
                    </span>
                    <span class="transaction-date">{{ \Carbon\Carbon::parse($transaction->created_at)->format('M d, Y - h:i A') }}</span>
                    <span class="transaction-id">ID: {{ $transaction->tnx }}</span>
                    @if($details && isset($details['note']) && $details['note'])
                        <span class="transaction-note">
                            <i class="fas fa-sticky-note"></i> {{ $details['note'] }}
                        </span>
                    @endif
                </div>
                <div class="transaction-amount {{ txn_type($transaction->type->value, ['positive', 'negative']) }}">
                    {{ txn_type($transaction->type->value, ['+', '-']) }}${{ number_format($transaction->amount, 2) }}
                </div>
                <div class="transaction-status">
                    <span class="status-badge {{ $transaction->status->value }}">
                        {{ ucfirst($transaction->status->value) }}
                    </span>
                </div>
            </div>
            @empty
            <div class="no-transactions glass-effect">
                <div class="no-transactions-icon">
                    <i class="fas fa-receipt"></i>
                </div>
                <h3>No Transactions Yet</h3>
                <p>Your transaction history will appear here once you start using the platform.</p>
            </div>
            @endforelse
        </div>
        
        @if($transactions->hasPages())
        <div class="pagination-container">
            <div class="pagination">
                {{-- Previous Page Link --}}
                @if ($transactions->onFirstPage())
                    <span class="page-btn disabled">
                        <i class="fas fa-chevron-left"></i>
                    </span>
                @else
                    <a href="{{ $transactions->previousPageUrl() }}" class="page-btn">
                        <i class="fas fa-chevron-left"></i>
                    </a>
                @endif

                {{-- Pagination Elements --}}
                @foreach ($transactions->getUrlRange(1, $transactions->lastPage()) as $page => $url)
                    @if ($page == $transactions->currentPage())
                        <span class="page-btn active">{{ $page }}</span>
                    @else
                        <a href="{{ $url }}" class="page-btn">{{ $page }}</a>
                    @endif
                @endforeach

                {{-- Next Page Link --}}
                @if ($transactions->hasMorePages())
                    <a href="{{ $transactions->nextPageUrl() }}" class="page-btn">
                        <i class="fas fa-chevron-right"></i>
                    </a>
                @else
                    <span class="page-btn disabled">
                        <i class="fas fa-chevron-right"></i>
                    </span>
                @endif
            </div>
        </div>
        @endif
    </div>
</div>

<style>
.page-container {
    padding: 20px;
    max-width: 500px;
    margin: 0 auto;
}

.page-header {
    display: flex;
    align-items: center;
    margin-bottom: 30px;
}

.back-btn {
    background: none;
    border: none;
    color: #fff;
    font-size: 18px;
    margin-right: 15px;
    cursor: pointer;
    padding: 8px;
    border-radius: 8px;
    transition: background 0.3s ease;
}

.back-btn:hover {
    background: rgba(255, 255, 255, 0.1);
}

.page-header h2 {
    color: #fff;
    margin: 0;
    font-weight: 600;
}

.history-container {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.filter-tabs {
    display: flex;
    gap: 10px;
    margin-bottom: 20px;
}

.filter-tab {
    flex: 1;
    padding: 12px 20px;
    border: none;
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    color: #fff;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.filter-tab:hover {
    background: rgba(255, 255, 255, 0.15);
    transform: translateY(-2px);
}

.filter-tab.active {
    background: rgba(0, 212, 255, 0.2);
    border-color: #00d4ff;
    color: #00d4ff;
}

.transaction-history {
    display: flex;
    flex-direction: column;
    gap: 15px;
}

.transaction-item {
    display: flex;
    align-items: center;
    padding: 20px;
    border-radius: 15px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.transaction-item:hover {
    background: rgba(255, 255, 255, 0.15);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
}

.transaction-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 15px;
    font-size: 18px;
    color: #fff;
}

.transaction-icon.deposit,
.transaction-icon.manual_deposit {
    background: linear-gradient(135deg, #00d4ff, #0099cc);
}

.transaction-icon.withdraw {
    background: linear-gradient(135deg, #ff6b6b, #ee5a52);
}

.transaction-icon.investment {
    background: linear-gradient(135deg, #4ecdc4, #44a08d);
}

.transaction-icon.transfer {
    background: linear-gradient(135deg, #ff9a9e, #fecfef);
}

.transaction-icon.receive_money {
    background: linear-gradient(135deg, #a8edea, #fed6e3);
}

.transaction-icon.default {
    background: linear-gradient(135deg, #a8edea, #fed6e3);
}

.transaction-details {
    flex: 1;
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.transaction-title {
    font-weight: 600;
    color: #fff;
    font-size: 16px;
}

.transaction-date {
    color: rgba(255, 255, 255, 0.7);
    font-size: 14px;
}

.transaction-id {
    color: rgba(255, 255, 255, 0.5);
    font-size: 12px;
    font-family: monospace;
}

.transaction-note {
    color: rgba(255, 255, 255, 0.6);
    font-size: 12px;
    font-style: italic;
    display: flex;
    align-items: center;
    gap: 5px;
    margin-top: 2px;
}

.transaction-amount {
    font-weight: 700;
    font-size: 18px;
    margin-right: 15px;
}

.transaction-amount.positive {
    color: #4ecdc4;
}

.transaction-amount.negative {
    color: #ff6b6b;
}

.transaction-status {
    display: flex;
    flex-direction: column;
    align-items: flex-end;
}

.status-badge {
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.status-badge.success {
    background: rgba(78, 205, 196, 0.2);
    color: #4ecdc4;
    border: 1px solid rgba(78, 205, 196, 0.3);
}

.status-badge.pending {
    background: rgba(255, 193, 7, 0.2);
    color: #ffc107;
    border: 1px solid rgba(255, 193, 7, 0.3);
}

.status-badge.failed {
    background: rgba(255, 107, 107, 0.2);
    color: #ff6b6b;
    border: 1px solid rgba(255, 107, 107, 0.3);
}

.no-transactions {
    text-align: center;
    padding: 60px 20px;
    border-radius: 15px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.no-transactions-icon {
    font-size: 48px;
    color: rgba(255, 255, 255, 0.5);
    margin-bottom: 20px;
}

.no-transactions h3 {
    color: #fff;
    margin-bottom: 10px;
    font-weight: 600;
}

.no-transactions p {
    color: rgba(255, 255, 255, 0.7);
    line-height: 1.6;
}

.pagination-container {
    margin-top: 30px;
    display: flex;
    justify-content: center;
}

@media (max-width: 768px) {
    .page-container {
        padding: 15px;
    }
    
    .transaction-item {
        padding: 15px;
    }
    
    .transaction-icon {
        width: 40px;
        height: 40px;
        font-size: 16px;
    }
    
    .transaction-title {
        font-size: 15px;
    }
    
    .transaction-amount {
        font-size: 16px;
    }
    
    .filter-tab {
        padding: 10px 15px;
        font-size: 14px;
    }
}

/* Pagination Styles */
.pagination-container {
    margin-top: 30px;
    display: flex;
    justify-content: center;
}

.pagination {
    display: flex;
    align-items: center;
    gap: 8px;
    background: rgba(0, 0, 0, 0.4);
    padding: 10px 20px;
    border-radius: 15px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.page-btn {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.1);
    color: rgba(255, 255, 255, 0.7);
    text-decoration: none;
    font-weight: 600;
    font-size: 14px;
    transition: all 0.3s ease;
    border: 1px solid rgba(255, 255, 255, 0.1);
}

.page-btn:hover {
    background: rgba(0, 255, 0, 0.2);
    color: #00ff00;
    border-color: rgba(0, 255, 0, 0.3);
    transform: translateY(-2px);
}

.page-btn.active {
    background: linear-gradient(135deg, #00ff00, #00cc00);
    color: #000;
    border-color: #00ff00;
    box-shadow: 0 4px 15px rgba(0, 255, 0, 0.3);
}

.page-btn.disabled {
    background: rgba(255, 255, 255, 0.05);
    color: rgba(255, 255, 255, 0.3);
    cursor: not-allowed;
    border-color: rgba(255, 255, 255, 0.05);
}

.page-btn.disabled:hover {
    background: rgba(255, 255, 255, 0.05);
    color: rgba(255, 255, 255, 0.3);
    transform: none;
    border-color: rgba(255, 255, 255, 0.05);
}

/* Mobile Pagination */
@media (max-width: 768px) {
    .pagination {
        padding: 8px 15px;
        gap: 6px;
    }
    
    .page-btn {
        width: 35px;
        height: 35px;
        font-size: 12px;
    }
}
</style>

</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Filter tabs functionality
    const filterTabs = document.querySelectorAll('.filter-tab');
    const transactionItems = document.querySelectorAll('.transaction-item');
    
    filterTabs.forEach(tab => {
        tab.addEventListener('click', function() {
            // Remove active class from all tabs
            filterTabs.forEach(t => t.classList.remove('active'));
            // Add active class to clicked tab
            this.classList.add('active');
            
            const filter = this.dataset.filter;
            
            // Show/hide transactions based on filter
            transactionItems.forEach(item => {
                if (filter === 'all') {
                    item.style.display = 'flex';
                } else {
                    const itemType = item.dataset.type;
                    if (itemType === filter || 
                        (filter === 'deposit' && (itemType === 'deposit' || itemType === 'manual_deposit')) ||
                        (filter === 'transfer' && (itemType === 'transfer' || itemType === 'receive_money'))) {
                        item.style.display = 'flex';
                    } else {
                        item.style.display = 'none';
                    }
                }
            });
        });
    });
});
</script>
