@extends('frontend.shahdeveloper.layouts.user')

@section('title', 'Withdraw Funds')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Page Header -->
            <div class="page-header">
                <div class="header-content">
                    <h1 class="page-title">
                        <i class="fas fa-money-bill-wave"></i>
                        Withdraw Funds
                    </h1>
                    <p class="page-subtitle">Withdraw your funds using your saved payment methods</p>
                </div>
            </div>

            @if($accounts->count() > 0)
                <!-- Withdraw Form -->
                <div class="withdraw-form">
                    <form action="{{ route('user.withdraw.now') }}" method="POST" id="withdrawForm">
                        @csrf
                        <div class="form-section">
                            <h3>Select Withdrawal Method</h3>
                            <div class="accounts-grid">
                                @foreach($accounts as $account)
                                    <div class="account-card" data-account-id="{{ $account->id }}">
                                        <div class="account-info">
                                            <div class="account-icon">
                                                <i class="fas fa-{{ $account->method->icon ?? 'credit-card' }}"></i>
                                            </div>
                                            <div class="account-details">
                                                <h4>{{ $account->method->name }}</h4>
                                                <p>{{ $account->method_name }}</p>
                                                <small>Min: {{ $account->method->min_withdraw }} | Max: {{ $account->method->max_withdraw }}</small>
                                            </div>
                                        </div>
                                        <div class="account-radio">
                                            <input type="radio" name="withdraw_account" value="{{ $account->id }}" id="account_{{ $account->id }}">
                                            <label for="account_{{ $account->id }}"></label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>

                        <div class="form-section">
                            <h3>Withdrawal Amount</h3>
                            <div class="amount-input">
                                <div class="input-group">
                                    <span class="input-symbol">{{ setting('currency_symbol', 'global') }}</span>
                                    <input type="number" name="amount" class="form-control" placeholder="Enter amount" step="0.01" min="1" required>
                                </div>
                                <small class="amount-help">Enter the amount you want to withdraw</small>
                            </div>
                        </div>

                        <div class="form-actions">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane"></i>
                                Submit Withdrawal Request
                            </button>
                        </div>
                    </form>
                </div>
            @else
                <!-- No Accounts State -->
                <div class="no-accounts">
                    <div class="no-accounts-icon">
                        <i class="fas fa-credit-card"></i>
                    </div>
                    <h3>No Withdrawal Methods</h3>
                    <p>You need to add a withdrawal method before you can withdraw funds.</p>
                    <a href="{{ route('user.withdraw.account.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i>
                        Add Withdrawal Method
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
.page-header {
    margin-bottom: 2rem;
    padding: 1.5rem;
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 136, 0.2);
}

.page-title {
    color: var(--text-primary);
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #00ff88, #00d4aa);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.page-subtitle {
    color: var(--text-secondary);
    margin: 0.5rem 0 0 0;
}

.withdraw-form {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 136, 0.2);
    padding: 2rem;
}

.form-section {
    margin-bottom: 2rem;
}

.form-section h3 {
    color: var(--text-primary);
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 1rem;
}

.accounts-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 1rem;
}

.account-card {
    background: rgba(255, 255, 255, 0.03);
    border: 2px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 1.5rem;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.account-card:hover {
    border-color: rgba(0, 255, 136, 0.3);
    transform: translateY(-2px);
}

.account-card.selected {
    border-color: var(--primary-color);
    background: rgba(0, 255, 136, 0.1);
}

.account-info {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.account-icon {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, #00ff88, #00d4aa);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.account-icon i {
    font-size: 1.5rem;
    color: #001f11;
}

.account-details h4 {
    color: var(--text-primary);
    font-size: 1.1rem;
    font-weight: 600;
    margin: 0 0 0.25rem 0;
}

.account-details p {
    color: var(--text-secondary);
    margin: 0 0 0.25rem 0;
    font-size: 0.9rem;
}

.account-details small {
    color: var(--text-muted);
    font-size: 0.8rem;
}

.account-radio {
    position: relative;
}

.account-radio input[type="radio"] {
    display: none;
}

.account-radio label {
    width: 20px;
    height: 20px;
    border: 2px solid rgba(255, 255, 255, 0.3);
    border-radius: 50%;
    cursor: pointer;
    transition: all 0.3s ease;
}

.account-radio input[type="radio"]:checked + label {
    border-color: var(--primary-color);
    background: var(--primary-color);
}

.account-radio input[type="radio"]:checked + label::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 8px;
    height: 8px;
    background: #001f11;
    border-radius: 50%;
}

.amount-input {
    max-width: 400px;
}

.input-group {
    position: relative;
    display: flex;
    align-items: center;
}

.input-symbol {
    position: absolute;
    left: 15px;
    color: var(--text-primary);
    font-weight: 600;
    z-index: 2;
}

.form-control {
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    color: var(--text-primary);
    padding: 12px 16px 12px 40px;
    border-radius: 10px;
    font-size: 1.1rem;
    font-weight: 600;
}

.form-control:focus {
    background: rgba(255, 255, 255, 0.15);
    border-color: var(--primary-color);
    color: var(--text-primary);
    box-shadow: 0 0 0 0.2rem rgba(0, 255, 136, 0.25);
}

.amount-help {
    color: var(--text-secondary);
    font-size: 0.85rem;
    margin-top: 0.5rem;
    display: block;
}

.form-actions {
    margin-top: 2rem;
    text-align: center;
}

.btn {
    padding: 12px 24px;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    transition: all 0.3s ease;
    border: none;
    font-size: 1rem;
}

.btn-primary {
    background: linear-gradient(135deg, #00ff88, #00d4aa);
    color: #001f11;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 20px rgba(0, 255, 136, 0.3);
    color: #001f11;
}

.no-accounts {
    text-align: center;
    padding: 4rem 2rem;
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 136, 0.2);
}

.no-accounts-icon {
    font-size: 4rem;
    color: var(--text-secondary);
    margin-bottom: 1.5rem;
    opacity: 0.5;
}

.no-accounts h3 {
    color: var(--text-primary);
    margin-bottom: 1rem;
}

.no-accounts p {
    color: var(--text-secondary);
    margin-bottom: 2rem;
}

/* Responsive */
@media (max-width: 768px) {
    .accounts-grid {
        grid-template-columns: 1fr;
    }
    
    .account-card {
        padding: 1rem;
    }
    
    .account-info {
        gap: 0.75rem;
    }
    
    .account-icon {
        width: 40px;
        height: 40px;
    }
    
    .account-icon i {
        font-size: 1.2rem;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Handle account selection
    const accountCards = document.querySelectorAll('.account-card');
    accountCards.forEach(card => {
        card.addEventListener('click', function() {
            // Remove selected class from all cards
            accountCards.forEach(c => c.classList.remove('selected'));
            
            // Add selected class to clicked card
            this.classList.add('selected');
            
            // Check the radio button
            const radio = this.querySelector('input[type="radio"]');
            radio.checked = true;
        });
    });
    
    // Handle form submission
    const form = document.getElementById('withdrawForm');
    form.addEventListener('submit', function(e) {
        const selectedAccount = document.querySelector('input[name="withdraw_account"]:checked');
        if (!selectedAccount) {
            e.preventDefault();
            alert('Please select a withdrawal method');
            return;
        }
        
        const amount = document.querySelector('input[name="amount"]').value;
        if (!amount || amount <= 0) {
            e.preventDefault();
            alert('Please enter a valid amount');
            return;
        }
    });
});
</script>
@endsection
