@extends('frontend::layouts.user')

@section('title')
    {{ __('Create New Ticket') }}
@endsection

@section('content')

<div class="desktop-screen-show">
    <div class="row">
        <div class="col-xl-8">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title">{{ __('Create New Ticket') }}</h3>
                    <a href="{{ route('user.ticket.index') }}" class="site-btn">
                        <i icon-name="arrow-left"></i>{{ __('Back to Tickets') }}
                    </a>
                </div>
                <div class="site-card-body">
                    <form action="{{ route('user.ticket.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-xl-12 col-md-12 col-sm-12">
                                <div class="site-input-groups">
                                    <label for="title" class="box-input-label">{{ __('Subject') }} <span class="text-danger">*</span></label>
                                    <div class="box-input">
                                        <input type="text" 
                                               class="box-input-field" 
                                               id="title" 
                                               name="title" 
                                               placeholder="{{ __('Enter ticket subject') }}"
                                               value="{{ old('title') }}"
                                               required>
                                    </div>
                                    @error('title')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-xl-12 col-md-12 col-sm-12">
                                <div class="site-input-groups">
                                    <label for="message" class="box-input-label">{{ __('Message') }} <span class="text-danger">*</span></label>
                                    <div class="box-input">
                                        <textarea class="box-input-field" 
                                                  id="message" 
                                                  name="message" 
                                                  rows="6" 
                                                  placeholder="{{ __('Describe your issue in detail') }}"
                                                  required>{{ old('message') }}</textarea>
                                    </div>
                                    @error('message')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-xl-12 col-md-12 col-sm-12">
                                <div class="site-input-groups">
                                    <label for="attach" class="box-input-label">{{ __('Attachment') }} ({{ __('Optional') }})</label>
                                    <div class="box-input">
                                        <input type="file" 
                                               class="box-input-field" 
                                               id="attach" 
                                               name="attach" 
                                               accept="image/*,.pdf,.doc,.docx">
                                        <small class="text-muted">{{ __('Supported formats: JPG, PNG, PDF, DOC, DOCX') }}</small>
                                    </div>
                                    @error('attach')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-xl-12 col-md-12 col-sm-12">
                                <div class="site-input-groups">
                                    <button type="submit" class="site-btn">
                                        <i icon-name="send"></i>{{ __('Create Ticket') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-xl-4">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title">{{ __('Support Guidelines') }}</h3>
                </div>
                <div class="site-card-body">
                    <div class="support-guidelines">
                        <div class="guideline-item">
                            <i icon-name="info" class="guideline-icon"></i>
                            <div class="guideline-content">
                                <h6>{{ __('Be Specific') }}</h6>
                                <p>{{ __('Provide detailed information about your issue for faster resolution.') }}</p>
                            </div>
                        </div>
                        
                        <div class="guideline-item">
                            <i icon-name="clock" class="guideline-icon"></i>
                            <div class="guideline-content">
                                <h6>{{ __('Response Time') }}</h6>
                                <p>{{ __('We typically respond within 24 hours during business days.') }}</p>
                            </div>
                        </div>
                        
                        <div class="guideline-item">
                            <i icon-name="file-text" class="guideline-icon"></i>
                            <div class="guideline-content">
                                <h6>{{ __('Attachments') }}</h6>
                                <p>{{ __('Include relevant screenshots or documents to help us understand your issue.') }}</p>
                            </div>
                        </div>
                        
                        <div class="guideline-item">
                            <i icon-name="mail" class="guideline-icon"></i>
                            <div class="guideline-content">
                                <h6>{{ __('Email Notifications') }}</h6>
                                <p>{{ __('You will receive email updates when we respond to your ticket.') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('mobile-screen-show')
<div class="mobile-screen-show">
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title">{{ __('Create New Ticket') }}</h3>
                    <a href="{{ route('user.ticket.index') }}" class="site-btn">
                        <i icon-name="arrow-left"></i>{{ __('Back') }}
                    </a>
                </div>
                <div class="site-card-body">
                    <form action="{{ route('user.ticket.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="site-input-groups">
                            <label for="title" class="box-input-label">{{ __('Subject') }} <span class="text-danger">*</span></label>
                            <div class="box-input">
                                <input type="text" 
                                       class="box-input-field" 
                                       id="title" 
                                       name="title" 
                                       placeholder="{{ __('Enter ticket subject') }}"
                                       value="{{ old('title') }}"
                                       required>
                            </div>
                            @error('title')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="site-input-groups">
                            <label for="message" class="box-input-label">{{ __('Message') }} <span class="text-danger">*</span></label>
                            <div class="box-input">
                                <textarea class="box-input-field" 
                                          id="message" 
                                          name="message" 
                                          rows="6" 
                                          placeholder="{{ __('Describe your issue in detail') }}"
                                          required>{{ old('message') }}</textarea>
                            </div>
                            @error('message')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="site-input-groups">
                            <label for="attach" class="box-input-label">{{ __('Attachment') }} ({{ __('Optional') }})</label>
                            <div class="box-input">
                                <input type="file" 
                                       class="box-input-field" 
                                       id="attach" 
                                       name="attach" 
                                       accept="image/*,.pdf,.doc,.docx">
                                <small class="text-muted">{{ __('Supported formats: JPG, PNG, PDF, DOC, DOCX') }}</small>
                            </div>
                            @error('attach')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="site-input-groups">
                            <button type="submit" class="site-btn w-100">
                                <i icon-name="send"></i>{{ __('Create Ticket') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
.site-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    margin-bottom: 20px;
}

.site-card-header {
    padding: 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.site-card-header .title {
    color: #fff;
    margin: 0;
    font-weight: 600;
}

.site-card-body {
    padding: 20px;
}

.site-btn {
    background: linear-gradient(135deg, #00ff88, #00cc6a);
    border: none;
    padding: 12px 24px;
    border-radius: 8px;
    color: #000;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
}

.site-btn:hover {
    background: linear-gradient(135deg, #00cc6a, #00ff88);
    color: #000;
    text-decoration: none;
    transform: translateY(-2px);
}

.site-input-groups {
    margin-bottom: 20px;
}

.box-input-label {
    color: #fff;
    font-weight: 600;
    margin-bottom: 8px;
    display: block;
}

.box-input-field {
    width: 100%;
    padding: 12px 16px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 8px;
    background: rgba(255, 255, 255, 0.05);
    color: #fff;
    font-size: 14px;
    transition: all 0.3s ease;
}

.box-input-field:focus {
    outline: none;
    border-color: #00ff88;
    background: rgba(255, 255, 255, 0.1);
}

.box-input-field::placeholder {
    color: #ccc;
}

.text-danger {
    color: #ff6b6b !important;
    font-size: 12px;
    margin-top: 5px;
    display: block;
}

.text-muted {
    color: #ccc;
    font-size: 12px;
    margin-top: 5px;
    display: block;
}

.support-guidelines {
    padding: 0;
}

.guideline-item {
    display: flex;
    align-items: flex-start;
    margin-bottom: 20px;
    padding-bottom: 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.guideline-item:last-child {
    margin-bottom: 0;
    padding-bottom: 0;
    border-bottom: none;
}

.guideline-icon {
    width: 20px;
    height: 20px;
    color: #00ff88;
    margin-right: 15px;
    margin-top: 2px;
    flex-shrink: 0;
}

.guideline-content h6 {
    margin-bottom: 5px;
    color: #fff;
    font-weight: 600;
}

.guideline-content p {
    margin: 0;
    color: #ccc;
    font-size: 14px;
    line-height: 1.5;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .site-card-header {
        flex-direction: column;
        gap: 15px;
        text-align: center;
    }
    
    .site-card-header .title {
        font-size: 18px;
    }
    
    .site-btn {
        padding: 10px 20px;
        font-size: 14px;
    }
    
    .w-100 {
        width: 100% !important;
    }
    
    .box-input-field {
        font-size: 16px; /* Prevent zoom on iOS */
    }
    
    .support-guidelines {
        display: none; /* Hide guidelines on mobile */
    }
}
</style>
@endpush