<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Welcome to {{ setting('site_name','Block Wave Trade') }}</title>
	<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
	<style>
		:root {
			--bg: #000000;
			--bg2: #1a1a1a;
			--card: #1a1a1a;
			--stroke: #333333;
			--text: #f8fafc;
			--muted: #94a3b8;
			--brand: #fbbf24;
			--brand2: #f59e0b;
			--lime: #fbbf24;
			--neon: #f59e0b;
		}

		* {
			margin: 0;
			padding: 0;
			box-sizing: border-box;
		}

		html, body {
			height: 100%;
			margin: 0;
			padding: 0;
			background: radial-gradient(1200px 700px at 10% -10%, rgba(251,191,36,.08), transparent 50%), 
						radial-gradient(1200px 700px at 110% 10%, rgba(245,158,11,.05), transparent 50%), 
						linear-gradient(180deg, #000000, #1a1a1a);
			color: var(--text);
			font-family: Inter, system-ui, Segoe UI, Roboto, Helvetica, Arial, sans-serif;
			overflow-x: hidden;
		}

		/* Welcome Container */
		.welcome-container {
			min-height: 100vh;
			display: flex;
			flex-direction: column;
			position: relative;
			overflow: hidden;
		}

		/* Background Effects */
		.bg-effects {
			position: absolute;
			inset: 0;
			overflow: hidden;
			pointer-events: none;
			z-index: 1;
		}

		.bg-glow {
			position: absolute;
			inset: -20%;
			background: radial-gradient(closest-side, rgba(251,191,36,.05), transparent 70%);
			filter: blur(40px);
			animation: float 14s ease-in-out infinite;
		}

		.bg-grid {
			position: absolute;
			left: -10%;
			right: -10%;
			bottom: -5%;
			height: 60%;
			background: linear-gradient(transparent, rgba(251,191,36,.03)), 
						repeating-linear-gradient(0deg, rgba(251,191,36,.06) 0 1px, transparent 1px 40px);
			transform: perspective(800px) rotateX(60deg) translateY(40px);
			mask-image: linear-gradient(to top, black, transparent);
		}

		@keyframes float {
			0%, 100% { transform: translateY(0); }
			50% { transform: translateY(16px); }
		}

		/* Header */
		.welcome-header {
			position: relative;
			z-index: 10;
			padding: 20px;
			text-align: center;
		}

		.logo-container {
			display: flex;
			align-items: center;
			justify-content: center;
			gap: 16px;
			margin-bottom: 20px;
		}

		.logo {
			width: 60px;
			height: 60px;
			border-radius: 16px;
			background: linear-gradient(135deg, #fbbf24, #f59e0b);
			box-shadow: 0 8px 25px rgba(251,191,36,.4), inset 0 0 15px rgba(251,191,36,.2);
			display: flex;
			align-items: center;
			justify-content: center;
			color: #000;
			font-size: 28px;
			animation: logoGlow 3s ease-in-out infinite;
		}

		@keyframes logoGlow {
			0%, 100% { box-shadow: 0 8px 25px rgba(251,191,36,.4), inset 0 0 15px rgba(251,191,36,.2); }
			50% { box-shadow: 0 12px 35px rgba(251,191,36,.6), inset 0 0 20px rgba(251,191,36,.3); }
		}

		.brand-name {
			font-weight: 800;
			font-size: 28px;
			color: white;
			text-transform: uppercase;
			letter-spacing: 2px;
			text-shadow: 0 2px 8px rgba(0,0,0,.5);
		}

		/* Main Content */
		.welcome-content {
			flex: 1;
			display: flex;
			flex-direction: column;
			align-items: center;
			justify-content: center;
			padding: 40px 20px;
			position: relative;
			z-index: 5;
			text-align: center;
		}

		.welcome-title {
			font-size: clamp(32px, 8vw, 64px);
			line-height: 1.1;
			margin: 0 0 20px;
			font-weight: 900;
			text-transform: uppercase;
			letter-spacing: 2px;
			background: linear-gradient(135deg, #ffffff, #fbbf24);
			-webkit-background-clip: text;
			background-clip: text;
			color: transparent;
			text-shadow: 0 4px 20px rgba(251,191,36,.3);
			animation: titleGlow 4s ease-in-out infinite;
		}

		@keyframes titleGlow {
			0%, 100% { text-shadow: 0 4px 20px rgba(251,191,36,.3); }
			50% { text-shadow: 0 6px 30px rgba(251,191,36,.5); }
		}

		.welcome-subtitle {
			font-size: clamp(18px, 4vw, 32px);
			line-height: 1.2;
			margin: 0 0 30px;
			font-weight: 700;
			color: #fbbf24;
			text-transform: uppercase;
			letter-spacing: 1px;
			text-shadow: 0 2px 8px rgba(251,191,36,.4);
		}

		.welcome-description {
			font-size: clamp(16px, 3vw, 20px);
			line-height: 1.6;
			margin: 0 0 40px;
			color: rgba(255,255,255,.8);
			max-width: 600px;
			font-weight: 400;
		}

		/* Action Buttons */
		.welcome-actions {
			display: flex;
			flex-direction: column;
			gap: 20px;
			width: 100%;
			max-width: 400px;
		}

		.btn-primary {
			background: linear-gradient(135deg, #fbbf24, #f59e0b);
			color: #000;
			border: none;
			border-radius: 16px;
			padding: 18px 32px;
			font-weight: 800;
			font-size: 18px;
			text-transform: uppercase;
			letter-spacing: 1px;
			box-shadow: 0 12px 35px rgba(251,191,36,.4);
			position: relative;
			overflow: hidden;
			transition: all 0.3s ease;
			text-decoration: none;
			display: flex;
			align-items: center;
			justify-content: center;
			gap: 12px;
		}

		.btn-primary::before {
			content: '';
			position: absolute;
			top: 0;
			left: -100%;
			width: 100%;
			height: 100%;
			background: linear-gradient(90deg, transparent, rgba(255,255,255,.3), transparent);
			transition: left 0.6s ease;
		}

		.btn-primary:hover::before {
			left: 100%;
		}

		.btn-primary:hover {
			transform: translateY(-3px);
			box-shadow: 0 16px 45px rgba(251,191,36,.5);
		}

		.btn-secondary {
			background: transparent;
			color: #fbbf24;
			border: 2px solid #fbbf24;
			border-radius: 16px;
			padding: 16px 32px;
			font-weight: 700;
			font-size: 16px;
			text-transform: uppercase;
			letter-spacing: 1px;
			transition: all 0.4s ease;
			text-decoration: none;
			display: flex;
			align-items: center;
			justify-content: center;
			gap: 12px;
			position: relative;
			overflow: hidden;
		}

		.btn-secondary::before {
			content: '';
			position: absolute;
			top: 0;
			left: 0;
			width: 0;
			height: 100%;
			background: #fbbf24;
			transition: width 0.4s ease;
			z-index: -1;
		}

		.btn-secondary:hover::before {
			width: 100%;
		}

		.btn-secondary:hover {
			color: #000;
			transform: translateY(-3px);
			box-shadow: 0 12px 35px rgba(251,191,36,.3);
		}

		/* Mobile Responsive */
		@media (max-width: 768px) {
			.welcome-header {
				padding: 15px;
			}

			.logo {
				width: 50px;
				height: 50px;
				font-size: 24px;
			}

			.brand-name {
				font-size: 24px;
			}

			.welcome-content {
				padding: 30px 15px;
			}

			.welcome-actions {
				gap: 16px;
			}

			.btn-primary, .btn-secondary {
				padding: 16px 24px;
				font-size: 16px;
			}
		}

		@media (max-width: 480px) {
			.welcome-header {
				padding: 10px;
			}

			.logo {
				width: 45px;
				height: 45px;
				font-size: 20px;
			}

			.brand-name {
				font-size: 20px;
			}

			.welcome-content {
				padding: 20px 10px;
			}
		}

		/* Loading Animation */
		.loading-overlay {
			position: fixed;
			top: 0;
			left: 0;
			width: 100%;
			height: 100%;
			background: rgba(0,0,0,.9);
			display: flex;
			align-items: center;
			justify-content: center;
			z-index: 9999;
			opacity: 1;
			transition: opacity 0.5s ease;
		}

		.loading-overlay.hidden {
			opacity: 0;
			pointer-events: none;
		}

		.loading-spinner {
			width: 60px;
			height: 60px;
			border: 4px solid rgba(251,191,36,.2);
			border-top: 4px solid #fbbf24;
			border-radius: 50%;
			animation: spin 1s linear infinite;
		}

		@keyframes spin {
			0% { transform: rotate(0deg); }
			100% { transform: rotate(360deg); }
		}

		.loading-text {
			color: #fbbf24;
			font-size: 18px;
			font-weight: 600;
			margin-top: 20px;
			text-align: center;
		}
	</style>
</head>
<body>
	<!-- Loading Overlay -->
	<div class="loading-overlay" id="loadingOverlay">
		<div style="text-align: center;">
			<div class="loading-spinner"></div>
			<div class="loading-text">Loading...</div>
		</div>
	</div>

	<!-- Background Effects -->
	<div class="bg-effects">
		<div class="bg-glow"></div>
		<div class="bg-grid"></div>
	</div>

	<!-- Welcome Container -->
	<div class="welcome-container">
		<!-- Header -->
		<header class="welcome-header">
			<div class="logo-container">
				<div class="logo">
					<i class="fas fa-coins"></i>
				</div>
				<div class="brand-name">{{ setting('site_name','Block Wave Trade') }}</div>
			</div>
		</header>

		<!-- Main Content -->
		<main class="welcome-content">
			<h1 class="welcome-title">Welcome to the Future</h1>
			<h2 class="welcome-subtitle">Block Wave Trade</h2>
			<p class="welcome-description">
				Experience the next generation of investment opportunities. Join thousands of investors who trust us for their financial growth and secure their future with smart investments.
			</p>

			<div class="welcome-actions">
				<a href="{{ route('register') }}" class="btn-primary">
					<i class="fas fa-rocket"></i>
					Get Started Now
				</a>
				<a href="{{ route('login') }}" class="btn-secondary">
					<i class="fas fa-sign-in-alt"></i>
					Login to Dashboard
				</a>
			</div>
		</main>

		<!-- Footer -->
		<footer style="padding: 40px 20px; text-align: center; position: relative; z-index: 5; border-top: 1px solid rgba(251,191,36,.2);">
			<p style="color: rgba(255,255,255,.6); font-size: 14px; margin: 0;">
				&copy; {{ date('Y') }} {{ setting('site_name','Block Wave Trade') }}. All rights reserved.
			</p>
		</footer>
	</div>

	<script>
		// Loading animation
		window.addEventListener('load', function() {
			setTimeout(function() {
				const loadingOverlay = document.getElementById('loadingOverlay');
				loadingOverlay.classList.add('hidden');
			}, 1500);
		});

		// Add click effects to buttons
		document.querySelectorAll('.btn-primary, .btn-secondary').forEach(btn => {
			btn.addEventListener('click', function(e) {
				// Create ripple effect
				const ripple = document.createElement('span');
				const rect = this.getBoundingClientRect();
				const size = Math.max(rect.width, rect.height);
				const x = e.clientX - rect.left - size / 2;
				const y = e.clientY - rect.top - size / 2;
				
				ripple.style.width = ripple.style.height = size + 'px';
				ripple.style.left = x + 'px';
				ripple.style.top = y + 'px';
				ripple.style.position = 'absolute';
				ripple.style.borderRadius = '50%';
				ripple.style.background = 'rgba(255,255,255,0.3)';
				ripple.style.transform = 'scale(0)';
				ripple.style.animation = 'ripple 0.6s linear';
				ripple.style.pointerEvents = 'none';
				
				this.style.position = 'relative';
				this.style.overflow = 'hidden';
				this.appendChild(ripple);
				
				setTimeout(() => {
					ripple.remove();
				}, 600);
			});
		});

		// Add ripple animation
		const style = document.createElement('style');
		style.textContent = `
			@keyframes ripple {
				to {
					transform: scale(4);
					opacity: 0;
				}
			}
		`;
		document.head.appendChild(style);
	</script>
</body>
</html>