<?php

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

$totalDistinct = DB::table('invests')->distinct('user_id')->count('user_id');

$ongoingCompleted = DB::table('invests')
    ->whereIn('status', ['ongoing', 'completed'])
    ->distinct('user_id')
    ->count('user_id');

echo "Users with any plan purchase (any status): {$totalDistinct}\n";
echo "Users with active/completed plans (ongoing or completed): {$ongoingCompleted}\n";


