<?php $__env->startSection('title', 'Withdraw Request Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Withdraw Request #<?php echo e($request->id); ?></h3>
                    <a href="<?php echo e(route('admin.withdraw.requests.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Back to Requests
                    </a>
                </div>
                <div class="card-body">
                    <?php
                        $statusValue = strtolower((string) ($request->status ?? ''));
                        $isApproved = $statusValue === 'approved';
                        $isTerminal = in_array($statusValue, ['approved','rejected','completed'], true);
                    ?>
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="close" data-dismiss="alert">
                                <span>&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="close" data-dismiss="alert">
                                <span>&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <!-- Request Details -->
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Request Details</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <table class="table table-borderless">
                                                <tr>
                                                    <td><strong>Request ID:</strong></td>
                                                    <td>#<?php echo e($request->id); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Amount:</strong></td>
                                                    <td>$<?php echo e(number_format($request->amount, 2)); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Fee:</strong></td>
                                                    <td>$<?php echo e(number_format($request->fee, 2)); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Final Amount:</strong></td>
                                                    <td>$<?php echo e(number_format($request->final_amount, 2)); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Wallet Type:</strong></td>
                                                    <td>
                                                        <span class="badge badge-<?php echo e($request->wallet_type === 'main' ? 'primary' : 'success'); ?>">
                                                            <?php echo e(ucfirst($request->wallet_type)); ?>

                                                        </span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Status:</strong></td>
                                                    <td>
                                                        <span class="badge badge-<?php echo e($request->status_badge); ?>">
                                                            <?php echo e(ucfirst($request->status)); ?>

                                                        </span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Created At:</strong></td>
                                                    <td><?php echo e($request->getRawOriginal('created_at') ? \Carbon\Carbon::parse($request->getRawOriginal('created_at'))->format('M d, Y h:i A') : '-'); ?></td>
                                                </tr>
                                                <?php if($request->processed_at): ?>
                                                <tr>
                                                    <td><strong>Processed At:</strong></td>
                                                    <td><?php echo e($request->getRawOriginal('processed_at') ? \Carbon\Carbon::parse($request->getRawOriginal('processed_at'))->format('M d, Y h:i A') : '-'); ?></td>
                                                </tr>
                                                <?php endif; ?>
                                            </table>
                                        </div>
                                        <div class="col-md-6">
                                            <table class="table table-borderless">
                                                <tr>
                                                    <td><strong>Method:</strong></td>
                                                    <td>
                                                        <span class="badge badge-<?php echo e(optional($request->withdrawMethod)->type === 'crypto' ? 'warning' : (optional($request->withdrawMethod)->type === 'banking' ? 'info' : 'success')); ?>">
                                                            <?php echo e(optional($request->withdrawMethod)->name ?? 'N/A'); ?>

                                                        </span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Method Type:</strong></td>
                                                    <td><?php echo e(optional($request->withdrawMethod)->type ? ucfirst($request->withdrawMethod->type) : 'N/A'); ?></td>
                                                </tr>
                                                <?php if(optional($request->withdrawMethod)->fee_percentage > 0): ?>
                                                <tr>
                                                    <td><strong>Fee Percentage:</strong></td>
                                                    <td><?php echo e($request->withdrawMethod->fee_percentage); ?>%</td>
                                                </tr>
                                                <?php endif; ?>
                                                <?php if(optional($request->withdrawMethod)->fee_fixed > 0): ?>
                                                <tr>
                                                    <td><strong>Fixed Fee:</strong></td>
                                                    <td>$<?php echo e(number_format($request->withdrawMethod->fee_fixed, 2)); ?></td>
                                                </tr>
                                                <?php endif; ?>
                                                <?php if($request->processedBy): ?>
                                                <tr>
                                                    <td><strong>Processed By:</strong></td>
                                                    <td><?php echo e($request->processedBy->name ?? 'Admin'); ?></td>
                                                </tr>
                                                <?php endif; ?>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- User Details -->
                            <div class="card mt-3">
                                <div class="card-header">
                                    <h5 class="card-title">User Details</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <table class="table table-borderless">
                                                <tr>
                                                    <td><strong>Name:</strong></td>
                                                    <td><?php echo e($request->user->first_name); ?> <?php echo e($request->user->last_name); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Username:</strong></td>
                                                    <td><?php echo e($request->user->username); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Email:</strong></td>
                                                    <td><?php echo e($request->user->email); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Phone:</strong></td>
                                                    <td><?php echo e($request->user->phone ?? 'N/A'); ?></td>
                                                </tr>
                                            </table>
                                        </div>
                                        <div class="col-md-6">
                                            <table class="table table-borderless">
                                                <tr>
                                                    <td><strong>Main Balance:</strong></td>
                                                    <td>$<?php echo e(number_format($request->user->balance, 2)); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Profit Balance:</strong></td>
                                                    <td>$<?php echo e(number_format($request->user->profit_balance, 2)); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Country:</strong></td>
                                                    <td><?php echo e($request->user->country ?? 'N/A'); ?></td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Join Date:</strong></td>
                                                    <td><?php echo e(($request->user && $request->user->getRawOriginal('created_at')) ? \Carbon\Carbon::parse($request->user->getRawOriginal('created_at'))->format('M d, Y') : 'N/A'); ?></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Method Details -->
                            <?php if($request->method_details): ?>
                            <div class="card mt-3">
                                <div class="card-header">
                                    <h5 class="card-title">Withdrawal Details</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <?php $__currentLoopData = $request->method_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-6 mb-2">
                                            <strong><?php echo e(ucfirst(str_replace('_', ' ', $key))); ?>:</strong>
                                            <p class="text-muted"><?php echo e($value); ?></p>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                            <!-- Admin Notes -->
                            <?php if($request->admin_note || $request->rejection_reason): ?>
                            <div class="card mt-3">
                                <div class="card-header">
                                    <h5 class="card-title">Admin Notes</h5>
                                </div>
                                <div class="card-body">
                                    <?php if($request->admin_note): ?>
                                    <div class="mb-3">
                                        <strong>Admin Note:</strong>
                                        <p class="text-muted"><?php echo e($request->admin_note); ?></p>
                                    </div>
                                    <?php endif; ?>
                                    <?php if($request->rejection_reason): ?>
                                    <div>
                                        <strong>Rejection Reason:</strong>
                                        <p class="text-danger"><?php echo e($request->rejection_reason); ?></p>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>

                        <!-- Actions -->
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Actions</h5>
                                </div>
                                <div class="card-body">
                                    <?php if(!$isTerminal): ?>
                                    <div class="d-grid gap-2">
                                        <form action="<?php echo e(route('admin.withdraw.requests.approve', $request)); ?>" method="POST" class="mb-2">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="admin_note" value="">
                                            <button type="submit" class="btn btn-success w-100">
                                                <i class="fas fa-check"></i> Approve Request
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('admin.withdraw.requests.reject', $request)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <div class="form-group mb-2">
                                                <input type="text" name="rejection_reason" class="form-control" placeholder="Rejection reason (required)" required>
                                            </div>
                                            <button type="submit" class="btn btn-danger w-100">
                                                <i class="fas fa-times"></i> Reject Request
                                            </button>
                                        </form>
                                    </div>
                                    <?php elseif($isApproved): ?>
                                    <div class="d-grid gap-2">
                                        <form action="<?php echo e(route('admin.withdraw.requests.complete', $request)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-primary" onclick="return confirm('Mark as completed?')">
                                                <i class="fas fa-check-double"></i> Mark as Completed
                                            </button>
                                        </form>
                                    </div>
                                    <?php endif; ?>

                                    <hr>

                                    <div class="d-grid gap-2">
                                        <a href="<?php echo e(route('admin.user.index')); ?>?search=<?php echo e($request->user->username); ?>" class="btn btn-info">
                                            <i class="fas fa-user"></i> View User Profile
                                        </a>
                                        <a href="<?php echo e(route('admin.transactions')); ?>?search=<?php echo e($request->user->username); ?>" class="btn btn-secondary">
                                            <i class="fas fa-history"></i> View User Transactions
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Approve/Reject Modals -->
<?php if(!$isTerminal): ?>
<div class="modal fade" id="approveModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo e(route('admin.withdraw.requests.approve', $request)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Approve Withdraw Request</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to approve this withdraw request?</p>
                    <div class="form-group">
                        <label for="admin_note">Admin Note (Optional)</label>
                        <textarea class="form-control" name="admin_note" rows="3" placeholder="Add a note for the user"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Approve</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo e(route('admin.withdraw.requests.reject', $request)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Reject Withdraw Request</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to reject this withdraw request?</p>
                    <div class="form-group">
                        <label for="rejection_reason">Rejection Reason *</label>
                        <textarea class="form-control <?php $__errorArgs = ['rejection_reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                  name="rejection_reason" rows="3" placeholder="Please provide a reason for rejection" required></textarea>
                        <?php $__errorArgs = ['rejection_reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Reject</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    var approveBtn = document.getElementById('approveBtn');
    var rejectBtn = document.getElementById('rejectBtn');

    if (approveBtn) {
        approveBtn.addEventListener('click', function (e) {
            // If Bootstrap modal JS is unavailable, submit fallback with optional prompt
            var approveModal = document.getElementById('approveModal');
            if (!approveModal || typeof $ === 'undefined' || !($.fn && $.fn.modal)) {
                var note = prompt('Optional admin note (leave blank to skip):', '');
                var form = document.getElementById('approveFallbackForm');
                if (form) {
                    form.querySelector('input[name="admin_note"]').value = note || '';
                    form.submit();
                }
            }
        });
    }

    if (rejectBtn) {
        rejectBtn.addEventListener('click', function (e) {
            var rejectModal = document.getElementById('rejectModal');
            if (!rejectModal || typeof $ === 'undefined' || !($.fn && $.fn.modal)) {
                var reason = '';
                while (!reason) {
                    reason = prompt('Enter rejection reason (required):', '');
                    if (reason === null) return; // cancelled
                }
                var form = document.getElementById('rejectFallbackForm');
                if (form) {
                    form.querySelector('input[name="rejection_reason"]').value = reason;
                    form.submit();
                }
            }
        });
    }
});
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/admin/withdraw/requests/show.blade.php ENDPATH**/ ?>