<!-- InvestFlow Header -->
<header id="main-header" class="main-header">
    <div class="header-content">
        <div class="header-left">
            <button class="menu-btn" onclick="toggleSidebar()">
                <i class="fas fa-bars"></i>
            </button>
            <div class="logo-header">
                <div class="logo-small">
                    <i class="fas fa-chart-line"></i>
                </div>
                
                <span class="header-brand-label">Block Wave Trade</span>
            </div>
        </div>
        <div class="header-right">
            <button class="notification-btn" onclick="toggleNotifications()">
                <i class="fas fa-bell"></i>
                <span class="notification-badge" id="notification-count">3</span>
            </button>
            <div class="user-avatar" onclick="toggleUserMenu()">
                <i class="fas fa-user"></i>
            </div>
        </div>
    </div>
</header>

<!-- InvestFlow Sidebar -->
<div id="sidebar" class="sidebar">
    <div class="sidebar-header">
        <div class="sidebar-logo">
            <div class="logo">
                <i class="fas fa-chart-line"></i>
            </div>
            <div class="sidebar-brand">
                <h3><?php echo e(setting('site_name', 'ShahBlock')); ?></h3>
                <p>Smart Investing</p>
            </div>
        </div>
        <button class="sidebar-close" onclick="toggleSidebar()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    
    <div class="sidebar-content">
        <?php if(auth()->guard('web')->check()): ?>
        <div class="user-info">
            <div class="user-avatar-large">
                <i class="fas fa-user"></i>
            </div>
            <div class="user-details">
                <h4><?php echo e(Auth::user()->first_name); ?> <?php echo e(Auth::user()->last_name); ?></h4>
                <p>Premium Member</p>
            </div>
        </div>
        <?php endif; ?>
        
        <nav class="sidebar-nav">
            <div class="nav-section">
                <span class="nav-title">Main</span>
                <a href="<?php echo e(route('home')); ?>" class="nav-link <?php echo e(request()->routeIs('home') ? 'active' : ''); ?>">
                    <i class="fas fa-home"></i>
                    <span>Home</span>
                </a>
                <?php if(auth()->guard('web')->check()): ?>
                <a href="<?php echo e(route('user.dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('user.dashboard') ? 'active' : ''); ?>">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>Dashboard</span>
                </a>
                <a href="<?php echo e(route('user.schema')); ?>" class="nav-link <?php echo e(request()->routeIs('user.schema*') ? 'active' : ''); ?>">
                    <i class="fas fa-wallet"></i>
                    <span>Investment Plans</span>
                </a>
                <a href="<?php echo e(route('user.invest-logs')); ?>" class="nav-link <?php echo e(request()->routeIs('user.invest-logs*') ? 'active' : ''); ?>">
                    <i class="fas fa-chart-line"></i>
                    <span>My Investments</span>
                </a>
                <a href="<?php echo e(route('user.transactions')); ?>" class="nav-link <?php echo e(request()->routeIs('user.transactions*') ? 'active' : ''); ?>">
                    <i class="fas fa-history"></i>
                    <span>Transactions</span>
                </a>
                <a href="<?php echo e(route('user.referral')); ?>" class="nav-link <?php echo e(request()->routeIs('user.referral*') ? 'active' : ''); ?>">
                    <i class="fas fa-users"></i>
                    <span>Referrals</span>
                </a>
                <a href="<?php echo e(route('user.achievement')); ?>" class="nav-link <?php echo e(request()->routeIs('user.achievement*') ? 'active' : ''); ?>">
                    <i class="fas fa-trophy"></i>
                    <span>Achievements</span>
                </a>
                <a href="<?php echo e(route('user.ranking')); ?>" class="nav-link <?php echo e(request()->routeIs('user.ranking*') ? 'active' : ''); ?>">
                    <i class="fas fa-medal"></i>
                    <span>Ranks & Rewards</span>
                </a>
                <a href="<?php echo e(route('user.collect-roi')); ?>" class="nav-link <?php echo e(request()->routeIs('user.collect-roi*') ? 'active' : ''); ?>">
                    <i class="fas fa-coins"></i>
                    <span>Collect ROI</span>
                </a>
                <a href="<?php echo e(route('user.referral-tree')); ?>" class="nav-link <?php echo e(request()->routeIs('user.referral-tree*') ? 'active' : ''); ?>">
                    <i class="fas fa-sitemap"></i>
                    <span>Referral Tree</span>
                </a>
                <?php endif; ?>
            </div>
            
            <?php if(auth()->guard('web')->check()): ?>
            <div class="nav-section">
                <span class="nav-title">Actions</span>
                <a href="<?php echo e(route('user.deposit')); ?>" class="nav-link <?php echo e(request()->routeIs('user.deposit*') ? 'active' : ''); ?>">
                    <i class="fas fa-plus-circle"></i>
                    <span>Deposit</span>
                </a>
                <a href="<?php echo e(route('user.deposit.log')); ?>" class="nav-link <?php echo e(request()->routeIs('user.deposit.log*') ? 'active' : ''); ?>">
                    <i class="fas fa-list-alt"></i>
                    <span>Deposit Logs</span>
                </a>
                <a href="<?php echo e(route('user.shah.transfer')); ?>" class="nav-link <?php echo e(request()->routeIs('user.shah.transfer*') ? 'active' : ''); ?>">
                    <i class="fas fa-exchange-alt"></i>
                    <span>Transfer & Exchange</span>
                </a>
                <a href="<?php echo e(route('user.withdraw.new.index')); ?>" class="nav-link <?php echo e(request()->routeIs('user.withdraw.new*') ? 'active' : ''); ?>">
                    <i class="fas fa-minus-circle"></i>
                    <span>Withdraw</span>
                </a>
                <a href="<?php echo e(route('user.withdraw.new.history')); ?>" class="nav-link <?php echo e(request()->routeIs('user.withdraw.new.history') ? 'active' : ''); ?>">
                    <i class="fas fa-history"></i>
                    <span>Withdraw History</span>
                </a>
            </div>
            
            <div class="nav-section">
                <span class="nav-title">Account</span>
                <a href="<?php echo e(route('user.setting.show')); ?>" class="nav-link <?php echo e(request()->routeIs('user.setting*') ? 'active' : ''); ?>">
                    <i class="fas fa-user-cog"></i>
                    <span>Profile Settings</span>
                </a>
                <a href="<?php echo e(route('user.setting.show')); ?>" class="nav-link <?php echo e(request()->routeIs('user.setting*') ? 'active' : ''); ?>">
                    <i class="fas fa-shield-alt"></i>
                    <span>Profile</span>
                </a>
                <a href="<?php echo e(route('user.setting.show')); ?>" class="nav-link <?php echo e(request()->routeIs('user.setting*') ? 'active' : ''); ?>">
                    <i class="fas fa-credit-card"></i>
                    <span>Payment Methods</span>
                </a>
            </div>
            <?php endif; ?>
        </nav>
    </div>
</div>

<style>
    .header-left .header-brand-label{
        margin-left:8px;
        font-weight:700;
        color:#e8fff5;
        white-space: nowrap;
        font-size:16px;
    }
    @media (max-width: 480px){
        .header-left .header-brand-label{font-size:13px}
    }
</style>

<!-- Sidebar Overlay -->
<div id="sidebar-overlay" class="sidebar-overlay" onclick="toggleSidebar()"></div>

<!-- Notification Panel -->
<div id="notification-panel" class="notification-panel">
    <div class="notification-header">
        <h3>Notifications</h3>
        <button class="close-btn" onclick="toggleNotifications()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    <div class="notification-list">
        <div class="notification-item">
            <div class="notification-icon">
                <i class="fas fa-info-circle"></i>
            </div>
            <div class="notification-content">
                <h4>Welcome to <?php echo e(setting('site_name', 'ShahBlock')); ?>!</h4>
                <p>Start your investment journey today.</p>
                <span class="notification-time">2 minutes ago</span>
            </div>
        </div>
    </div>
</div>

<!-- User Menu -->
<?php if(auth()->guard('web')->check()): ?>
<div id="user-menu" class="user-menu">
    <div class="user-menu-item" onclick="window.location.href='<?php echo e(route('user.setting.show')); ?>'">
        <i class="fas fa-user"></i>
        <span>Profile</span>
    </div>
    <div class="user-menu-item" onclick="window.location.href='<?php echo e(route('user.setting.show')); ?>'">
        <i class="fas fa-cog"></i>
        <span>Settings</span>
    </div>
    <div class="user-menu-item" onclick="document.getElementById('logout-form').submit();">
        <i class="fas fa-sign-out-alt"></i>
        <span>Logout</span>
    </div>
    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
        <?php echo csrf_field(); ?>
    </form>
</div>
<?php endif; ?>
<?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/frontend/shahdeveloper/include/__shahdeveloper_header.blade.php ENDPATH**/ ?>