<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="settings-page">
                <!-- Header Section -->
                <div class="settings-header">
                    <h2 class="settings-title">
                        <i class="fas fa-cog"></i>
                        Settings
                    </h2>
                    <p class="settings-subtitle">Manage your account settings and preferences</p>
                </div>

                <!-- Profile Completion Status -->
                <div class="profile-completion-card">
                    <div class="completion-header">
                        <h3>
                            <i class="fas fa-user-check"></i>
                            Profile Completion
                        </h3>
                        <div class="completion-percentage">
                            <span class="percentage"><?php echo e($user->profile_completion_percentage); ?>%</span>
                        </div>
                    </div>
                    
                    <div class="completion-progress">
                        <div class="progress-bar">
                            <div class="progress-fill" style="width: <?php echo e($user->profile_completion_percentage); ?>%"></div>
                        </div>
                        <div class="progress-text">
                            <?php if($user->isProfileComplete()): ?>
                                <span class="text-success">
                                    <i class="fas fa-check-circle"></i>
                                    Profile Complete! You can withdraw funds.
                                </span>
                            <?php else: ?>
                                <span class="text-warning">
                                    <i class="fas fa-exclamation-triangle"></i>
                                    Complete your profile to 80% to withdraw funds.
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Settings Tabs -->
                <div class="settings-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="profile">
                            <i class="fas fa-user"></i>
                            Profile
                        </button>
                        <button class="tab-btn" data-tab="security">
                            <i class="fas fa-shield-alt"></i>
                            Security
                        </button>
                        <button class="tab-btn" data-tab="notifications">
                            <i class="fas fa-bell"></i>
                            Notifications
                        </button>
                    </div>

                    <!-- Profile Tab -->
                    <div class="tab-content active" id="profile-tab">
                        <div class="settings-form-container">
                            <form action="<?php echo e(route('user.setting.profile-update')); ?>" method="POST" enctype="multipart/form-data" class="settings-form">
                                <?php echo csrf_field(); ?>
                                
                                <!-- Profile Picture -->
                                <div class="form-group">
                                    <label for="avatar">
                                        <i class="fas fa-camera"></i>
                                        Profile Picture
                                    </label>
                                    <div class="avatar-upload">
                                        <div class="avatar-preview">
                                            <img src="<?php echo e(getUserAvatar($user, 200)); ?>" alt="Profile" id="avatarPreview1" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                            <div class="avatar-placeholder" id="avatarPlaceholder" style="display: none;">
                                                <i class="fas fa-user"></i>
                                            </div>
                                            <div class="avatar-overlay">
                                                <i class="fas fa-camera"></i>
                                                <span>Change Photo</span>
                                            </div>
                                        </div>
                                        <input type="file" id="avatar1" name="avatar" accept=".gif,.jpg,.png,.jpeg" style="display: none;">
                                    </div>
                                </div>

                                <!-- Personal Information -->
                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="first_name">
                                            <i class="fas fa-user"></i>
                                            First Name
                                        </label>
                                        <input type="text" 
                                               id="first_name" 
                                               name="first_name" 
                                               class="form-control"
                                               value="<?php echo e($user->first_name); ?>"
                                               required>
                                    </div>
                                    <div class="form-group">
                                        <label for="last_name">
                                            <i class="fas fa-user"></i>
                                            Last Name
                                        </label>
                                        <input type="text" 
                                               id="last_name" 
                                               name="last_name" 
                                               class="form-control"
                                               value="<?php echo e($user->last_name); ?>"
                                               required>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="username">
                                            <i class="fas fa-at"></i>
                                            Username
                                        </label>
                                        <input type="text" 
                                               id="username" 
                                               name="username" 
                                               class="form-control"
                                               value="<?php echo e($user->username); ?>"
                                               required>
                                    </div>
                                    <div class="form-group">
                                        <label for="email">
                                            <i class="fas fa-envelope"></i>
                                            Email Address
                                        </label>
                                        <input type="email" 
                                               id="email" 
                                               name="email" 
                                               class="form-control"
                                               value="<?php echo e($user->email); ?>"
                                               required>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="phone">
                                            <i class="fas fa-phone"></i>
                                            Phone Number
                                        </label>
                                        <input type="tel" 
                                               id="phone" 
                                               name="phone" 
                                               class="form-control"
                                               value="<?php echo e($user->phone); ?>"
                                               placeholder="+hai "
                                               required>
                                    </div>
                                    <div class="form-group">
                                        <label for="country">
                                            <i class="fas fa-flag"></i>
                                            Country
                                        </label>
                                        <input type="text" 
                                               id="country" 
                                               name="country" 
                                               class="form-control"
                                               value="<?php echo e($user->country); ?>"
                                               placeholder="Counrty"
                                               required>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="city">
                                            <i class="fas fa-city"></i>
                                            City
                                        </label>
                                        <input type="text" 
                                               id="city" 
                                               name="city" 
                                               class="form-control"
                                               value="<?php echo e($user->city); ?>"
                                               placeholder="City">
                                    </div>
                                    <div class="form-group">
                                        <label for="zip_code">
                                            <i class="fas fa-mail-bulk"></i>
                                            Zip Code
                                        </label>
                                        <input type="text" 
                                               id="zip_code" 
                                               name="zip_code" 
                                               class="form-control"
                                               value="<?php echo e($user->zip_code); ?>"
                                               placeholder="ZIP CODE">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="address">
                                        <i class="fas fa-map-marker-alt"></i>
                                        Address
                                    </label>
                                    <textarea id="address" 
                                              name="address" 
                                              class="form-control"
                                              rows="3"
                                              placeholder="Enter your full address"><?php echo e($user->address); ?></textarea>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="gender">
                                            <i class="fas fa-venus-mars"></i>
                                            Gender
                                        </label>
                                        <select id="gender" 
                                                name="gender" 
                                                class="form-control">
                                            <option value="">Select Gender</option>
                                            <option value="male" <?php echo e($user->gender == 'male' ? 'selected' : ''); ?>>Male</option>
                                            <option value="female" <?php echo e($user->gender == 'female' ? 'selected' : ''); ?>>Female</option>
                                            <option value="other" <?php echo e($user->gender == 'other' ? 'selected' : ''); ?>>Other</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="date_of_birth">
                                            <i class="fas fa-calendar"></i>
                                            Date of Birth
                                        </label>
                                        <input type="date" 
                                               id="date_of_birth" 
                                               name="date_of_birth" 
                                               class="form-control"
                                               value="<?php echo e($user->date_of_birth); ?>"
                                               max="<?php echo e(date('Y-m-d', strtotime('-18 years'))); ?>">
                                    </div>
                                </div>

                                <button type="submit" class="btn-save">
                                    <i class="fas fa-save"></i>
                                    Save Changes
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Security Tab -->
                    <div class="tab-content" id="security-tab">
                        <div class="settings-form-container">
                            <form action="<?php echo e(route('user.change.password')); ?>" method="POST" class="settings-form">
                                <?php echo csrf_field(); ?>
                                
                                <div class="form-group">
                                    <label for="current_password">
                                        <i class="fas fa-lock"></i>
                                        Current Password
                                    </label>
                                    <input type="password" 
                                           id="current_password" 
                                           name="current_password" 
                                           class="form-control"
                                           placeholder="Enter current password"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-key"></i>
                                        New Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter new password"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="password_confirmation">
                                        <i class="fas fa-key"></i>
                                        Confirm New Password
                                    </label>
                                    <input type="password" 
                                           id="password_confirmation" 
                                           name="password_confirmation" 
                                           class="form-control"
                                           placeholder="Confirm new password"
                                           required>
                                </div>

                                <button type="submit" class="btn-save">
                                    <i class="fas fa-shield-alt"></i>
                                    Update Password
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Notifications Tab -->
                    <div class="tab-content" id="notifications-tab">
                        <div class="settings-form-container">
                            <div class="notification-settings">
                                <h4>Notification Preferences</h4>
                                <p>Choose how you want to be notified about important updates.</p>
                                
                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>Email Notifications</h5>
                                        <p>Receive notifications via email</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox" checked>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>Investment Updates</h5>
                                        <p>Get notified about your investment status</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox" checked>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>Referral Activity</h5>
                                        <p>Notifications about your referral network</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox">
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>System Updates</h5>
                                        <p>Important system announcements</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox" checked>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
<style>
/* Settings Page Styles */

/* Profile Completion Card */
.profile-completion-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(16px);
    -webkit-backdrop-filter: blur(16px);
    border: 1px solid rgba(0, 255, 136, 0.18);
    border-radius: 16px;
    padding: 25px;
    margin-bottom: 25px;
    box-shadow: 0 10px 30px rgba(0, 255, 136, 0.12);
    position: relative;
    overflow: hidden;
}

.profile-completion-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 2px;
    background: linear-gradient(90deg, #00ff88, #00e0a3);
}

.completion-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.completion-header h3 {
    font-size: 1.3rem;
    font-weight: 700;
    color: #e8fff5;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 10px;
}

.completion-header h3 i {
    color: #00ff88;
}

.completion-percentage {
    background: linear-gradient(135deg, #00ff88, #00e0a3);
    color: #0a0f0d;
    padding: 8px 16px;
    border-radius: 20px;
    font-weight: 700;
    font-size: 1.1rem;
}

.completion-progress {
    display: flex;
    flex-direction: column;
    gap: 15px;
}

.progress-bar {
    width: 100%;
    height: 8px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 4px;
    overflow: hidden;
    position: relative;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #00ff88, #00e0a3);
    border-radius: 4px;
    transition: width 0.3s ease;
    position: relative;
}

.progress-fill::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
    animation: shimmer 2s infinite;
}

@keyframes shimmer {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

.progress-text {
    text-align: center;
}

.progress-text .text-success {
    color: #00ff88;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

.progress-text .text-warning {
    color: #f5a524;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

/* Responsive Design for Profile Completion */
@media (max-width: 768px) {
    .completion-header {
        flex-direction: column;
        gap: 15px;
        text-align: center;
    }
    
    .completion-percentage {
        font-size: 1rem;
        padding: 6px 12px;
    }
    
    .progress-text .text-success,
    .progress-text .text-warning {
        flex-direction: column;
        gap: 5px;
        font-size: 0.9rem;
    }
}
.settings-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.settings-header {
    text-align: center;
    margin-bottom: 30px;
}

.settings-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.settings-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Settings Tabs */
.settings-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.settings-form {
    max-width: 600px;
    margin: 0 auto;
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
    margin-bottom: 25px;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-control textarea {
    resize: vertical;
    min-height: 80px;
}

.form-control select {
    cursor: pointer;
}

.form-control select option {
    background: #000;
    color: #fff;
}

/* Avatar Upload */
.avatar-upload {
    display: flex;
    justify-content: center;
    margin-bottom: 20px;
}

.avatar-preview {
    position: relative;
    width: 120px;
    height: 120px;
    border-radius: 50%;
    overflow: hidden;
    cursor: pointer;
    border: 3px solid rgba(0, 255, 0, 0.3);
    transition: all 0.3s ease;
}

.avatar-preview:hover {
    border-color: #00ff00;
    transform: scale(1.05);
}

.avatar-preview img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.avatar-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.7);
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: all 0.3s ease;
    color: #00ff00;
}

.avatar-preview:hover .avatar-overlay {
    opacity: 1;
}

.avatar-overlay i {
    font-size: 1.5rem;
    margin-bottom: 5px;
}

.avatar-overlay span {
    font-size: 0.8rem;
    font-weight: 600;
}

/* Buttons */
.btn-save {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-save:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-save:active {
    transform: translateY(0);
}

/* Notification Settings */
.notification-settings h4 {
    color: #00ff00;
    margin-bottom: 10px;
    font-size: 1.5rem;
}

.notification-settings p {
    color: rgba(255, 255, 255, 0.7);
    margin-bottom: 30px;
}

.notification-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    margin-bottom: 15px;
    transition: all 0.3s ease;
}

.notification-item:hover {
    border-color: rgba(0, 255, 0, 0.4);
    background: rgba(0, 0, 0, 0.4);
}

.notification-info h5 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.1rem;
}

.notification-info p {
    color: rgba(255, 255, 255, 0.6);
    margin: 0;
    font-size: 0.9rem;
}

/* Toggle Switch */
.switch {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 34px;
}

.switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: rgba(255, 255, 255, 0.2);
    transition: .4s;
    border-radius: 34px;
}

.slider:before {
    position: absolute;
    content: "";
    height: 26px;
    width: 26px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}

input:checked + .slider {
    background-color: #00ff00;
}

input:checked + .slider:before {
    transform: translateX(26px);
}

/* Responsive */
@media (max-width: 768px) {
    .settings-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .settings-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .form-row {
        grid-template-columns: 1fr;
        gap: 0;
    }
    
    .tab-content {
        padding: 20px;
    }
    
    .notification-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 15px;
    }
    
    .notification-toggle {
        align-self: flex-end;
    }
}

@media (max-width: 480px) {
    .settings-title {
        font-size: 1.8rem;
    }
    
    .avatar-preview {
        width: 100px;
        height: 100px;
    }
    
    .tab-content {
        padding: 15px;
    }
}
</style>
<?php $__env->stopPush(); ?>

<style>
/* Avatar Placeholder Styles */
.avatar-placeholder {
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.1), rgba(0, 255, 0, 0.05));
    border: 2px solid rgba(0, 255, 0, 0.3);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: rgba(0, 255, 0, 0.8);
    font-size: 2rem;
    position: absolute;
    top: 0;
    left: 0;
    z-index: 1;
}

.avatar-placeholder i {
    font-size: 2.5rem;
    color: rgba(0, 255, 0, 0.6);
}

/* Ensure click area works properly */
.avatar-upload {
    cursor: pointer;
    position: relative;
}

.avatar-upload * {
    pointer-events: none;
}

.avatar-upload input[type="file"] {
    pointer-events: auto;
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    opacity: 0;
    cursor: pointer;
}
</style>

<?php $__env->startPush('script'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Avatar upload - Simple approach
    const avatarInput = document.getElementById('avatar1');
    const avatarPreview = document.getElementById('avatarPreview1');
    const avatarUpload = document.querySelector('.avatar-upload');

    if (avatarUpload && avatarInput) {
        avatarUpload.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            console.log('Avatar upload clicked');
            avatarInput.click();
        });

        avatarInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            console.log('File selected:', file);
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    console.log('File loaded:', e.target.result);
                    avatarPreview.src = e.target.result;
                    avatarPreview.style.display = 'block';
                    const placeholder = document.getElementById('avatarPlaceholder');
                    if (placeholder) {
                        placeholder.style.display = 'none';
                    }
                };
                reader.readAsDataURL(file);
            }
        });
    }
});
</script>
<?php $__env->stopPush(); ?>

<style>
/* Avatar Placeholder Styles */
.avatar-placeholder {
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.1), rgba(0, 255, 0, 0.05));
    border: 2px solid rgba(0, 255, 0, 0.3);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: rgba(0, 255, 0, 0.8);
    font-size: 2rem;
    position: absolute;
    top: 0;
    left: 0;
    z-index: 1;
}

.avatar-placeholder i {
    font-size: 2.5rem;
    color: rgba(0, 255, 0, 0.6);
}

/* Ensure click area works properly */
.avatar-upload {
    cursor: pointer;
    position: relative;
}

.avatar-upload * {
    pointer-events: none;
}

.avatar-upload input[type="file"] {
    pointer-events: auto;
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    opacity: 0;
    cursor: pointer;
}
</style>















<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="settings-page">
                <!-- Header Section -->
                <div class="settings-header">
                    <h2 class="settings-title">
                        <i class="fas fa-cog"></i>
                        Settings
                    </h2>
                    <p class="settings-subtitle">Manage your account settings and preferences</p>
                </div>

                <!-- Profile Completion Status -->
                <div class="profile-completion-card">
                    <div class="completion-header">
                        <h3>
                            <i class="fas fa-user-check"></i>
                            Profile Completion
                        </h3>
                        <div class="completion-percentage">
                            <span class="percentage"><?php echo e($user->profile_completion_percentage); ?>%</span>
                        </div>
                    </div>
                    
                    <div class="completion-progress">
                        <div class="progress-bar">
                            <div class="progress-fill" style="width: <?php echo e($user->profile_completion_percentage); ?>%"></div>
                        </div>
                        <div class="progress-text">
                            <?php if($user->isProfileComplete()): ?>
                                <span class="text-success">
                                    <i class="fas fa-check-circle"></i>
                                    Profile Complete! You can withdraw funds.
                                </span>
                            <?php else: ?>
                                <span class="text-warning">
                                    <i class="fas fa-exclamation-triangle"></i>
                                    Complete your profile to 80% to withdraw funds.
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Settings Tabs -->
                <div class="settings-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="profile">
                            <i class="fas fa-user"></i>
                            Profile
                        </button>
                        <button class="tab-btn" data-tab="security">
                            <i class="fas fa-shield-alt"></i>
                            Security
                        </button>
                        <button class="tab-btn" data-tab="notifications">
                            <i class="fas fa-bell"></i>
                            Notifications
                        </button>
                    </div>

                    <!-- Profile Tab -->
                    <div class="tab-content active" id="profile-tab">
                        <div class="settings-form-container">
                            <form action="<?php echo e(route('user.setting.profile-update')); ?>" method="POST" enctype="multipart/form-data" class="settings-form">
                                <?php echo csrf_field(); ?>
                                
                                <!-- Profile Picture -->
                                <div class="form-group">
                                    <label for="avatar">
                                        <i class="fas fa-camera"></i>
                                        Profile Picture
                                    </label>
                                    <div class="avatar-upload">
                                        <div class="avatar-preview">
                                            <img src="<?php echo e(getUserAvatar($user, 200)); ?>" alt="Profile" id="avatarPreview1" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                            <div class="avatar-placeholder" id="avatarPlaceholder" style="display: none;">
                                                <i class="fas fa-user"></i>
                                            </div>
                                            <div class="avatar-overlay">
                                                <i class="fas fa-camera"></i>
                                                <span>Change Photo</span>
                                            </div>
                                        </div>
                                        <input type="file" id="avatar1" name="avatar" accept=".gif,.jpg,.png,.jpeg" style="display: none;">
                                    </div>
                                </div>

                                <!-- Personal Information -->
                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="first_name">
                                            <i class="fas fa-user"></i>
                                            First Name
                                        </label>
                                        <input type="text" 
                                               id="first_name" 
                                               name="first_name" 
                                               class="form-control"
                                               value="<?php echo e($user->first_name); ?>"
                                               required>
                                    </div>
                                    <div class="form-group">
                                        <label for="last_name">
                                            <i class="fas fa-user"></i>
                                            Last Name
                                        </label>
                                        <input type="text" 
                                               id="last_name" 
                                               name="last_name" 
                                               class="form-control"
                                               value="<?php echo e($user->last_name); ?>"
                                               required>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="username">
                                            <i class="fas fa-at"></i>
                                            Username
                                        </label>
                                        <input type="text" 
                                               id="username" 
                                               name="username" 
                                               class="form-control"
                                               value="<?php echo e($user->username); ?>"
                                               required>
                                    </div>
                                    <div class="form-group">
                                        <label for="email">
                                            <i class="fas fa-envelope"></i>
                                            Email Address
                                        </label>
                                        <input type="email" 
                                               id="email" 
                                               name="email" 
                                               class="form-control"
                                               value="<?php echo e($user->email); ?>"
                                               required>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="phone">
                                            <i class="fas fa-phone"></i>
                                            Phone Number
                                        </label>
                                        <input type="tel" 
                                               id="phone" 
                                               name="phone" 
                                               class="form-control"
                                               value="<?php echo e($user->phone); ?>"
                                               placeholder="+hai "
                                               required>
                                    </div>
                                    <div class="form-group">
                                        <label for="country">
                                            <i class="fas fa-flag"></i>
                                            Country
                                        </label>
                                        <input type="text" 
                                               id="country" 
                                               name="country" 
                                               class="form-control"
                                               value="<?php echo e($user->country); ?>"
                                               placeholder="Counrty"
                                               required>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="city">
                                            <i class="fas fa-city"></i>
                                            City
                                        </label>
                                        <input type="text" 
                                               id="city" 
                                               name="city" 
                                               class="form-control"
                                               value="<?php echo e($user->city); ?>"
                                               placeholder="City">
                                    </div>
                                    <div class="form-group">
                                        <label for="zip_code">
                                            <i class="fas fa-mail-bulk"></i>
                                            Zip Code
                                        </label>
                                        <input type="text" 
                                               id="zip_code" 
                                               name="zip_code" 
                                               class="form-control"
                                               value="<?php echo e($user->zip_code); ?>"
                                               placeholder="ZIP CODE">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="address">
                                        <i class="fas fa-map-marker-alt"></i>
                                        Address
                                    </label>
                                    <textarea id="address" 
                                              name="address" 
                                              class="form-control"
                                              rows="3"
                                              placeholder="Enter your full address"><?php echo e($user->address); ?></textarea>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="gender">
                                            <i class="fas fa-venus-mars"></i>
                                            Gender
                                        </label>
                                        <select id="gender" 
                                                name="gender" 
                                                class="form-control">
                                            <option value="">Select Gender</option>
                                            <option value="male" <?php echo e($user->gender == 'male' ? 'selected' : ''); ?>>Male</option>
                                            <option value="female" <?php echo e($user->gender == 'female' ? 'selected' : ''); ?>>Female</option>
                                            <option value="other" <?php echo e($user->gender == 'other' ? 'selected' : ''); ?>>Other</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="date_of_birth">
                                            <i class="fas fa-calendar"></i>
                                            Date of Birth
                                        </label>
                                        <input type="date" 
                                               id="date_of_birth" 
                                               name="date_of_birth" 
                                               class="form-control"
                                               value="<?php echo e($user->date_of_birth); ?>"
                                               max="<?php echo e(date('Y-m-d', strtotime('-18 years'))); ?>">
                                    </div>
                                </div>

                                <button type="submit" class="btn-save">
                                    <i class="fas fa-save"></i>
                                    Save Changes
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Security Tab -->
                    <div class="tab-content" id="security-tab">
                        <div class="settings-form-container">
                            <form action="<?php echo e(route('user.change.password')); ?>" method="POST" class="settings-form">
                                <?php echo csrf_field(); ?>
                                
                                <div class="form-group">
                                    <label for="current_password">
                                        <i class="fas fa-lock"></i>
                                        Current Password
                                    </label>
                                    <input type="password" 
                                           id="current_password" 
                                           name="current_password" 
                                           class="form-control"
                                           placeholder="Enter current password"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-key"></i>
                                        New Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter new password"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="password_confirmation">
                                        <i class="fas fa-key"></i>
                                        Confirm New Password
                                    </label>
                                    <input type="password" 
                                           id="password_confirmation" 
                                           name="password_confirmation" 
                                           class="form-control"
                                           placeholder="Confirm new password"
                                           required>
                                </div>

                                <button type="submit" class="btn-save">
                                    <i class="fas fa-shield-alt"></i>
                                    Update Password
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Notifications Tab -->
                    <div class="tab-content" id="notifications-tab">
                        <div class="settings-form-container">
                            <div class="notification-settings">
                                <h4>Notification Preferences</h4>
                                <p>Choose how you want to be notified about important updates.</p>
                                
                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>Email Notifications</h5>
                                        <p>Receive notifications via email</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox" checked>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>Investment Updates</h5>
                                        <p>Get notified about your investment status</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox" checked>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>Referral Activity</h5>
                                        <p>Notifications about your referral network</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox">
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>System Updates</h5>
                                        <p>Important system announcements</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox" checked>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
<style>
/* Settings Page Styles */

/* Profile Completion Card */
.profile-completion-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(16px);
    -webkit-backdrop-filter: blur(16px);
    border: 1px solid rgba(0, 255, 136, 0.18);
    border-radius: 16px;
    padding: 25px;
    margin-bottom: 25px;
    box-shadow: 0 10px 30px rgba(0, 255, 136, 0.12);
    position: relative;
    overflow: hidden;
}

.profile-completion-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 2px;
    background: linear-gradient(90deg, #00ff88, #00e0a3);
}

.completion-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.completion-header h3 {
    font-size: 1.3rem;
    font-weight: 700;
    color: #e8fff5;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 10px;
}

.completion-header h3 i {
    color: #00ff88;
}

.completion-percentage {
    background: linear-gradient(135deg, #00ff88, #00e0a3);
    color: #0a0f0d;
    padding: 8px 16px;
    border-radius: 20px;
    font-weight: 700;
    font-size: 1.1rem;
}

.completion-progress {
    display: flex;
    flex-direction: column;
    gap: 15px;
}

.progress-bar {
    width: 100%;
    height: 8px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 4px;
    overflow: hidden;
    position: relative;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #00ff88, #00e0a3);
    border-radius: 4px;
    transition: width 0.3s ease;
    position: relative;
}

.progress-fill::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
    animation: shimmer 2s infinite;
}

@keyframes shimmer {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

.progress-text {
    text-align: center;
}

.progress-text .text-success {
    color: #00ff88;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

.progress-text .text-warning {
    color: #f5a524;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

/* Responsive Design for Profile Completion */
@media (max-width: 768px) {
    .completion-header {
        flex-direction: column;
        gap: 15px;
        text-align: center;
    }
    
    .completion-percentage {
        font-size: 1rem;
        padding: 6px 12px;
    }
    
    .progress-text .text-success,
    .progress-text .text-warning {
        flex-direction: column;
        gap: 5px;
        font-size: 0.9rem;
    }
}
.settings-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.settings-header {
    text-align: center;
    margin-bottom: 30px;
}

.settings-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.settings-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Settings Tabs */
.settings-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.settings-form {
    max-width: 600px;
    margin: 0 auto;
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
    margin-bottom: 25px;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-control textarea {
    resize: vertical;
    min-height: 80px;
}

.form-control select {
    cursor: pointer;
}

.form-control select option {
    background: #000;
    color: #fff;
}

/* Avatar Upload */
.avatar-upload {
    display: flex;
    justify-content: center;
    margin-bottom: 20px;
}

.avatar-preview {
    position: relative;
    width: 120px;
    height: 120px;
    border-radius: 50%;
    overflow: hidden;
    cursor: pointer;
    border: 3px solid rgba(0, 255, 0, 0.3);
    transition: all 0.3s ease;
}

.avatar-preview:hover {
    border-color: #00ff00;
    transform: scale(1.05);
}

.avatar-preview img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.avatar-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.7);
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: all 0.3s ease;
    color: #00ff00;
}

.avatar-preview:hover .avatar-overlay {
    opacity: 1;
}

.avatar-overlay i {
    font-size: 1.5rem;
    margin-bottom: 5px;
}

.avatar-overlay span {
    font-size: 0.8rem;
    font-weight: 600;
}

/* Buttons */
.btn-save {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-save:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-save:active {
    transform: translateY(0);
}

/* Notification Settings */
.notification-settings h4 {
    color: #00ff00;
    margin-bottom: 10px;
    font-size: 1.5rem;
}

.notification-settings p {
    color: rgba(255, 255, 255, 0.7);
    margin-bottom: 30px;
}

.notification-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    margin-bottom: 15px;
    transition: all 0.3s ease;
}

.notification-item:hover {
    border-color: rgba(0, 255, 0, 0.4);
    background: rgba(0, 0, 0, 0.4);
}

.notification-info h5 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.1rem;
}

.notification-info p {
    color: rgba(255, 255, 255, 0.6);
    margin: 0;
    font-size: 0.9rem;
}

/* Toggle Switch */
.switch {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 34px;
}

.switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: rgba(255, 255, 255, 0.2);
    transition: .4s;
    border-radius: 34px;
}

.slider:before {
    position: absolute;
    content: "";
    height: 26px;
    width: 26px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}

input:checked + .slider {
    background-color: #00ff00;
}

input:checked + .slider:before {
    transform: translateX(26px);
}

/* Responsive */
@media (max-width: 768px) {
    .settings-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .settings-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .form-row {
        grid-template-columns: 1fr;
        gap: 0;
    }
    
    .tab-content {
        padding: 20px;
    }
    
    .notification-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 15px;
    }
    
    .notification-toggle {
        align-self: flex-end;
    }
}

@media (max-width: 480px) {
    .settings-title {
        font-size: 1.8rem;
    }
    
    .avatar-preview {
        width: 100px;
        height: 100px;
    }
    
    .tab-content {
        padding: 15px;
    }
}
</style>
<?php $__env->stopPush(); ?>

<style>
/* Avatar Placeholder Styles */
.avatar-placeholder {
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.1), rgba(0, 255, 0, 0.05));
    border: 2px solid rgba(0, 255, 0, 0.3);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: rgba(0, 255, 0, 0.8);
    font-size: 2rem;
    position: absolute;
    top: 0;
    left: 0;
    z-index: 1;
}

.avatar-placeholder i {
    font-size: 2.5rem;
    color: rgba(0, 255, 0, 0.6);
}

/* Ensure click area works properly */
.avatar-upload {
    cursor: pointer;
    position: relative;
}

.avatar-upload * {
    pointer-events: none;
}

.avatar-upload input[type="file"] {
    pointer-events: auto;
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    opacity: 0;
    cursor: pointer;
}
</style>

<?php $__env->startPush('script'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Avatar upload - Simple approach
    const avatarInput = document.getElementById('avatar1');
    const avatarPreview = document.getElementById('avatarPreview1');
    const avatarUpload = document.querySelector('.avatar-upload');

    if (avatarUpload && avatarInput) {
        avatarUpload.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            console.log('Avatar upload clicked');
            avatarInput.click();
        });

        avatarInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            console.log('File selected:', file);
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    console.log('File loaded:', e.target.result);
                    avatarPreview.src = e.target.result;
                    avatarPreview.style.display = 'block';
                    const placeholder = document.getElementById('avatarPlaceholder');
                    if (placeholder) {
                        placeholder.style.display = 'none';
                    }
                };
                reader.readAsDataURL(file);
            }
        });
    }
});
</script>
<?php $__env->stopPush(); ?>

<style>
/* Avatar Placeholder Styles */
.avatar-placeholder {
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.1), rgba(0, 255, 0, 0.05));
    border: 2px solid rgba(0, 255, 0, 0.3);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: rgba(0, 255, 0, 0.8);
    font-size: 2rem;
    position: absolute;
    top: 0;
    left: 0;
    z-index: 1;
}

.avatar-placeholder i {
    font-size: 2.5rem;
    color: rgba(0, 255, 0, 0.6);
}

/* Ensure click area works properly */
.avatar-upload {
    cursor: pointer;
    position: relative;
}

.avatar-upload * {
    pointer-events: none;
}

.avatar-upload input[type="file"] {
    pointer-events: auto;
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    opacity: 0;
    cursor: pointer;
}
</style>















<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="settings-page">
                <!-- Header Section -->
                <div class="settings-header">
                    <h2 class="settings-title">
                        <i class="fas fa-cog"></i>
                        Settings
                    </h2>
                    <p class="settings-subtitle">Manage your account settings and preferences</p>
                </div>

                <!-- Profile Completion Status -->
                <div class="profile-completion-card">
                    <div class="completion-header">
                        <h3>
                            <i class="fas fa-user-check"></i>
                            Profile Completion
                        </h3>
                        <div class="completion-percentage">
                            <span class="percentage"><?php echo e($user->profile_completion_percentage); ?>%</span>
                        </div>
                    </div>
                    
                    <div class="completion-progress">
                        <div class="progress-bar">
                            <div class="progress-fill" style="width: <?php echo e($user->profile_completion_percentage); ?>%"></div>
                        </div>
                        <div class="progress-text">
                            <?php if($user->isProfileComplete()): ?>
                                <span class="text-success">
                                    <i class="fas fa-check-circle"></i>
                                    Profile Complete! You can withdraw funds.
                                </span>
                            <?php else: ?>
                                <span class="text-warning">
                                    <i class="fas fa-exclamation-triangle"></i>
                                    Complete your profile to 80% to withdraw funds.
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Settings Tabs -->
                <div class="settings-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="profile">
                            <i class="fas fa-user"></i>
                            Profile
                        </button>
                        <button class="tab-btn" data-tab="security">
                            <i class="fas fa-shield-alt"></i>
                            Security
                        </button>
                        <button class="tab-btn" data-tab="notifications">
                            <i class="fas fa-bell"></i>
                            Notifications
                        </button>
                    </div>

                    <!-- Profile Tab -->
                    <div class="tab-content active" id="profile-tab">
                        <div class="settings-form-container">
                            <form action="<?php echo e(route('user.setting.profile-update')); ?>" method="POST" enctype="multipart/form-data" class="settings-form">
                                <?php echo csrf_field(); ?>
                                
                                <!-- Profile Picture -->
                                <div class="form-group">
                                    <label for="avatar">
                                        <i class="fas fa-camera"></i>
                                        Profile Picture
                                    </label>
                                    <div class="avatar-upload">
                                        <div class="avatar-preview">
                                            <img src="<?php echo e(getUserAvatar($user, 200)); ?>" alt="Profile" id="avatarPreview1" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                            <div class="avatar-placeholder" id="avatarPlaceholder" style="display: none;">
                                                <i class="fas fa-user"></i>
                                            </div>
                                            <div class="avatar-overlay">
                                                <i class="fas fa-camera"></i>
                                                <span>Change Photo</span>
                                            </div>
                                        </div>
                                        <input type="file" id="avatar1" name="avatar" accept=".gif,.jpg,.png,.jpeg" style="display: none;">
                                    </div>
                                </div>

                                <!-- Personal Information -->
                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="first_name">
                                            <i class="fas fa-user"></i>
                                            First Name
                                        </label>
                                        <input type="text" 
                                               id="first_name" 
                                               name="first_name" 
                                               class="form-control"
                                               value="<?php echo e($user->first_name); ?>"
                                               required>
                                    </div>
                                    <div class="form-group">
                                        <label for="last_name">
                                            <i class="fas fa-user"></i>
                                            Last Name
                                        </label>
                                        <input type="text" 
                                               id="last_name" 
                                               name="last_name" 
                                               class="form-control"
                                               value="<?php echo e($user->last_name); ?>"
                                               required>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="username">
                                            <i class="fas fa-at"></i>
                                            Username
                                        </label>
                                        <input type="text" 
                                               id="username" 
                                               name="username" 
                                               class="form-control"
                                               value="<?php echo e($user->username); ?>"
                                               required>
                                    </div>
                                    <div class="form-group">
                                        <label for="email">
                                            <i class="fas fa-envelope"></i>
                                            Email Address
                                        </label>
                                        <input type="email" 
                                               id="email" 
                                               name="email" 
                                               class="form-control"
                                               value="<?php echo e($user->email); ?>"
                                               required>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="phone">
                                            <i class="fas fa-phone"></i>
                                            Phone Number
                                        </label>
                                        <input type="tel" 
                                               id="phone" 
                                               name="phone" 
                                               class="form-control"
                                               value="<?php echo e($user->phone); ?>"
                                               placeholder="+hai "
                                               required>
                                    </div>
                                    <div class="form-group">
                                        <label for="country">
                                            <i class="fas fa-flag"></i>
                                            Country
                                        </label>
                                        <input type="text" 
                                               id="country" 
                                               name="country" 
                                               class="form-control"
                                               value="<?php echo e($user->country); ?>"
                                               placeholder="Counrty"
                                               required>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="city">
                                            <i class="fas fa-city"></i>
                                            City
                                        </label>
                                        <input type="text" 
                                               id="city" 
                                               name="city" 
                                               class="form-control"
                                               value="<?php echo e($user->city); ?>"
                                               placeholder="City">
                                    </div>
                                    <div class="form-group">
                                        <label for="zip_code">
                                            <i class="fas fa-mail-bulk"></i>
                                            Zip Code
                                        </label>
                                        <input type="text" 
                                               id="zip_code" 
                                               name="zip_code" 
                                               class="form-control"
                                               value="<?php echo e($user->zip_code); ?>"
                                               placeholder="ZIP CODE">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="address">
                                        <i class="fas fa-map-marker-alt"></i>
                                        Address
                                    </label>
                                    <textarea id="address" 
                                              name="address" 
                                              class="form-control"
                                              rows="3"
                                              placeholder="Enter your full address"><?php echo e($user->address); ?></textarea>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="gender">
                                            <i class="fas fa-venus-mars"></i>
                                            Gender
                                        </label>
                                        <select id="gender" 
                                                name="gender" 
                                                class="form-control">
                                            <option value="">Select Gender</option>
                                            <option value="male" <?php echo e($user->gender == 'male' ? 'selected' : ''); ?>>Male</option>
                                            <option value="female" <?php echo e($user->gender == 'female' ? 'selected' : ''); ?>>Female</option>
                                            <option value="other" <?php echo e($user->gender == 'other' ? 'selected' : ''); ?>>Other</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="date_of_birth">
                                            <i class="fas fa-calendar"></i>
                                            Date of Birth
                                        </label>
                                        <input type="date" 
                                               id="date_of_birth" 
                                               name="date_of_birth" 
                                               class="form-control"
                                               value="<?php echo e($user->date_of_birth); ?>"
                                               max="<?php echo e(date('Y-m-d', strtotime('-18 years'))); ?>">
                                    </div>
                                </div>

                                <button type="submit" class="btn-save">
                                    <i class="fas fa-save"></i>
                                    Save Changes
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Security Tab -->
                    <div class="tab-content" id="security-tab">
                        <div class="settings-form-container">
                            <form action="<?php echo e(route('user.change.password')); ?>" method="POST" class="settings-form">
                                <?php echo csrf_field(); ?>
                                
                                <div class="form-group">
                                    <label for="current_password">
                                        <i class="fas fa-lock"></i>
                                        Current Password
                                    </label>
                                    <input type="password" 
                                           id="current_password" 
                                           name="current_password" 
                                           class="form-control"
                                           placeholder="Enter current password"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-key"></i>
                                        New Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter new password"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="password_confirmation">
                                        <i class="fas fa-key"></i>
                                        Confirm New Password
                                    </label>
                                    <input type="password" 
                                           id="password_confirmation" 
                                           name="password_confirmation" 
                                           class="form-control"
                                           placeholder="Confirm new password"
                                           required>
                                </div>

                                <button type="submit" class="btn-save">
                                    <i class="fas fa-shield-alt"></i>
                                    Update Password
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Notifications Tab -->
                    <div class="tab-content" id="notifications-tab">
                        <div class="settings-form-container">
                            <div class="notification-settings">
                                <h4>Notification Preferences</h4>
                                <p>Choose how you want to be notified about important updates.</p>
                                
                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>Email Notifications</h5>
                                        <p>Receive notifications via email</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox" checked>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>Investment Updates</h5>
                                        <p>Get notified about your investment status</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox" checked>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>Referral Activity</h5>
                                        <p>Notifications about your referral network</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox">
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>System Updates</h5>
                                        <p>Important system announcements</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox" checked>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
<style>
/* Settings Page Styles */

/* Profile Completion Card */
.profile-completion-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(16px);
    -webkit-backdrop-filter: blur(16px);
    border: 1px solid rgba(0, 255, 136, 0.18);
    border-radius: 16px;
    padding: 25px;
    margin-bottom: 25px;
    box-shadow: 0 10px 30px rgba(0, 255, 136, 0.12);
    position: relative;
    overflow: hidden;
}

.profile-completion-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 2px;
    background: linear-gradient(90deg, #00ff88, #00e0a3);
}

.completion-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.completion-header h3 {
    font-size: 1.3rem;
    font-weight: 700;
    color: #e8fff5;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 10px;
}

.completion-header h3 i {
    color: #00ff88;
}

.completion-percentage {
    background: linear-gradient(135deg, #00ff88, #00e0a3);
    color: #0a0f0d;
    padding: 8px 16px;
    border-radius: 20px;
    font-weight: 700;
    font-size: 1.1rem;
}

.completion-progress {
    display: flex;
    flex-direction: column;
    gap: 15px;
}

.progress-bar {
    width: 100%;
    height: 8px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 4px;
    overflow: hidden;
    position: relative;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #00ff88, #00e0a3);
    border-radius: 4px;
    transition: width 0.3s ease;
    position: relative;
}

.progress-fill::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
    animation: shimmer 2s infinite;
}

@keyframes shimmer {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

.progress-text {
    text-align: center;
}

.progress-text .text-success {
    color: #00ff88;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

.progress-text .text-warning {
    color: #f5a524;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

/* Responsive Design for Profile Completion */
@media (max-width: 768px) {
    .completion-header {
        flex-direction: column;
        gap: 15px;
        text-align: center;
    }
    
    .completion-percentage {
        font-size: 1rem;
        padding: 6px 12px;
    }
    
    .progress-text .text-success,
    .progress-text .text-warning {
        flex-direction: column;
        gap: 5px;
        font-size: 0.9rem;
    }
}
.settings-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.settings-header {
    text-align: center;
    margin-bottom: 30px;
}

.settings-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.settings-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Settings Tabs */
.settings-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.settings-form {
    max-width: 600px;
    margin: 0 auto;
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
    margin-bottom: 25px;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-control textarea {
    resize: vertical;
    min-height: 80px;
}

.form-control select {
    cursor: pointer;
}

.form-control select option {
    background: #000;
    color: #fff;
}

/* Avatar Upload */
.avatar-upload {
    display: flex;
    justify-content: center;
    margin-bottom: 20px;
}

.avatar-preview {
    position: relative;
    width: 120px;
    height: 120px;
    border-radius: 50%;
    overflow: hidden;
    cursor: pointer;
    border: 3px solid rgba(0, 255, 0, 0.3);
    transition: all 0.3s ease;
}

.avatar-preview:hover {
    border-color: #00ff00;
    transform: scale(1.05);
}

.avatar-preview img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.avatar-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.7);
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: all 0.3s ease;
    color: #00ff00;
}

.avatar-preview:hover .avatar-overlay {
    opacity: 1;
}

.avatar-overlay i {
    font-size: 1.5rem;
    margin-bottom: 5px;
}

.avatar-overlay span {
    font-size: 0.8rem;
    font-weight: 600;
}

/* Buttons */
.btn-save {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-save:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-save:active {
    transform: translateY(0);
}

/* Notification Settings */
.notification-settings h4 {
    color: #00ff00;
    margin-bottom: 10px;
    font-size: 1.5rem;
}

.notification-settings p {
    color: rgba(255, 255, 255, 0.7);
    margin-bottom: 30px;
}

.notification-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    margin-bottom: 15px;
    transition: all 0.3s ease;
}

.notification-item:hover {
    border-color: rgba(0, 255, 0, 0.4);
    background: rgba(0, 0, 0, 0.4);
}

.notification-info h5 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.1rem;
}

.notification-info p {
    color: rgba(255, 255, 255, 0.6);
    margin: 0;
    font-size: 0.9rem;
}

/* Toggle Switch */
.switch {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 34px;
}

.switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: rgba(255, 255, 255, 0.2);
    transition: .4s;
    border-radius: 34px;
}

.slider:before {
    position: absolute;
    content: "";
    height: 26px;
    width: 26px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}

input:checked + .slider {
    background-color: #00ff00;
}

input:checked + .slider:before {
    transform: translateX(26px);
}

/* Responsive */
@media (max-width: 768px) {
    .settings-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .settings-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .form-row {
        grid-template-columns: 1fr;
        gap: 0;
    }
    
    .tab-content {
        padding: 20px;
    }
    
    .notification-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 15px;
    }
    
    .notification-toggle {
        align-self: flex-end;
    }
}

@media (max-width: 480px) {
    .settings-title {
        font-size: 1.8rem;
    }
    
    .avatar-preview {
        width: 100px;
        height: 100px;
    }
    
    .tab-content {
        padding: 15px;
    }
}
</style>
<?php $__env->stopPush(); ?>

<style>
/* Avatar Placeholder Styles */
.avatar-placeholder {
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.1), rgba(0, 255, 0, 0.05));
    border: 2px solid rgba(0, 255, 0, 0.3);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: rgba(0, 255, 0, 0.8);
    font-size: 2rem;
    position: absolute;
    top: 0;
    left: 0;
    z-index: 1;
}

.avatar-placeholder i {
    font-size: 2.5rem;
    color: rgba(0, 255, 0, 0.6);
}

/* Ensure click area works properly */
.avatar-upload {
    cursor: pointer;
    position: relative;
}

.avatar-upload * {
    pointer-events: none;
}

.avatar-upload input[type="file"] {
    pointer-events: auto;
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    opacity: 0;
    cursor: pointer;
}
</style>

<?php $__env->startPush('script'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Avatar upload - Simple approach
    const avatarInput = document.getElementById('avatar1');
    const avatarPreview = document.getElementById('avatarPreview1');
    const avatarUpload = document.querySelector('.avatar-upload');

    if (avatarUpload && avatarInput) {
        avatarUpload.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            console.log('Avatar upload clicked');
            avatarInput.click();
        });

        avatarInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            console.log('File selected:', file);
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    console.log('File loaded:', e.target.result);
                    avatarPreview.src = e.target.result;
                    avatarPreview.style.display = 'block';
                    const placeholder = document.getElementById('avatarPlaceholder');
                    if (placeholder) {
                        placeholder.style.display = 'none';
                    }
                };
                reader.readAsDataURL(file);
            }
        });
    }
});
</script>
<?php $__env->stopPush(); ?>

<style>
/* Avatar Placeholder Styles */
.avatar-placeholder {
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.1), rgba(0, 255, 0, 0.05));
    border: 2px solid rgba(0, 255, 0, 0.3);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: rgba(0, 255, 0, 0.8);
    font-size: 2rem;
    position: absolute;
    top: 0;
    left: 0;
    z-index: 1;
}

.avatar-placeholder i {
    font-size: 2.5rem;
    color: rgba(0, 255, 0, 0.6);
}

/* Ensure click area works properly */
.avatar-upload {
    cursor: pointer;
    position: relative;
}

.avatar-upload * {
    pointer-events: none;
}

.avatar-upload input[type="file"] {
    pointer-events: auto;
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    opacity: 0;
    cursor: pointer;
}
</style>















<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="settings-page">
                <!-- Header Section -->
                <div class="settings-header">
                    <h2 class="settings-title">
                        <i class="fas fa-cog"></i>
                        Settings
                    </h2>
                    <p class="settings-subtitle">Manage your account settings and preferences</p>
                </div>

                <!-- Profile Completion Status -->
                <div class="profile-completion-card">
                    <div class="completion-header">
                        <h3>
                            <i class="fas fa-user-check"></i>
                            Profile Completion
                        </h3>
                        <div class="completion-percentage">
                            <span class="percentage"><?php echo e($user->profile_completion_percentage); ?>%</span>
                        </div>
                    </div>
                    
                    <div class="completion-progress">
                        <div class="progress-bar">
                            <div class="progress-fill" style="width: <?php echo e($user->profile_completion_percentage); ?>%"></div>
                        </div>
                        <div class="progress-text">
                            <?php if($user->isProfileComplete()): ?>
                                <span class="text-success">
                                    <i class="fas fa-check-circle"></i>
                                    Profile Complete! You can withdraw funds.
                                </span>
                            <?php else: ?>
                                <span class="text-warning">
                                    <i class="fas fa-exclamation-triangle"></i>
                                    Complete your profile to 80% to withdraw funds.
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Settings Tabs -->
                <div class="settings-tabs">
                    <div class="tab-buttons">
                        <button class="tab-btn active" data-tab="profile">
                            <i class="fas fa-user"></i>
                            Profile
                        </button>
                        <button class="tab-btn" data-tab="security">
                            <i class="fas fa-shield-alt"></i>
                            Security
                        </button>
                        <button class="tab-btn" data-tab="notifications">
                            <i class="fas fa-bell"></i>
                            Notifications
                        </button>
                    </div>

                    <!-- Profile Tab -->
                    <div class="tab-content active" id="profile-tab">
                        <div class="settings-form-container">
                            <form action="<?php echo e(route('user.setting.profile-update')); ?>" method="POST" enctype="multipart/form-data" class="settings-form">
                                <?php echo csrf_field(); ?>
                                
                                <!-- Profile Picture -->
                                <div class="form-group">
                                    <label for="avatar">
                                        <i class="fas fa-camera"></i>
                                        Profile Picture
                                    </label>
                                    <div class="avatar-upload">
                                        <div class="avatar-preview">
                                            <img src="<?php echo e(getUserAvatar($user, 200)); ?>" alt="Profile" id="avatarPreview1" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                            <div class="avatar-placeholder" id="avatarPlaceholder" style="display: none;">
                                                <i class="fas fa-user"></i>
                                            </div>
                                            <div class="avatar-overlay">
                                                <i class="fas fa-camera"></i>
                                                <span>Change Photo</span>
                                            </div>
                                        </div>
                                        <input type="file" id="avatar1" name="avatar" accept=".gif,.jpg,.png,.jpeg" style="display: none;">
                                    </div>
                                </div>

                                <!-- Personal Information -->
                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="first_name">
                                            <i class="fas fa-user"></i>
                                            First Name
                                        </label>
                                        <input type="text" 
                                               id="first_name" 
                                               name="first_name" 
                                               class="form-control"
                                               value="<?php echo e($user->first_name); ?>"
                                               required>
                                    </div>
                                    <div class="form-group">
                                        <label for="last_name">
                                            <i class="fas fa-user"></i>
                                            Last Name
                                        </label>
                                        <input type="text" 
                                               id="last_name" 
                                               name="last_name" 
                                               class="form-control"
                                               value="<?php echo e($user->last_name); ?>"
                                               required>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="username">
                                            <i class="fas fa-at"></i>
                                            Username
                                        </label>
                                        <input type="text" 
                                               id="username" 
                                               name="username" 
                                               class="form-control"
                                               value="<?php echo e($user->username); ?>"
                                               required>
                                    </div>
                                    <div class="form-group">
                                        <label for="email">
                                            <i class="fas fa-envelope"></i>
                                            Email Address
                                        </label>
                                        <input type="email" 
                                               id="email" 
                                               name="email" 
                                               class="form-control"
                                               value="<?php echo e($user->email); ?>"
                                               required>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="phone">
                                            <i class="fas fa-phone"></i>
                                            Phone Number
                                        </label>
                                        <input type="tel" 
                                               id="phone" 
                                               name="phone" 
                                               class="form-control"
                                               value="<?php echo e($user->phone); ?>"
                                               placeholder="+hai "
                                               required>
                                    </div>
                                    <div class="form-group">
                                        <label for="country">
                                            <i class="fas fa-flag"></i>
                                            Country
                                        </label>
                                        <input type="text" 
                                               id="country" 
                                               name="country" 
                                               class="form-control"
                                               value="<?php echo e($user->country); ?>"
                                               placeholder="Counrty"
                                               required>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="city">
                                            <i class="fas fa-city"></i>
                                            City
                                        </label>
                                        <input type="text" 
                                               id="city" 
                                               name="city" 
                                               class="form-control"
                                               value="<?php echo e($user->city); ?>"
                                               placeholder="City">
                                    </div>
                                    <div class="form-group">
                                        <label for="zip_code">
                                            <i class="fas fa-mail-bulk"></i>
                                            Zip Code
                                        </label>
                                        <input type="text" 
                                               id="zip_code" 
                                               name="zip_code" 
                                               class="form-control"
                                               value="<?php echo e($user->zip_code); ?>"
                                               placeholder="ZIP CODE">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="address">
                                        <i class="fas fa-map-marker-alt"></i>
                                        Address
                                    </label>
                                    <textarea id="address" 
                                              name="address" 
                                              class="form-control"
                                              rows="3"
                                              placeholder="Enter your full address"><?php echo e($user->address); ?></textarea>
                                </div>

                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="gender">
                                            <i class="fas fa-venus-mars"></i>
                                            Gender
                                        </label>
                                        <select id="gender" 
                                                name="gender" 
                                                class="form-control">
                                            <option value="">Select Gender</option>
                                            <option value="male" <?php echo e($user->gender == 'male' ? 'selected' : ''); ?>>Male</option>
                                            <option value="female" <?php echo e($user->gender == 'female' ? 'selected' : ''); ?>>Female</option>
                                            <option value="other" <?php echo e($user->gender == 'other' ? 'selected' : ''); ?>>Other</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="date_of_birth">
                                            <i class="fas fa-calendar"></i>
                                            Date of Birth
                                        </label>
                                        <input type="date" 
                                               id="date_of_birth" 
                                               name="date_of_birth" 
                                               class="form-control"
                                               value="<?php echo e($user->date_of_birth); ?>"
                                               max="<?php echo e(date('Y-m-d', strtotime('-18 years'))); ?>">
                                    </div>
                                </div>

                                <button type="submit" class="btn-save">
                                    <i class="fas fa-save"></i>
                                    Save Changes
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Security Tab -->
                    <div class="tab-content" id="security-tab">
                        <div class="settings-form-container">
                            <form action="<?php echo e(route('user.change.password')); ?>" method="POST" class="settings-form">
                                <?php echo csrf_field(); ?>
                                
                                <div class="form-group">
                                    <label for="current_password">
                                        <i class="fas fa-lock"></i>
                                        Current Password
                                    </label>
                                    <input type="password" 
                                           id="current_password" 
                                           name="current_password" 
                                           class="form-control"
                                           placeholder="Enter current password"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="password">
                                        <i class="fas fa-key"></i>
                                        New Password
                                    </label>
                                    <input type="password" 
                                           id="password" 
                                           name="password" 
                                           class="form-control"
                                           placeholder="Enter new password"
                                           required>
                                </div>

                                <div class="form-group">
                                    <label for="password_confirmation">
                                        <i class="fas fa-key"></i>
                                        Confirm New Password
                                    </label>
                                    <input type="password" 
                                           id="password_confirmation" 
                                           name="password_confirmation" 
                                           class="form-control"
                                           placeholder="Confirm new password"
                                           required>
                                </div>

                                <button type="submit" class="btn-save">
                                    <i class="fas fa-shield-alt"></i>
                                    Update Password
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Notifications Tab -->
                    <div class="tab-content" id="notifications-tab">
                        <div class="settings-form-container">
                            <div class="notification-settings">
                                <h4>Notification Preferences</h4>
                                <p>Choose how you want to be notified about important updates.</p>
                                
                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>Email Notifications</h5>
                                        <p>Receive notifications via email</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox" checked>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>Investment Updates</h5>
                                        <p>Get notified about your investment status</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox" checked>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>Referral Activity</h5>
                                        <p>Notifications about your referral network</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox">
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="notification-item">
                                    <div class="notification-info">
                                        <h5>System Updates</h5>
                                        <p>Important system announcements</p>
                                    </div>
                                    <div class="notification-toggle">
                                        <label class="switch">
                                            <input type="checkbox" checked>
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
<style>
/* Settings Page Styles */

/* Profile Completion Card */
.profile-completion-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(16px);
    -webkit-backdrop-filter: blur(16px);
    border: 1px solid rgba(0, 255, 136, 0.18);
    border-radius: 16px;
    padding: 25px;
    margin-bottom: 25px;
    box-shadow: 0 10px 30px rgba(0, 255, 136, 0.12);
    position: relative;
    overflow: hidden;
}

.profile-completion-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 2px;
    background: linear-gradient(90deg, #00ff88, #00e0a3);
}

.completion-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.completion-header h3 {
    font-size: 1.3rem;
    font-weight: 700;
    color: #e8fff5;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 10px;
}

.completion-header h3 i {
    color: #00ff88;
}

.completion-percentage {
    background: linear-gradient(135deg, #00ff88, #00e0a3);
    color: #0a0f0d;
    padding: 8px 16px;
    border-radius: 20px;
    font-weight: 700;
    font-size: 1.1rem;
}

.completion-progress {
    display: flex;
    flex-direction: column;
    gap: 15px;
}

.progress-bar {
    width: 100%;
    height: 8px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 4px;
    overflow: hidden;
    position: relative;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #00ff88, #00e0a3);
    border-radius: 4px;
    transition: width 0.3s ease;
    position: relative;
}

.progress-fill::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
    animation: shimmer 2s infinite;
}

@keyframes shimmer {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

.progress-text {
    text-align: center;
}

.progress-text .text-success {
    color: #00ff88;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

.progress-text .text-warning {
    color: #f5a524;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

/* Responsive Design for Profile Completion */
@media (max-width: 768px) {
    .completion-header {
        flex-direction: column;
        gap: 15px;
        text-align: center;
    }
    
    .completion-percentage {
        font-size: 1rem;
        padding: 6px 12px;
    }
    
    .progress-text .text-success,
    .progress-text .text-warning {
        flex-direction: column;
        gap: 5px;
        font-size: 0.9rem;
    }
}
.settings-page {
    padding: 20px;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8), rgba(0, 50, 0, 0.3));
    border-radius: 20px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(0, 255, 0, 0.2);
    margin: 20px 0;
}

.settings-header {
    text-align: center;
    margin-bottom: 30px;
}

.settings-title {
    color: #00ff00;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 10px;
    text-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
}

.settings-subtitle {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    margin: 0;
}

/* Settings Tabs */
.settings-tabs {
    background: rgba(0, 0, 0, 0.4);
    border-radius: 15px;
    overflow: hidden;
    border: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-buttons {
    display: flex;
    background: rgba(0, 0, 0, 0.6);
    border-bottom: 1px solid rgba(0, 255, 0, 0.2);
}

.tab-btn {
    flex: 1;
    padding: 15px 20px;
    background: transparent;
    border: none;
    color: rgba(255, 255, 255, 0.7);
    font-size: 1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    border-right: 1px solid rgba(0, 255, 0, 0.1);
}

.tab-btn:last-child {
    border-right: none;
}

.tab-btn:hover {
    background: rgba(0, 255, 0, 0.1);
    color: #00ff00;
}

.tab-btn.active {
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.2), rgba(0, 255, 0, 0.1));
    color: #00ff00;
    border-bottom: 2px solid #00ff00;
}

.tab-btn i {
    margin-right: 8px;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 30px;
}

.tab-content.active {
    display: block;
}

/* Forms */
.settings-form {
    max-width: 600px;
    margin: 0 auto;
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
    margin-bottom: 25px;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    color: #00ff00;
    font-weight: 600;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group label i {
    margin-right: 8px;
    width: 16px;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    background: rgba(0, 0, 0, 0.6);
    border: 1px solid rgba(0, 255, 0, 0.3);
    border-radius: 10px;
    color: #fff;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #00ff00;
    box-shadow: 0 0 15px rgba(0, 255, 0, 0.3);
    background: rgba(0, 0, 0, 0.8);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

.form-control textarea {
    resize: vertical;
    min-height: 80px;
}

.form-control select {
    cursor: pointer;
}

.form-control select option {
    background: #000;
    color: #fff;
}

/* Avatar Upload */
.avatar-upload {
    display: flex;
    justify-content: center;
    margin-bottom: 20px;
}

.avatar-preview {
    position: relative;
    width: 120px;
    height: 120px;
    border-radius: 50%;
    overflow: hidden;
    cursor: pointer;
    border: 3px solid rgba(0, 255, 0, 0.3);
    transition: all 0.3s ease;
}

.avatar-preview:hover {
    border-color: #00ff00;
    transform: scale(1.05);
}

.avatar-preview img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.avatar-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.7);
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: all 0.3s ease;
    color: #00ff00;
}

.avatar-preview:hover .avatar-overlay {
    opacity: 1;
}

.avatar-overlay i {
    font-size: 1.5rem;
    margin-bottom: 5px;
}

.avatar-overlay span {
    font-size: 0.8rem;
    font-weight: 600;
}

/* Buttons */
.btn-save {
    width: 100%;
    padding: 15px 30px;
    background: linear-gradient(135deg, #00ff00, #00cc00);
    border: none;
    border-radius: 10px;
    color: #000;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.btn-save:hover {
    background: linear-gradient(135deg, #00cc00, #009900);
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 255, 0, 0.3);
}

.btn-save:active {
    transform: translateY(0);
}

/* Notification Settings */
.notification-settings h4 {
    color: #00ff00;
    margin-bottom: 10px;
    font-size: 1.5rem;
}

.notification-settings p {
    color: rgba(255, 255, 255, 0.7);
    margin-bottom: 30px;
}

.notification-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px;
    background: rgba(0, 0, 0, 0.3);
    border: 1px solid rgba(0, 255, 0, 0.2);
    border-radius: 10px;
    margin-bottom: 15px;
    transition: all 0.3s ease;
}

.notification-item:hover {
    border-color: rgba(0, 255, 0, 0.4);
    background: rgba(0, 0, 0, 0.4);
}

.notification-info h5 {
    color: #fff;
    margin: 0 0 5px 0;
    font-size: 1.1rem;
}

.notification-info p {
    color: rgba(255, 255, 255, 0.6);
    margin: 0;
    font-size: 0.9rem;
}

/* Toggle Switch */
.switch {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 34px;
}

.switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: rgba(255, 255, 255, 0.2);
    transition: .4s;
    border-radius: 34px;
}

.slider:before {
    position: absolute;
    content: "";
    height: 26px;
    width: 26px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}

input:checked + .slider {
    background-color: #00ff00;
}

input:checked + .slider:before {
    transform: translateX(26px);
}

/* Responsive */
@media (max-width: 768px) {
    .settings-page {
        padding: 15px;
        margin: 10px 0;
    }
    
    .settings-title {
        font-size: 2rem;
    }
    
    .tab-buttons {
        flex-direction: column;
    }
    
    .tab-btn {
        border-right: none;
        border-bottom: 1px solid rgba(0, 255, 0, 0.1);
    }
    
    .tab-btn:last-child {
        border-bottom: none;
    }
    
    .form-row {
        grid-template-columns: 1fr;
        gap: 0;
    }
    
    .tab-content {
        padding: 20px;
    }
    
    .notification-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 15px;
    }
    
    .notification-toggle {
        align-self: flex-end;
    }
}

@media (max-width: 480px) {
    .settings-title {
        font-size: 1.8rem;
    }
    
    .avatar-preview {
        width: 100px;
        height: 100px;
    }
    
    .tab-content {
        padding: 15px;
    }
}
</style>
<?php $__env->stopPush(); ?>

<style>
/* Avatar Placeholder Styles */
.avatar-placeholder {
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.1), rgba(0, 255, 0, 0.05));
    border: 2px solid rgba(0, 255, 0, 0.3);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: rgba(0, 255, 0, 0.8);
    font-size: 2rem;
    position: absolute;
    top: 0;
    left: 0;
    z-index: 1;
}

.avatar-placeholder i {
    font-size: 2.5rem;
    color: rgba(0, 255, 0, 0.6);
}

/* Ensure click area works properly */
.avatar-upload {
    cursor: pointer;
    position: relative;
}

.avatar-upload * {
    pointer-events: none;
}

.avatar-upload input[type="file"] {
    pointer-events: auto;
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    opacity: 0;
    cursor: pointer;
}
</style>

<?php $__env->startPush('script'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const tabId = button.getAttribute('data-tab');
            
            // Remove active class from all buttons and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked button and corresponding content
            button.classList.add('active');
            document.getElementById(tabId + '-tab').classList.add('active');
        });
    });

    // Avatar upload - Simple approach
    const avatarInput = document.getElementById('avatar1');
    const avatarPreview = document.getElementById('avatarPreview1');
    const avatarUpload = document.querySelector('.avatar-upload');

    if (avatarUpload && avatarInput) {
        avatarUpload.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            console.log('Avatar upload clicked');
            avatarInput.click();
        });

        avatarInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            console.log('File selected:', file);
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    console.log('File loaded:', e.target.result);
                    avatarPreview.src = e.target.result;
                    avatarPreview.style.display = 'block';
                    const placeholder = document.getElementById('avatarPlaceholder');
                    if (placeholder) {
                        placeholder.style.display = 'none';
                    }
                };
                reader.readAsDataURL(file);
            }
        });
    }
});
</script>
<?php $__env->stopPush(); ?>

<style>
/* Avatar Placeholder Styles */
.avatar-placeholder {
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, rgba(0, 255, 0, 0.1), rgba(0, 255, 0, 0.05));
    border: 2px solid rgba(0, 255, 0, 0.3);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: rgba(0, 255, 0, 0.8);
    font-size: 2rem;
    position: absolute;
    top: 0;
    left: 0;
    z-index: 1;
}

.avatar-placeholder i {
    font-size: 2.5rem;
    color: rgba(0, 255, 0, 0.6);
}

/* Ensure click area works properly */
.avatar-upload {
    cursor: pointer;
    position: relative;
}

.avatar-upload * {
    pointer-events: none;
}

.avatar-upload input[type="file"] {
    pointer-events: auto;
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    opacity: 0;
    cursor: pointer;
}
</style>















<?php echo $__env->make('frontend.shahdeveloper.layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/app/Providers/../../resources/views/frontend/shahdeveloper/user/setting/index.blade.php ENDPATH**/ ?>