<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <title><?php echo e(__('Admin Login')); ?> - <?php echo e(setting('site_title', 'global')); ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset(setting('site_favicon', 'global'))); ?>">
    
    <!-- CSS -->
    <link href="<?php echo e(asset('backend/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/responsive.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/color.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/icofont.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/line-awesome.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/remixicon.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/flag-icon.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/owl.carousel.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/owl.theme.default.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/jquery.fancybox.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/select2.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/treeview.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/custom.css')); ?>" rel="stylesheet">
</head>

<body class="admin-login">
    <div class="admin-login-wrapper">
        <div class="admin-login-container">
            <div class="admin-login-box">
                <div class="admin-login-header">
                    <div class="admin-login-logo">
                        <img src="<?php echo e(asset(setting('site_logo', 'global'))); ?>" alt="Logo">
                    </div>
                    <h2><?php echo e(__('Admin Login')); ?></h2>
                    <p><?php echo e(__('Sign in to your admin account')); ?></p>
                </div>
                
                <div class="admin-login-form">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    
                    <form method="POST" action="<?php echo e(route('admin.login')); ?>">
                        <?php echo csrf_field(); ?>
                        
                        <div class="form-group">
                            <label for="email"><?php echo e(__('Email Address')); ?></label>
                            <input type="email" 
                                   class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="email" 
                                   name="email" 
                                   value="<?php echo e(old('email')); ?>" 
                                   required 
                                   autocomplete="email" 
                                   autofocus>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="form-group">
                            <label for="password"><?php echo e(__('Password')); ?></label>
                            <input type="password" 
                                   class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="password" 
                                   name="password" 
                                   required 
                                   autocomplete="current-password">
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="form-group">
                            <div class="form-check">
                                <input class="form-check-input" 
                                       type="checkbox" 
                                       name="remember" 
                                       id="remember" 
                                       <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="remember">
                                    <?php echo e(__('Remember Me')); ?>

                                </label>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary btn-block">
                                <?php echo e(__('Login')); ?>

                            </button>
                        </div>
                    </form>
                </div>
                
                <div class="admin-login-footer">
                    <p>&copy; <?php echo e(date('Y')); ?> <?php echo e(setting('site_title', 'global')); ?>. <?php echo e(__('All rights reserved.')); ?></p>
                </div>
            </div>
        </div>
    </div>
    
    <!-- JavaScript -->
    <script src="<?php echo e(asset('backend/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/script.js')); ?>"></script>
</body>
</html><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/backend/auth/login.blade.php ENDPATH**/ ?>