

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Forgot Password')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- ShahDeveloper Theme Preloader -->
<div id="page-loading-overlay">
    <div class="loading-content">
        <div class="loading-spinner"></div>
        <div class="loading-text">Loading...</div>
    </div>
</div>

<div class="shahblock-auth-container">
    <div class="shahblock-auth-card">
        <div class="shahblock-auth-header">
            <div class="shahblock-logo">
                <a href="<?php echo e(route('home')); ?>">
                    <div class="logo-icon">
                        <i class="fas fa-cube"></i>
                    </div>
                    <span class="logo-text"><?php echo e(setting('site_name', 'ShahBlock')); ?></span>
                </a>
            </div>
            <h1 class="shahblock-title"><?php echo e($data['title'] ?? 'Reset Password'); ?></h1>
            <p class="shahblock-subtitle"><?php echo e($data['bottom_text'] ?? 'Enter your email address and we\'ll send you a reset link'); ?></p>
        </div>

        <div class="shahblock-auth-form">
            <?php if($errors->any()): ?>
                <div class="shahblock-alert shahblock-alert-error">
                    <i class="fas fa-exclamation-triangle"></i>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span><?php echo e($error); ?></span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>

            <?php if(session('status')): ?>
                <div class="shahblock-alert shahblock-alert-success">
                    <i class="fas fa-check-circle"></i>
                    <span><?php echo e(session('status')); ?></span>
                </div>
            <?php endif; ?>

            <form action="<?php echo e(route('password.email')); ?>" method="POST" class="shahblock-form" id="forgotPasswordForm">
                <?php echo csrf_field(); ?>
                <div id="ajax-alert" style="display:none" class="shahblock-alert shahblock-alert-success"></div>
                
                <div class="shahblock-form-group">
                    <label for="email" class="shahblock-label">
                        <i class="fas fa-envelope"></i>
                        <?php echo e(__('Email Address')); ?>

                    </label>
                    <div class="shahblock-input-wrapper">
                        <input 
                            type="email" 
                            id="email" 
                            name="email" 
                            class="shahblock-input <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> shahblock-input-error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                            placeholder="<?php echo e(__('Enter your email address')); ?>"
                            value="<?php echo e(old('email')); ?>"
                            required
                            autofocus
                        >
                        <div class="shahblock-input-focus"></div>
                    </div>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="shahblock-error"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="shahblock-form-group">
                    <button type="submit" class="shahblock-btn shahblock-btn-primary">
                        <i class="fas fa-paper-plane"></i>
                        <span><?php echo e(__('Send Reset Link')); ?></span>
                        <div class="shahblock-btn-glow"></div>
                    </button>
                </div>
            </form>

            <div class="shahblock-auth-footer">
                <p class="shahblock-link-text">
                    <?php echo e(__('Remember your password?')); ?>

                    <a href="<?php echo e(route('login')); ?>" class="shahblock-link">
                        <i class="fas fa-sign-in-alt"></i>
                        <?php echo e(__('Login here')); ?>

                    </a>
                </p>
            </div>
        </div>
    </div>
</div>

<style>
/* ShahBlock Theme - Forgot Password Page */
:root {
    --bg: #060807;
    --bg2: #0a0f0d;
    --card: #0a100e;
    --stroke: #12301f;
    --text: #e8f7ef;
    --muted: #8fa39a;
    --brand: #22c55e;
    --brand2: #16a34a;
    --lime: #a3e635;
    --neon: #38f77b;
    --error: #ff4d5a;
    --success: #00ff88;
    --primary-color: #00ff88;
    --text-primary: #e8fff5;
}

/* ShahDeveloper Theme Preloader Styles */
#page-loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(10, 15, 18, 0.95);
    backdrop-filter: blur(10px);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 9999;
    opacity: 1;
    transition: opacity 0.3s ease;
}

#page-loading-overlay.loading-hide {
    opacity: 0;
    animation: loadingFadeOut 0.3s ease;
}

.loading-content {
    text-align: center;
    color: var(--text-primary);
}

.loading-spinner {
    width: 50px;
    height: 50px;
    border: 3px solid rgba(0, 255, 136, 0.2);
    border-top: 3px solid var(--primary-color);
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 0 auto 20px;
}

.loading-text {
    font-size: 16px;
    font-weight: 500;
    color: var(--text-primary);
    animation: loadingPulse 1.5s ease-in-out infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

@keyframes loadingPulse {
    0%, 100% {
        opacity: 0.6;
    }
    50% {
        opacity: 1;
    }
}

@keyframes loadingFadeOut {
    0% {
        opacity: 1;
    }
    100% {
        opacity: 0;
    }
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

html, body {
    background: radial-gradient(1200px 700px at 10% -10%, rgba(34,197,94,.12), transparent 50%),
                radial-gradient(1200px 700px at 110% 10%, rgba(56,247,123,.08), transparent 50%),
                linear-gradient(180deg, #050706, #0a0f0d);
    color: var(--text);
    font-family: 'Inter', system-ui, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
    min-height: 100vh;
    overflow-x: hidden;
}

.shahblock-auth-container {
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
    position: relative;
}

.shahblock-auth-container::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: 
        radial-gradient(800px 400px at 20% 20%, rgba(34,197,94,0.08), transparent 60%),
        radial-gradient(600px 300px at 80% 80%, rgba(56,247,123,0.06), transparent 60%);
    pointer-events: none;
}

.shahblock-auth-card {
    background: rgba(10, 16, 14, 0.85);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(34, 197, 94, 0.18);
    border-radius: 24px;
    padding: 48px;
    width: 100%;
    max-width: 480px;
    position: relative;
    box-shadow: 
        0 25px 60px rgba(0, 0, 0, 0.4),
        0 0 0 1px rgba(34, 197, 94, 0.1) inset,
        0 0 40px rgba(34, 197, 94, 0.08);
}

.shahblock-auth-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, rgba(34,197,94,0.03), transparent);
    border-radius: 24px;
    pointer-events: none;
}

.shahblock-auth-header {
    text-align: center;
    margin-bottom: 40px;
    position: relative;
    z-index: 2;
}

.shahblock-logo {
    margin-bottom: 32px;
}

.shahblock-logo a {
    display: inline-flex;
    align-items: center;
    gap: 12px;
    text-decoration: none;
    color: var(--text);
}

.logo-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    background: conic-gradient(from 120deg, var(--brand2), var(--brand), var(--lime));
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    color: #06140b;
    box-shadow: 
        0 0 28px rgba(34, 197, 94, 0.35),
        inset 0 0 18px rgba(34, 197, 94, 0.25);
}

.logo-text {
    font-size: 24px;
    font-weight: 800;
    letter-spacing: 0.5px;
    background: linear-gradient(135deg, var(--brand), var(--lime));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.shahblock-title {
    font-size: 32px;
    font-weight: 800;
    color: var(--text);
    margin-bottom: 12px;
    letter-spacing: -0.5px;
}

.shahblock-subtitle {
    color: var(--muted);
    font-size: 16px;
    line-height: 1.5;
    margin: 0;
}

.shahblock-auth-form {
    position: relative;
    z-index: 2;
}

.shahblock-form-group {
    margin-bottom: 24px;
}

.shahblock-label {
    display: flex;
    align-items: center;
    gap: 8px;
    font-weight: 600;
    color: var(--text);
    margin-bottom: 12px;
    font-size: 14px;
}

.shahblock-label i {
    color: var(--brand);
    font-size: 12px;
}

.shahblock-input-wrapper {
    position: relative;
}

.shahblock-input {
    width: 100%;
    padding: 16px 20px;
    background: rgba(10, 16, 14, 0.8);
    border: 2px solid rgba(34, 197, 94, 0.2);
    border-radius: 16px;
    color: var(--text);
    font-size: 16px;
    transition: all 0.3s ease;
    outline: none;
}

.shahblock-input::placeholder {
    color: var(--muted);
}

.shahblock-input:focus {
    border-color: var(--brand);
    box-shadow: 0 0 0 4px rgba(34, 197, 94, 0.1);
}

.shahblock-input:focus + .shahblock-input-focus {
    opacity: 1;
    transform: scale(1.02);
}

.shahblock-input-focus {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    border: 2px solid var(--brand);
    border-radius: 16px;
    opacity: 0;
    transition: all 0.3s ease;
    pointer-events: none;
}

.shahblock-input-error {
    border-color: var(--error);
}

.shahblock-error {
    color: var(--error);
    font-size: 12px;
    margin-top: 8px;
    display: block;
}

.shahblock-btn {
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 12px;
    width: 100%;
    padding: 16px 24px;
    border: none;
    border-radius: 16px;
    font-size: 16px;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    overflow: hidden;
    text-decoration: none;
}

.shahblock-btn-primary {
    background: linear-gradient(135deg, var(--brand2), var(--brand));
    color: #06140b;
    box-shadow: 
        0 14px 28px rgba(34, 197, 94, 0.25),
        0 0 0 1px rgba(34, 197, 94, 0.25) inset;
}

.shahblock-btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 
        0 20px 40px rgba(34, 197, 94, 0.35),
        0 0 0 1px rgba(34, 197, 94, 0.25) inset;
}

.shahblock-btn-glow {
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.6s ease;
}

.shahblock-btn:hover .shahblock-btn-glow {
    left: 100%;
}

.shahblock-alert {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 16px 20px;
    border-radius: 12px;
    margin-bottom: 24px;
    font-size: 14px;
    font-weight: 500;
}

.shahblock-alert-error {
    background: rgba(255, 77, 90, 0.1);
    border: 1px solid rgba(255, 77, 90, 0.3);
    color: var(--error);
}

.shahblock-alert-success {
    background: rgba(0, 255, 136, 0.1);
    border: 1px solid rgba(0, 255, 136, 0.3);
    color: var(--success);
}

.shahblock-auth-footer {
    text-align: center;
    margin-top: 32px;
    padding-top: 24px;
    border-top: 1px solid rgba(34, 197, 94, 0.1);
}

.shahblock-link-text {
    color: var(--muted);
    font-size: 14px;
    margin: 0;
}

.shahblock-link {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    color: var(--brand);
    text-decoration: none;
    font-weight: 600;
    margin-left: 8px;
    transition: all 0.3s ease;
}

.shahblock-link:hover {
    color: var(--lime);
    transform: translateX(2px);
}

/* Responsive Design */
@media (max-width: 640px) {
    .shahblock-auth-card {
        padding: 32px 24px;
        margin: 16px;
    }
    
    .shahblock-title {
        font-size: 28px;
    }
    
    .shahblock-subtitle {
        font-size: 14px;
    }
}
</style>

<script>
// ShahDeveloper Theme Preloader JavaScript
document.addEventListener('DOMContentLoaded', function() {
    const preloader = document.getElementById('page-loading-overlay');
    const form = document.getElementById('forgotPasswordForm');
    const ajaxAlert = document.getElementById('ajax-alert');
    
    if (preloader) {
        // Hide preloader after 1.5 seconds
        setTimeout(function() {
            preloader.classList.add('loading-hide');
            
            // Remove preloader from DOM after animation
            setTimeout(function() {
                preloader.style.display = 'none';
            }, 300);
        }, 1500);
    }

    if (form) {
        form.addEventListener('submit', async function(e){
            e.preventDefault();
            const submitBtn = form.querySelector('button[type="submit"]');
            const csrf = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
            ajaxAlert.style.display = 'none';
            ajaxAlert.className = 'shahblock-alert';
            try {
                submitBtn.disabled = true;
                submitBtn.style.opacity = '0.7';
                const resp = await fetch(form.action, {
                    method: 'POST',
                    headers: { 'Accept': 'application/json', 'X-CSRF-TOKEN': csrf },
                    body: new FormData(form)
                });
                const contentType = resp.headers.get('content-type') || '';
                if (resp.ok) {
                    let message = 'We have emailed your password reset link.';
                    if (contentType.includes('application/json')) {
                        const data = await resp.json().catch(()=>null);
                        if (data && (data.message || data.status)) message = data.message || data.status;
                    }
                    ajaxAlert.textContent = message;
                    ajaxAlert.className = 'shahblock-alert shahblock-alert-success';
                    ajaxAlert.style.display = 'flex';
                } else if (resp.status === 422) {
                    let errorsText = 'Please check your input.';
                    if (contentType.includes('application/json')) {
                        const data = await resp.json().catch(()=>null);
                        if (data && data.errors) {
                            errorsText = Object.values(data.errors).flat().join(' ');
                        }
                    }
                    ajaxAlert.textContent = errorsText;
                    ajaxAlert.className = 'shahblock-alert shahblock-alert-error';
                    ajaxAlert.style.display = 'flex';
                } else {
                    ajaxAlert.textContent = 'Something went wrong. Please try again.';
                    ajaxAlert.className = 'shahblock-alert shahblock-alert-error';
                    ajaxAlert.style.display = 'flex';
                }
            } catch (err) {
                ajaxAlert.textContent = 'Network error. Please try again.';
                ajaxAlert.className = 'shahblock-alert shahblock-alert-error';
                ajaxAlert.style.display = 'flex';
            } finally {
                if (submitBtn) { submitBtn.disabled = false; submitBtn.style.opacity = '1'; }
            }
        });
    }
});

// Hide preloader when page is fully loaded
window.addEventListener('load', function() {
    const preloader = document.getElementById('page-loading-overlay');
    
    if (preloader) {
        preloader.classList.add('loading-hide');
        
        // Remove preloader from DOM after animation
        setTimeout(function() {
            preloader.style.display = 'none';
        }, 300);
    }
});

// Force hide preloader after 3 seconds maximum
setTimeout(function() {
    const preloader = document.getElementById('page-loading-overlay');
    
    if (preloader) {
        preloader.classList.add('loading-hide');
        
        // Remove preloader from DOM after animation
        setTimeout(function() {
            preloader.style.display = 'none';
        }, 300);
    }
}, 3000);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/frontend/shahdeveloper/auth/forgot-password.blade.php ENDPATH**/ ?>