<h3 class="title mb-4">
    <?php echo e(__('Withdraw Approval Action')); ?>

</h3>

<ul class="list-group mb-4">
    <li class="list-group-item">
        <?php echo e(__('Withdraw Amount')); ?>: <strong><?php echo e($data->amount .' '. $currency); ?></strong>
    </li>
    <li class="list-group-item">
        <?php echo e(__('Pay Amount')); ?>: <strong><?php echo e($data->pay_amount .' '. $data->pay_currency); ?></strong>
    </li>
</ul>

<ul class="list-group mb-4">
    <?php
        // Check both manual_field_data and details fields
        $manualData = json_decode($data->manual_field_data, true);
        $detailsData = json_decode($data->details, true);
        $isSimpleWithdraw = str_contains($data->method ?? '', 'SIMPLE-');
        
        // Use details data if manual_field_data is null
        if (!$manualData && $detailsData) {
            $manualData = $detailsData;
        }
        
        // Debug: Enable to see actual data
        if(false) {
            echo "<div style='background: #f0f0f0; padding: 10px; margin: 10px 0; border: 1px solid #ccc;'>";
            echo "<h4>DEBUG: Raw Data</h4>";
            echo "<pre>Method: " . ($data->method ?? 'null') . "</pre>";
            echo "<pre>Manual Field Data (raw): " . htmlspecialchars($data->manual_field_data ?? 'null') . "</pre>";
            echo "<pre>Details Data (raw): " . htmlspecialchars($data->details ?? 'null') . "</pre>";
            echo "<pre>Manual Field Data (decoded): " . print_r($manualData, true) . "</pre>";
            echo "<pre>Is Simple Withdraw: " . ($isSimpleWithdraw ? 'true' : 'false') . "</pre>";
            echo "</div>";
        }
    ?>
    
    <?php if($isSimpleWithdraw): ?>
        
        <li class="list-group-item bg-success text-white text-center">
            <strong>🚀 <?php echo e(__('Simple Withdraw Method')); ?>: <?php echo e(str_replace('SIMPLE-', '', $data->method ?? '')); ?></strong>
        </li>
        
        <?php if($manualData && is_array($manualData)): ?>
            
            <?php if(isset($manualData['method_type'])): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Method Type:</strong>
                    <span class="badge bg-primary fs-6">
                        <?php if($manualData['method_type'] == 'crypto'): ?>
                            🚀 Cryptocurrency
                        <?php else: ?>
                            🏦 Banking Services
                        <?php endif; ?>
                    </span>
                </li>
            <?php endif; ?>
            
            <?php if(isset($manualData['crypto_method'])): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Crypto Method:</strong>
                    <span class="badge bg-success fs-6">💰 <?php echo e(ucfirst($manualData['crypto_method'])); ?></span>
                </li>
            <?php endif; ?>
            
            <?php if(isset($manualData['banking_method'])): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Banking Method:</strong>
                    <span class="badge bg-info fs-6">🏦 <?php echo e(ucfirst($manualData['banking_method'])); ?></span>
                </li>
            <?php endif; ?>
            
            <?php if(isset($manualData['wallet'])): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Selected Wallet:</strong>
                    <span class="badge bg-warning text-dark fs-6">
                        <?php if($manualData['wallet'] == 'main'): ?>
                            💳 Main Wallet
                        <?php else: ?>
                            📈 Profit Wallet
                        <?php endif; ?>
                    </span>
                </li>
            <?php endif; ?>
            
            
            <?php if(isset($manualData['wallet_address'])): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Wallet Address:</strong>
                    <span class="badge bg-primary fs-6">🔗 <?php echo e($manualData['wallet_address']); ?></span>
                </li>
            <?php endif; ?>
            
            <?php if(isset($manualData['network_type'])): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Network Type:</strong>
                    <span class="badge bg-secondary fs-6">🌐 <?php echo e(ucfirst($manualData['network_type'])); ?></span>
                </li>
            <?php endif; ?>
            
            
            <?php if(isset($manualData['account_title'])): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Account Title:</strong>
                    <span class="badge bg-success fs-6">👤 <?php echo e($manualData['account_title']); ?></span>
                </li>
            <?php endif; ?>
            
            <?php if(isset($manualData['account_number'])): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Account Number:</strong>
                    <span class="badge bg-info fs-6">📱 <?php echo e($manualData['account_number']); ?></span>
                </li>
            <?php endif; ?>
            
            <?php if(isset($manualData['bank_name'])): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Bank Name:</strong>
                    <span class="badge bg-dark fs-6">🏛️ <?php echo e($manualData['bank_name']); ?></span>
                </li>
            <?php endif; ?>
            
            <?php if(isset($manualData['branch_code'])): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Branch Code:</strong>
                    <span class="badge bg-warning text-dark fs-6">🏦 <?php echo e($manualData['branch_code']); ?></span>
                </li>
            <?php endif; ?>
            
            
            <?php if(isset($manualData['mobile_number'])): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Mobile Number:</strong>
                    <span class="badge bg-primary fs-6">📱 <?php echo e($manualData['mobile_number']); ?></span>
                </li>
            <?php endif; ?>
            
            <?php if(isset($manualData['account_name'])): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <strong>Account Name:</strong>
                    <span class="badge bg-success fs-6">👤 <?php echo e($manualData['account_name']); ?></span>
                </li>
            <?php endif; ?>
            
            
            <?php $__currentLoopData = $manualData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fieldName => $fieldValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(!in_array($fieldName, ['method_type', 'crypto_method', 'banking_method', 'wallet', 'wallet_address', 'network_type', 'account_title', 'account_number', 'bank_name', 'branch_code', 'mobile_number', 'account_name'])): ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <strong><?php echo e(ucfirst(str_replace('_', ' ', $fieldName))); ?>:</strong>
                        <span class="badge bg-secondary fs-6"><?php echo e($fieldValue); ?></span>
                    </li>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <li class="list-group-item">
                <span class="text-muted"><?php echo e(__('No account details provided')); ?></span>
            </li>
        <?php endif; ?>
    <?php else: ?>
        
        <?php if($manualData && is_array($manualData)): ?>
            <?php $__currentLoopData = $manualData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $fieldData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="list-group-item">
                    <?php echo e($name); ?>: 
                    <?php if(is_array($fieldData) && isset($fieldData['type']) && $fieldData['type'] == 'file'): ?>
                        <img src="<?php echo e(asset(data_get($fieldData, 'value'))); ?>" alt="<?php echo e($name); ?>" style="max-width: 200px;"/>
                    <?php elseif(is_array($fieldData)): ?>
                        <strong><?php echo e(data_get($fieldData, 'value')); ?></strong>
                    <?php else: ?>
                        <strong><?php echo e($fieldData); ?></strong>
                    <?php endif; ?>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <li class="list-group-item">
                <span class="text-muted"><?php echo e(__('No withdrawal details available')); ?></span>
            </li>
        <?php endif; ?>
    <?php endif; ?>
</ul>

<form action="<?php echo e(route('admin.withdraw.action.now')); ?>" method="post">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="id" value="<?php echo e($id); ?>">

    <div class="site-input-groups">
        <label for="" class="box-input-label"><?php echo e(__('Details Message(Optional)')); ?></label>
        <textarea name="message" class="form-textarea mb-0" placeholder="Details Message"></textarea>
    </div>

    <div class="action-btns">
        <button type="submit" name="approve" value="yes" class="site-btn-sm primary-btn me-2">
            <i icon-name="check"></i>
            <?php echo e(__('Approve')); ?>

        </button>
        <button type="submit" name="reject" value="yes" class="site-btn-sm red-btn">
            <i icon-name="x"></i>
            <?php echo e(__('Reject')); ?>

        </button>
    </div>

</form>

<script>
    'use strict';
    lucide.createIcons();
</script>






<?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/backend/withdraw/include/__withdraw_action.blade.php ENDPATH**/ ?>